/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.me.lucko.jarrelocator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kr.toxicity.hud.shaded.me.lucko.jarrelocator.SelectorUtils;

public final class Relocation {
    private final String pattern;
    private final String relocatedPattern;
    private final String pathPattern;
    private final String relocatedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;

    public Relocation(String pattern, String relocatedPattern, Collection<String> includes, Collection<String> excludes) {
        this.pattern = pattern.replace('/', '.');
        this.pathPattern = pattern.replace('.', '/');
        this.relocatedPattern = relocatedPattern.replace('/', '.');
        this.relocatedPathPattern = relocatedPattern.replace('.', '/');
        if (includes != null && !includes.isEmpty()) {
            this.includes = Relocation.normalizePatterns(includes);
            this.includes.addAll(includes);
        } else {
            this.includes = null;
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes = Relocation.normalizePatterns(excludes);
            this.excludes.addAll(excludes);
        } else {
            this.excludes = null;
        }
    }

    public Relocation(String pattern, String relocatedPattern) {
        this(pattern, relocatedPattern, Collections.emptyList(), Collections.emptyList());
    }

    private boolean isIncluded(String path) {
        if (this.includes == null) {
            return true;
        }
        for (String include : this.includes) {
            if (!SelectorUtils.matchPath(include, path, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String path) {
        if (this.excludes == null) {
            return false;
        }
        for (String exclude : this.excludes) {
            if (!SelectorUtils.matchPath(exclude, path, true)) continue;
            return true;
        }
        return false;
    }

    boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!this.isIncluded(path) || this.isExcluded(path)) {
            return false;
        }
        return path.startsWith(this.pathPattern) || path.startsWith("/" + this.pathPattern);
    }

    boolean canRelocateClass(String clazz) {
        return clazz.indexOf(47) == -1 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.relocatedPathPattern);
    }

    String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.relocatedPattern);
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = new LinkedHashSet<String>();
        for (String pattern : patterns) {
            String classPattern = pattern.replace('.', '/');
            normalized.add(classPattern);
            if (!classPattern.endsWith("/*")) continue;
            String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
            normalized.add(packagePattern);
        }
        return normalized;
    }
}

