/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.configuration;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.hud.api.BetterHudAPI;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.configuration.HudComponentSupplier;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.update.UpdateEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record HudObjectType<T extends HudObject>(@NotNull Class<T> clazz, @NotNull String name, @NotNull BiFunction<T, HudPlayer, HudComponentSupplier<T>> function, @NotNull Function<String, T> stringGetter, @NotNull Supplier<Collection<T>> valuesSupplier) {
    private static final Map<String, HudObjectType<?>> TYPE_MAP = new HashMap();
    private static final Map<String, HudObjectType<?>> TYPE_MAP_VIEW = Collections.unmodifiableMap(TYPE_MAP);
    public static final HudObjectType<Hud> HUD = new HudObjectType<Hud>(Hud.class, "hud", Hud::createRenderer, BetterHudAPI.inst().getHudManager()::getHud, BetterHudAPI.inst().getHudManager()::getAllHuds);
    public static final HudObjectType<Popup> POPUP = new HudObjectType<Popup>(Popup.class, "popup", (popup, player) -> HudComponentSupplier.of(popup, () -> {
        popup.show(UpdateEvent.EMPTY, (HudPlayer)player);
        return Collections.emptyList();
    }), BetterHudAPI.inst().getPopupManager()::getPopup, BetterHudAPI.inst().getPopupManager()::getAllPopups);
    public static final HudObjectType<Compass> COMPASS = new HudObjectType<Compass>(Compass.class, "compass", Compass::indicate, BetterHudAPI.inst().getCompassManager()::getCompass, BetterHudAPI.inst().getCompassManager()::getAllCompasses);

    public HudObjectType(@NotNull Class<T> clazz, @NotNull String name, @NotNull BiFunction<T, HudPlayer, HudComponentSupplier<T>> function, @NotNull Function<String, T> stringGetter, @NotNull Supplier<Collection<T>> valuesSupplier) {
        TYPE_MAP.put(name, this);
        this.clazz = clazz;
        this.name = name;
        this.function = function;
        this.stringGetter = stringGetter;
        this.valuesSupplier = valuesSupplier;
    }

    @NotNull
    public static @Unmodifiable Collection<HudObjectType<?>> types() {
        return TYPE_MAP_VIEW.values();
    }

    @Nullable
    public T byName(@NotNull String name) {
        return (T)((HudObject)this.stringGetter.apply(name));
    }

    @NotNull
    public @Unmodifiable Collection<T> all() {
        return this.valuesSupplier.get();
    }

    @NotNull
    public Stream<T> defaultObjects() {
        return this.all().stream().filter(HudObject::isDefault);
    }

    @ApiStatus.Internal
    @NotNull
    public HudComponentSupplier<?> invoke(@NotNull HudObject object, @NotNull HudPlayer player) {
        try {
            return this.function.apply((HudObject)this.clazz.cast(object), player);
        }
        catch (Throwable e) {
            return HudComponentSupplier.empty(object);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof HudObjectType)) {
            return false;
        }
        HudObjectType that = (HudObjectType)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

