/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.equation;

import java.util.Arrays;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.collections.SetsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.math.MathKt;
import kr.toxicity.hud.shaded.net.objecthunter.exp4j.Expression;
import kr.toxicity.hud.shaded.net.objecthunter.exp4j.ExpressionBuilder;
import kr.toxicity.hud.shaded.net.objecthunter.exp4j.function.Function;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0086\u0004J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0086\u0004R\u0016\u0010\u0002\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkr/toxicity/hud/equation/TEquation;", "", "expression", "", "<init>", "(Ljava/lang/String;)V", "Lkr/toxicity/hud/shaded/net/objecthunter/exp4j/Expression;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "evaluate", "", "t", "evaluateToInt", "", "Companion", "dist"})
public final class TEquation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Expression expression;
    @NotNull
    private static final Function[] builtInFunction;
    @NotNull
    private static final TEquation t;
    @NotNull
    private static final TEquation one;
    @NotNull
    private static final TEquation zero;

    public TEquation(@NotNull String expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Object[] objectArray = builtInFunction;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(expression).functions(Arrays.copyOf(objectArray, objectArray.length));
        objectArray = new String[]{"t", "pi", "e"};
        this.expression = expressionBuilder.variables(SetsKt.setOf(objectArray)).build();
    }

    public final double evaluate(double t) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("t", t), TuplesKt.to("pi", Math.PI), TuplesKt.to("e", Math.E)};
        return new Expression(this.expression).setVariables(MapsKt.mapOf(pairArray)).evaluate();
    }

    public final int evaluateToInt(double t) {
        return MathKt.roundToInt(this.evaluate(t));
    }

    static {
        Function[] functionArray = new Function[]{new Function(){

            public double apply(double ... p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return Math.min(p0[0], p0[1]);
            }
        }, new Function(){

            public double apply(double ... p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return Math.max(p0[0], p0[1]);
            }
        }, new Function(){

            public double apply(double ... p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return Math.clamp(p0[0], p0[1], p0[2]);
            }
        }};
        builtInFunction = functionArray;
        t = new TEquation("t");
        one = new TEquation("1");
        zero = new TEquation("0");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/hud/equation/TEquation$Companion;", "", "<init>", "()V", "builtInFunction", "", "Lkr/toxicity/hud/shaded/net/objecthunter/exp4j/function/Function;", "[Lkr/toxicity/hud/shaded/net/objecthunter/exp4j/function/Function;", "t", "Lkr/toxicity/hud/equation/TEquation;", "getT", "()Lkr/toxicity/hud/equation/TEquation;", "one", "getOne", "zero", "getZero", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TEquation getT() {
            return t;
        }

        @NotNull
        public final TEquation getOne() {
            return one;
        }

        @NotNull
        public final TEquation getZero() {
            return zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

