/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kr.toxicity.hud.shaded.kotlin.ExceptionsKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a*\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00060\t\u001a*\u0010\n\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000b2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\f0\t\u001a*\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00060\t\u001a>\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00060\t\u00a8\u0006\u000e"}, d2={"split", "", "T", "splitSize", "", "forEachAsync", "", "", "block", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "removeIfSync", "", "", "multiplier", "dist"})
@SourceDebugExtension(value={"SMAP\nLists.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lists.kt\nkr/toxicity/hud/util/ListsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n1563#2:91\n1634#2,3:92\n1563#2:95\n1634#2,3:96\n1869#2,2:101\n37#3,2:99\n*S KotlinDebug\n*F\n+ 1 Lists.kt\nkr/toxicity/hud/util/ListsKt\n*L\n41#1:91\n41#1:92,3\n73#1:95\n73#1:96,3\n53#1:101,2\n77#1:99,2\n*E\n"})
public final class ListsKt {
    @NotNull
    public static final <T> List<List<T>> split(@NotNull List<? extends T> $this$split, int splitSize) {
        Intrinsics.checkNotNullParameter($this$split, "<this>");
        ArrayList result = new ArrayList();
        for (int index = 0; index < $this$split.size(); index += splitSize) {
            List<? extends T> subList = $this$split.subList(index, RangesKt.coerceAtMost(index + splitSize, $this$split.size()));
            if (!(!((Collection)subList).isEmpty())) continue;
            ((Collection)result).add(subList);
        }
        return result;
    }

    public static final <T> void forEachAsync(@NotNull Collection<? extends T> $this$forEachAsync, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter($this$forEachAsync, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        ListsKt.forEachAsync(CollectionsKt.toList((Iterable)$this$forEachAsync), block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> void removeIfSync(@NotNull Collection<T> $this$removeIfSync, @NotNull Function1<? super T, Boolean> block) {
        Intrinsics.checkNotNullParameter($this$removeIfSync, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        Collection<T> collection = $this$removeIfSync;
        synchronized (collection) {
            boolean bl = false;
            Iterator<T> iterator2 = $this$removeIfSync.iterator();
            while (iterator2.hasNext()) {
                if (!block.invoke(iterator2.next()).booleanValue()) continue;
                iterator2.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final <T> void forEachAsync(@NotNull List<? extends T> $this$forEachAsync, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter($this$forEachAsync, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        ListsKt.forEachAsync($this$forEachAsync, ListsKt::forEachAsync$lambda$0, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final <T> void forEachAsync(@NotNull List<? extends T> $this$forEachAsync, @NotNull Function1<? super Integer, Integer> multiplier, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter($this$forEachAsync, "<this>");
        Intrinsics.checkNotNullParameter(multiplier, "multiplier");
        Intrinsics.checkNotNullParameter(block, "block");
        if (!((Collection)$this$forEachAsync).isEmpty()) {
            List list;
            Iterable it;
            String[] stringArray;
            int available = RangesKt.coerceAtMost(RangesKt.coerceAtLeast(((Number)multiplier.invoke((Integer)Runtime.getRuntime().availableProcessors())).intValue(), 4), 256);
            if (available >= $this$forEachAsync.size()) {
                void $this$mapTo$iv$iv;
                String[] $this$map$iv = (String[])$this$forEachAsync;
                boolean $i$f$map = false;
                stringArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator2.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(() -> ListsKt.forEachAsync$lambda$1$0(block, it));
                }
                list = (List)destination$iv$iv;
            } else {
                ArrayList queue = new ArrayList();
                int add = $this$forEachAsync.size() / available;
                for (int i = 0; i <= $this$forEachAsync.size(); i += add) {
                    List<? extends T> get2 = $this$forEachAsync.subList(i, RangesKt.coerceAtMost(i + add, $this$forEachAsync.size()));
                    ((Collection)queue).add(() -> ListsKt.forEachAsync$lambda$2(get2, block));
                }
                list = queue;
            }
            List tasks = list;
            try {
                AtomicInteger integer = new AtomicInteger();
                AutoCloseable i = Executors.newFixedThreadPool(tasks.size(), arg_0 -> ListsKt.forEachAsync$lambda$3(integer, arg_0));
                stringArray = null;
                try {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    ExecutorService pool = (ExecutorService)i;
                    boolean bl = false;
                    Iterable $this$map$iv = tasks;
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Function0 function0 = (Function0)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(CompletableFuture.runAsync(() -> ListsKt.forEachAsync$lambda$4$0$0((Function0)it2), pool));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
                    Void void_ = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length)).join();
                }
                catch (Throwable throwable) {
                    stringArray = throwable;
                    throw throwable;
                }
                finally {
                    AutoCloseableKt.closeFinally(i, (Throwable)stringArray);
                }
            }
            catch (OutOfMemoryError error) {
                stringArray = new String[]{"Async task failed!", "You have to set your Linux max thread limit!", "", "Stack trace:", ExceptionsKt.stackTraceToString(error)};
                PluginsKt.warn(stringArray);
            }
        }
    }

    private static final int forEachAsync$lambda$0(int it) {
        return it;
    }

    private static final Unit forEachAsync$lambda$1$0(Function1 $block, Object $it) {
        $block.invoke($it);
        return Unit.INSTANCE;
    }

    private static final Unit forEachAsync$lambda$2(List $get, Function1 $block) {
        Iterable $this$forEach$iv = $get;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator2.next();
            boolean bl = false;
            $block.invoke(t);
        }
        return Unit.INSTANCE;
    }

    private static final Thread forEachAsync$lambda$3(AtomicInteger $integer, Runnable it) {
        Thread thread2;
        Thread $this$forEachAsync_u24lambda_u243_u240 = thread2 = new Thread(it);
        boolean bl = false;
        $this$forEachAsync_u24lambda_u243_u240.setDaemon(true);
        $this$forEachAsync_u24lambda_u243_u240.setName("BetterHud-Worker-" + $integer.getAndIncrement());
        $this$forEachAsync_u24lambda_u243_u240.setUncaughtExceptionHandler(ListsKt::forEachAsync$lambda$3$0$0);
        return thread2;
    }

    private static final void forEachAsync$lambda$3$0$0(Thread thread2, Throwable exception) {
        Intrinsics.checkNotNull(exception);
        FunctionsKt.handle(exception, "A error has been occurred in " + thread2.getName());
    }

    private static final void forEachAsync$lambda$4$0$0(Function0 $it) {
        $it.invoke();
    }
}

