/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.player;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.adapter.LocationWrapper;
import kr.toxicity.hud.api.adapter.WorldWrapper;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.component.WidthComponent;
import kr.toxicity.hud.api.configuration.HudComponentSupplier;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.player.HudPlayerHead;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.popup.PopupIteratorGroup;
import kr.toxicity.hud.api.popup.PopupUpdater;
import net.kyori.adventure.bossbar.BossBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HudPlayer
extends BetterCommandSource {
    @NotNull
    public UUID uuid();

    @NotNull
    public String name();

    @NotNull
    public LocationWrapper location();

    @NotNull
    public WorldWrapper world();

    @NotNull
    public HudPlayerHead getHead();

    @NotNull
    public Object handle();

    @NotNull
    public WidthComponent getHudComponent();

    public void setAdditionalComponent(@Nullable WidthComponent var1);

    @Nullable
    public WidthComponent getAdditionalComponent();

    public boolean isHudEnabled();

    public void setHudEnabled(boolean var1);

    public long getTick();

    public void cancel();

    public void update();

    public void startTick();

    public void cancelTick();

    @NotNull
    public Map<String, PopupIteratorGroup> getPopupGroupIteratorMap();

    @NotNull
    public Map<String, String> getVariableMap();

    @NotNull
    public Map<Object, PopupUpdater> getPopupKeyMap();

    @Nullable
    public BossBar.Color getBarColor();

    @NotNull
    public Map<HudObject.Identifier, HudComponentSupplier<?>> getHudObjects();

    @NotNull
    default public Set<Popup> getPopups() {
        return this.getHudObjects().values().stream().map(o -> {
            Popup popup;
            Object patt0$temp = o.parent();
            return patt0$temp instanceof Popup ? (popup = (Popup)patt0$temp) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    default public Set<Hud> getHuds() {
        return this.getHudObjects().values().stream().map(o -> {
            Hud hud;
            Object patt0$temp = o.parent();
            return patt0$temp instanceof Hud ? (hud = (Hud)patt0$temp) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    default public Set<Compass> getCompasses() {
        return this.getHudObjects().values().stream().map(o -> {
            Compass compass;
            Object patt0$temp = o.parent();
            return patt0$temp instanceof Compass ? (compass = (Compass)patt0$temp) : null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @NotNull
    public Set<PointedLocation> getPointedLocation();

    public void reload();

    public void save();

    public void setBarColor(@Nullable BossBar.Color var1);

    @NotNull
    public Set<PointedLocation> pointers();
}

