/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.bootstrap.bukkit.player;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kr.toxicity.hud.api.BetterHudBootstrap;
import kr.toxicity.hud.api.adapter.LocationWrapper;
import kr.toxicity.hud.api.adapter.WorldWrapper;
import kr.toxicity.hud.bootstrap.bukkit.BukkitBootstrapImpl;
import kr.toxicity.hud.player.HudPlayerImpl;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.PluginsKt;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0016\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkr/toxicity/hud/bootstrap/bukkit/player/HudPlayerBukkit;", "Lkr/toxicity/hud/player/HudPlayerImpl;", "player", "Lorg/bukkit/entity/Player;", "audience", "Lnet/kyori/adventure/audience/Audience;", "<init>", "(Lorg/bukkit/entity/Player;Lnet/kyori/adventure/audience/Audience;)V", "uuid", "Ljava/util/UUID;", "name", "", "handle", "", "world", "Lkr/toxicity/hud/api/adapter/WorldWrapper;", "locale", "Ljava/util/Locale;", "location", "Lkr/toxicity/hud/api/adapter/LocationWrapper;", "updatePlaceholder", "", "reload", "initBossBar", "action", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "hasPermission", "", "perm", "bukkit"})
@SourceDebugExtension(value={"SMAP\nHudPlayerBukkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudPlayerBukkit.kt\nkr/toxicity/hud/bootstrap/bukkit/player/HudPlayerBukkit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1761#2,3:81\n1869#2,2:84\n*S KotlinDebug\n*F\n+ 1 HudPlayerBukkit.kt\nkr/toxicity/hud/bootstrap/bukkit/player/HudPlayerBukkit\n*L\n64#1:81,3\n73#1:84,2\n*E\n"})
public final class HudPlayerBukkit
extends HudPlayerImpl {
    @NotNull
    private final Player player;
    @NotNull
    private final Audience audience;

    public HudPlayerBukkit(@NotNull Player player, @NotNull Audience audience) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(audience, "audience");
        this.player = player;
        this.audience = audience;
        this.initBossBar(() -> HudPlayerBukkit._init_$lambda$2(this));
    }

    @Override
    @NotNull
    public UUID uuid() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        return uUID;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.player.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @Override
    @NotNull
    public Object handle() {
        return this.player;
    }

    @Override
    @NotNull
    public Audience audience() {
        return this.audience;
    }

    @Override
    @NotNull
    public WorldWrapper world() {
        return new WorldWrapper(this.player.getWorld().getName());
    }

    @Override
    @NotNull
    public Locale locale() {
        Locale locale;
        String it = this.player.getLocale();
        boolean bl = false;
        Intrinsics.checkNotNull(it);
        char[] cArray = new char[]{'_'};
        List split = StringsKt.split$default((CharSequence)it, cArray, false, 0, 6, null);
        if (split.size() == 1) {
            String string = ((String)split.get(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            locale = Locale.of(string);
        } else {
            String string = ((String)split.get(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String string2 = ((String)split.get(1)).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            locale = Locale.of(string, string2);
        }
        Intrinsics.checkNotNullExpressionValue(locale, "let(...)");
        return locale;
    }

    @Override
    @NotNull
    public LocationWrapper location() {
        Location location = this.player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location loc = location;
        return new LocationWrapper(this.world(), loc.getX(), loc.getY(), loc.getZ(), loc.getPitch(), loc.getYaw());
    }

    @Override
    protected void updatePlaceholder() {
        BetterHudBootstrap betterHudBootstrap = PluginsKt.getBOOTSTRAP();
        Intrinsics.checkNotNull(betterHudBootstrap, "null cannot be cast to non-null type kr.toxicity.hud.bootstrap.bukkit.BukkitBootstrapImpl");
        ((BukkitBootstrapImpl)betterHudBootstrap).update(this);
    }

    @Override
    public void reload() {
        this.initBossBar(() -> HudPlayerBukkit.reload$lambda$1(this));
    }

    private final void initBossBar(Function0<Unit> action) {
        ArrayList bars = new ArrayList();
        Iterator iterator2 = Bukkit.getBossBars();
        Intrinsics.checkNotNullExpressionValue(iterator2, "getBossBars(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            boolean bl;
            KeyedBossBar bossBar;
            block4: {
                bossBar = (KeyedBossBar)iterator3.next();
                List list = bossBar.getPlayers();
                Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Player it = (Player)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getUniqueId(), this.player.getUniqueId())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            bossBar.removePlayer(this.player);
            ((Collection)bars).add(bossBar);
        }
        action.invoke();
        PluginsKt.asyncTaskLater(20L, () -> HudPlayerBukkit.initBossBar$lambda$5(bars, this));
    }

    @Override
    public boolean hasPermission(@NotNull String perm) {
        Intrinsics.checkNotNullParameter(perm, "perm");
        return this.player.hasPermission(perm);
    }

    private static final Unit reload$lambda$1(HudPlayerBukkit this$0) {
        super.reload();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(HudPlayerBukkit this$0) {
        this$0.inject();
        return Unit.INSTANCE;
    }

    private static final Unit initBossBar$lambda$5(ArrayList $bars, HudPlayerBukkit this$0) {
        Iterable $this$forEach$iv = $bars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BossBar it = (BossBar)element$iv;
            boolean bl = false;
            it.addPlayer(this$0.player);
        }
        return Unit.INSTANCE;
    }
}

