/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.manager.ConfigManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackFile;
import kr.toxicity.hud.pack.PackMeta;
import kr.toxicity.hud.pack.PackType;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Ref;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ListsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/pack/PackGenerator;", "", "<init>", "()V", "tasks", "Ljava/util/TreeMap;", "", "Lkr/toxicity/hud/pack/PackFile;", "generate", "", "", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "addTask", "", "dir", "", "byteArray", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "dist"})
@SourceDebugExtension(value={"SMAP\nPackGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1869#2,2:73\n*S KotlinDebug\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n*L\n16#1:73,2\n*E\n"})
public final class PackGenerator {
    @NotNull
    public static final PackGenerator INSTANCE = new PackGenerator();
    @NotNull
    private static final TreeMap<String, PackFile> tasks = new TreeMap();

    private PackGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, byte[]> generate(@NotNull ReloadInfo info) {
        Map map;
        Map $this$generate_u24lambda_u2413;
        Intrinsics.checkNotNullParameter(info, "info");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        BetterCommandSource sender = betterCommandSource;
        Map map2 = this;
        try {
            Map map3;
            Object $this$generate_u24lambda_u2413_u24lambda_u2411;
            $this$generate_u24lambda_u2413 = map2;
            boolean bl = false;
            Ref.ObjectRef meta = new Ref.ObjectRef();
            meta.element = PackMeta.Companion.getDefault();
            Iterable $this$forEach$iv = ConfigManagerImpl.INSTANCE.getMergeOtherFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                File file = PluginsKt.getDATA_FOLDER().getParentFile();
                Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
                File mergeTarget = FilesKt.subFolder(file, it);
                int mergeLength = mergeTarget.getPath().length() + 1;
                FilesKt.forEach(mergeTarget, arg_0 -> PackGenerator.generate$lambda$13$lambda$6$lambda$5($this$generate_u24lambda_u2413, meta, mergeLength, arg_0));
            }
            Map map4 = $this$generate_u24lambda_u2413;
            try {
                Map<String, byte[]> map5;
                $this$generate_u24lambda_u2413_u24lambda_u2411 = map4;
                boolean bl3 = false;
                AutoCloseable autoCloseable = ConfigManagerImpl.INSTANCE.getPackType().createGenerator((PackMeta)meta.element, info);
                Throwable throwable = null;
                try {
                    PackType.Generator saveTask = (PackType.Generator)autoCloseable;
                    boolean bl4 = false;
                    Collection<PackFile> collection = tasks.values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    ListsKt.forEachAsync(collection, arg_0 -> PackGenerator.generate$lambda$13$lambda$11$lambda$10$lambda$9($this$generate_u24lambda_u2413_u24lambda_u2411, saveTask, sender, arg_0));
                    map5 = saveTask.getResourcePack();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                $this$generate_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl(map5);
            }
            catch (Throwable bl3) {
                $this$generate_u24lambda_u2413_u24lambda_u2411 = Result.constructor-impl(ResultKt.createFailure(bl3));
            }
            map4 = $this$generate_u24lambda_u2413_u24lambda_u2411;
            Throwable throwable = Result.exceptionOrNull-impl(map4);
            if (throwable == null) {
                map3 = map4;
            } else {
                Throwable it = throwable;
                boolean bl5 = false;
                FunctionsKt.handle(it, sender, "Unable to finalized resource pack build.");
                map3 = MapsKt.emptyMap();
            }
            $this$generate_u24lambda_u2413 = Result.constructor-impl(map3);
        }
        catch (Throwable bl) {
            $this$generate_u24lambda_u2413 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        map2 = $this$generate_u24lambda_u2413;
        Throwable throwable = Result.exceptionOrNull-impl(map2);
        if (throwable == null) {
            map = map2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            FunctionsKt.handle(it, sender, "Unable to make a resource pack.");
            map = MapsKt.emptyMap();
        }
        Map resourcePack = map;
        tasks.clear();
        return resourcePack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(@NotNull Iterable<String> dir, @NotNull Function0<byte[]> byteArray) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        String str = CollectionsKt.joinToString$default(dir, "/", null, null, 0, null, null, 62, null);
        TreeMap<String, PackFile> treeMap = tasks;
        synchronized (treeMap) {
            boolean bl = false;
            PackFile packFile = tasks.computeIfAbsent(str, arg_0 -> PackGenerator.addTask$lambda$17$lambda$16(arg_0 -> PackGenerator.addTask$lambda$17$lambda$15(str, byteArray, arg_0), arg_0));
        }
    }

    private static final Unit generate$lambda$13$lambda$6$addFile$lambda$0(PackGenerator $this_runCatching, int $mergeLength, File t) {
        Intrinsics.checkNotNullParameter(t, "t");
        PackGenerator.generate$lambda$13$lambda$6$addFile($this_runCatching, $mergeLength, t);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] generate$lambda$13$lambda$6$addFile$lambda$2(File $target) {
        byte[] byArray;
        Closeable closeable = new FileInputStream($target);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            byArray = stream.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        return byArray;
    }

    private static final void generate$lambda$13$lambda$6$addFile(PackGenerator $this_runCatching, int mergeLength, File target) {
        if (target.isDirectory()) {
            FilesKt.forEach(target, arg_0 -> PackGenerator.generate$lambda$13$lambda$6$addFile$lambda$0($this_runCatching, mergeLength, arg_0));
        } else {
            String string = target.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            String string2 = string.substring(mergeLength);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            char[] cArray = new char[]{File.separatorChar};
            $this_runCatching.addTask(StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null), () -> PackGenerator.generate$lambda$13$lambda$6$addFile$lambda$2(target));
        }
    }

    private static final Unit generate$lambda$13$lambda$6$lambda$5(PackGenerator $this_runCatching, Ref.ObjectRef $meta, int $mergeLength, File target) {
        Intrinsics.checkNotNullParameter(target, "target");
        if (Intrinsics.areEqual(target.getName(), "pack.mcmeta")) {
            Object $this$generate_u24lambda_u2413_u24lambda_u246_u24lambda_u245_u24lambda_u243;
            Object object = $this_runCatching;
            try {
                $this$generate_u24lambda_u2413_u24lambda_u246_u24lambda_u245_u24lambda_u243 = object;
                boolean bl = false;
                $meta.element = ((PackMeta)$meta.element).plus(PackMeta.Companion.fromFile(target));
                $this$generate_u24lambda_u2413_u24lambda_u246_u24lambda_u245_u24lambda_u243 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$generate_u24lambda_u2413_u24lambda_u246_u24lambda_u245_u24lambda_u243 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object = $this$generate_u24lambda_u2413_u24lambda_u246_u24lambda_u245_u24lambda_u243;
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                FunctionsKt.handle(it, "Invalid pack.mcmeta: " + target.getPath());
            }
        } else {
            PackGenerator.generate$lambda$13$lambda$6$addFile($this_runCatching, $mergeLength, target);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generate$lambda$13$lambda$11$lambda$10$lambda$9(PackGenerator $this_runCatching, PackType.Generator $saveTask, BetterCommandSource $sender, PackFile t) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter(t, "t");
            Object object2 = $this_runCatching;
            try {
                PackGenerator $this$generate_u24lambda_u2413_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u247 = object2;
                boolean bl = false;
                $saveTask.invoke(t);
                String[] stringArray = new String[]{"Pack file " + t.getPath() + " is generated."};
                PluginsKt.debug(ConfigManager.DebugLevel.FILE, stringArray);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            FunctionsKt.handle((Throwable)it, $sender, "Unable to save this file: " + t.getPath());
        }
        return Unit.INSTANCE;
    }

    private static final PackFile addTask$lambda$17$lambda$15(String $str, Function0 $byteArray, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new PackFile($str, $byteArray);
    }

    private static final PackFile addTask$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        return (PackFile)$tmp0.invoke(p0);
    }
}

