/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.player;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.command.SenderType;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.component.WidthComponent;
import kr.toxicity.hud.api.configuration.HudComponentSupplier;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.database.HudDatabase;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.HudPlayerHead;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.popup.PopupIteratorGroup;
import kr.toxicity.hud.api.popup.PopupUpdater;
import kr.toxicity.hud.api.scheduler.HudTask;
import kr.toxicity.hud.api.volatilecode.VolatileCodeHandler;
import kr.toxicity.hud.manager.CompassManagerImpl;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.manager.DatabaseManagerImpl;
import kr.toxicity.hud.manager.HudManagerImpl;
import kr.toxicity.hud.manager.PlayerHeadManager;
import kr.toxicity.hud.manager.PlayerManagerImpl;
import kr.toxicity.hud.manager.PopupManagerImpl;
import kr.toxicity.hud.manager.ShaderManagerImpl;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.AdventuresKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.OverridableSet;
import kr.toxicity.hud.util.PluginsKt;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010#\u001a\u00020$*\b\u0012\u0004\u0012\u00020&0%H\u0002J\b\u0010'\u001a\u00020$H\u0004J\u0006\u0010(\u001a\u00020\u000fJ\b\u0010)\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0-J\b\u0010.\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010/\u001a\u00020$2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fJ\u0006\u00101\u001a\u00020$J\u0006\u00102\u001a\u00020$J\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140-J\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170-J\u0006\u00105\u001a\u00020\rJ\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120-J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020\u001dJ\u000e\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u001dJ\u0006\u0010<\u001a\u00020$J\b\u0010=\u001a\u00020$H$J\u0006\u0010>\u001a\u00020$J\b\u0010?\u001a\u00020$H\u0016J\u0006\u0010@\u001a\u00020$J\b\u0010A\u001a\u00020BH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0016R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010 \u001a\u00070\u0019\u00a2\u0006\u0002\b!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\"\u001a\u00070\u0019\u00a2\u0006\u0002\b!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lkr/toxicity/hud/player/HudPlayerImpl;", "Lkr/toxicity/hud/api/player/HudPlayer;", "<init>", "()V", "locationSet", "Ljava/util/HashSet;", "Lkr/toxicity/hud/api/player/PointedLocation;", "Lkr/toxicity/hud/shaded/kotlin/collections/HashSet;", "componentMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkr/toxicity/hud/api/configuration/HudObject$Identifier;", "Lkr/toxicity/hud/api/configuration/HudComponentSupplier;", "tick", "", "last", "Lkr/toxicity/hud/api/component/WidthComponent;", "additionalComp", "variable", "", "popupGroup", "Lkr/toxicity/hud/api/popup/PopupIteratorGroup;", "popupKey", "", "Lkr/toxicity/hud/api/popup/PopupUpdater;", "task", "Lkr/toxicity/hud/api/scheduler/HudTask;", "color", "Lnet/kyori/adventure/bossbar/BossBar$Color;", "enabled", "", "pointers", "", "autoSave", "Lorg/jetbrains/annotations/NotNull;", "locationProvide", "addSupplier", "", "", "Lkr/toxicity/hud/api/configuration/HudObject;", "inject", "getHudComponent", "getAdditionalComponent", "setAdditionalComponent", "component", "getHudObjects", "", "getBarColor", "setBarColor", "getPointedLocation", "cancelTick", "startTick", "getPopupGroupIteratorMap", "getPopupKeyMap", "getTick", "getVariableMap", "getHead", "Lkr/toxicity/hud/api/player/HudPlayerHead;", "isHudEnabled", "setHudEnabled", "toEnable", "save", "updatePlaceholder", "update", "reload", "cancel", "type", "Lkr/toxicity/command/SenderType;", "dist"})
@SourceDebugExtension(value={"SMAP\nHudPlayerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudPlayerImpl.kt\nkr/toxicity/hud/player/HudPlayerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,204:1\n1869#2,2:205\n1869#2,2:207\n774#2:209\n865#2,2:210\n1563#2:212\n1634#2,3:213\n774#2:216\n865#2,2:217\n1563#2:219\n1634#2,3:220\n774#2:223\n865#2,2:224\n1563#2:226\n1634#2,3:227\n1869#2,2:230\n1869#2,2:232\n1869#2,2:234\n216#3,2:236\n*S KotlinDebug\n*F\n+ 1 HudPlayerImpl.kt\nkr/toxicity/hud/player/HudPlayerImpl\n*L\n42#1:205,2\n134#1:207,2\n152#1:209\n152#1:210,2\n154#1:212\n154#1:213,3\n157#1:216\n157#1:217,2\n159#1:219\n159#1:220,3\n162#1:223\n162#1:224,2\n164#1:226\n164#1:227,3\n173#1:230,2\n178#1:232,2\n183#1:234,2\n192#1:236,2\n*E\n"})
public abstract class HudPlayerImpl
implements HudPlayer {
    @NotNull
    private final HashSet<PointedLocation> locationSet = new HashSet();
    @NotNull
    private final ConcurrentHashMap<HudObject.Identifier, HudComponentSupplier<?>> componentMap = new ConcurrentHashMap();
    private long tick;
    @NotNull
    private WidthComponent last = AdventuresKt.getEMPTY_WIDTH_COMPONENT();
    @Nullable
    private WidthComponent additionalComp;
    @NotNull
    private final ConcurrentHashMap<String, String> variable = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, PopupIteratorGroup> popupGroup = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<Object, PopupUpdater> popupKey = new ConcurrentHashMap();
    @Nullable
    private HudTask task;
    @Nullable
    private BossBar.Color color;
    private boolean enabled = true;
    @NotNull
    private final Set<PointedLocation> pointers = new OverridableSet(HudPlayerImpl::pointers$lambda$0, null, 2, null);
    @NotNull
    private HudTask autoSave = PluginsKt.asyncTaskTimer(ConfigManagerImpl.INSTANCE.getAutoSaveTime(), ConfigManagerImpl.INSTANCE.getAutoSaveTime(), () -> HudPlayerImpl.autoSave$lambda$1(this));
    @NotNull
    private HudTask locationProvide = PluginsKt.asyncTaskTimer(ConfigManagerImpl.INSTANCE.getLocationProvideTime(), ConfigManagerImpl.INSTANCE.getLocationProvideTime(), () -> HudPlayerImpl.locationProvide$lambda$2(this));

    private final void addSupplier(Collection<? extends HudObject> $this$addSupplier) {
        Iterable $this$forEach$iv = $this$addSupplier;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HudObject it = (HudObject)element$iv;
            boolean bl = false;
            ((Map)this.componentMap).put(it.identifier(), it.getComponentsByType(this));
        }
    }

    protected final void inject() {
        this.addSupplier((Collection<? extends HudObject>)HudManagerImpl.INSTANCE.getDefaultHuds());
        this.addSupplier((Collection<? extends HudObject>)PopupManagerImpl.INSTANCE.getDefaultPopups());
        this.addSupplier((Collection<? extends HudObject>)CompassManagerImpl.INSTANCE.getDefaultCompasses());
        this.startTick();
        PluginsKt.getVOLATILE_CODE().inject(this, ShaderManagerImpl.INSTANCE.getBarColor());
    }

    @Override
    @NotNull
    public final WidthComponent getHudComponent() {
        return this.last;
    }

    @Override
    @Nullable
    public final WidthComponent getAdditionalComponent() {
        return this.additionalComp;
    }

    @Override
    public final void setAdditionalComponent(@Nullable WidthComponent component) {
        this.additionalComp = component;
    }

    @Override
    @NotNull
    public final Map<HudObject.Identifier, HudComponentSupplier<?>> getHudObjects() {
        return this.componentMap;
    }

    @Override
    @Nullable
    public final BossBar.Color getBarColor() {
        return this.color;
    }

    @Override
    public final void setBarColor(@Nullable BossBar.Color color) {
        this.color = color;
    }

    @Override
    @NotNull
    public final Set<PointedLocation> getPointedLocation() {
        return this.locationSet;
    }

    @Override
    public final void cancelTick() {
        HudTask hudTask = this.task;
        if (hudTask != null) {
            hudTask.cancel();
        }
        this.task = null;
    }

    @Override
    public final void startTick() {
        this.cancelTick();
        long speed = ConfigManagerImpl.INSTANCE.getTickSpeed();
        if (speed > 0L) {
            this.task = PluginsKt.asyncTaskTimer(1L, speed, () -> HudPlayerImpl.startTick$lambda$4(this));
        }
    }

    @Override
    @NotNull
    public final Map<String, PopupIteratorGroup> getPopupGroupIteratorMap() {
        return this.popupGroup;
    }

    @Override
    @NotNull
    public final Map<Object, PopupUpdater> getPopupKeyMap() {
        return this.popupKey;
    }

    @Override
    public final long getTick() {
        return this.tick;
    }

    @Override
    @NotNull
    public final Map<String, String> getVariableMap() {
        return this.variable;
    }

    @Override
    @NotNull
    public final HudPlayerHead getHead() {
        String string = this.name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return PlayerHeadManager.INSTANCE.provideHead(string);
    }

    @Override
    public final boolean isHudEnabled() {
        return this.enabled;
    }

    @Override
    public final void setHudEnabled(boolean toEnable) {
        this.enabled = toEnable;
    }

    @Override
    public final void save() {
        HudDatabase current = DatabaseManagerImpl.INSTANCE.getCurrentDatabase();
        if (!current.isClosed()) {
            current.save(this);
        }
    }

    protected abstract void updatePlaceholder();

    @Override
    public final synchronized void update() {
        this.updatePlaceholder();
        long l = this.tick;
        this.tick = l + 1L;
        ArrayList compList = new ArrayList();
        if (this.enabled && !PluginsKt.getPLUGIN().isOnReload()) {
            this.componentMap.entrySet().removeIf(arg_0 -> HudPlayerImpl.update$lambda$8(arg_0 -> HudPlayerImpl.update$lambda$7(this, compList, arg_0), arg_0));
            Iterator<PopupIteratorGroup> popupGroupIterator = this.popupGroup.values().iterator();
            while (popupGroupIterator.hasNext()) {
                List<WidthComponent> comp;
                PopupIteratorGroup next;
                Intrinsics.checkNotNullExpressionValue(popupGroupIterator.next(), "next(...)");
                if (next.getIndex() == 0) {
                    popupGroupIterator.remove();
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(next.next(), "next(...)");
                if (comp.isEmpty()) {
                    popupGroupIterator.remove();
                    continue;
                }
                CollectionsKt.addAll((Collection)compList, (Iterable)comp);
            }
        }
        if (!((Collection)compList).isEmpty() || this.additionalComp != null) {
            WidthComponent widthComponent = this.additionalComp;
            if (widthComponent != null) {
                WidthComponent it = widthComponent;
                boolean bl = false;
                ((Collection)compList).add(AdventuresKt.toSpaceComponent(-it.width() / 2).plus(it));
            }
            WidthComponent comp = null;
            comp = AdventuresKt.getNEGATIVE_ONE_SPACE_COMPONENT();
            Iterable $this$forEach$iv = compList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WidthComponent it = (WidthComponent)element$iv;
                boolean bl = false;
                WidthComponent widthComponent2 = comp.plus(it);
                Intrinsics.checkNotNullExpressionValue(widthComponent2, "plus(...)");
                comp = widthComponent2;
                WidthComponent widthComponent3 = comp.plus(AdventuresKt.toSpaceComponent(-it.width()));
                Intrinsics.checkNotNullExpressionValue(widthComponent3, "plus(...)");
                comp = widthComponent3;
            }
            this.last = AdventuresKt.finalizeFont(comp);
            VolatileCodeHandler volatileCodeHandler = PluginsKt.getVOLATILE_CODE();
            HudPlayer hudPlayer = this;
            BossBar.Color color = this.color;
            if (color == null) {
                color = ShaderManagerImpl.INSTANCE.getBarColor();
            }
            volatileCodeHandler.showBossBar(hudPlayer, color, (Component)comp.component().build());
        } else {
            VolatileCodeHandler volatileCodeHandler = PluginsKt.getVOLATILE_CODE();
            HudPlayer hudPlayer = this;
            BossBar.Color color = this.color;
            if (color == null) {
                color = ShaderManagerImpl.INSTANCE.getBarColor();
            }
            volatileCodeHandler.showBossBar(hudPlayer, color, AdventuresKt.getEMPTY_COMPONENT());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void reload() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$filterTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Popup it;
        Iterable $this$filterTo$iv$iv3;
        this.autoSave = PluginsKt.asyncTaskTimer(ConfigManagerImpl.INSTANCE.getAutoSaveTime(), ConfigManagerImpl.INSTANCE.getAutoSaveTime(), () -> HudPlayerImpl.reload$lambda$11(this));
        this.locationProvide = PluginsKt.asyncTaskTimer(ConfigManagerImpl.INSTANCE.getLocationProvideTime(), ConfigManagerImpl.INSTANCE.getLocationProvideTime(), () -> HudPlayerImpl.reload$lambda$12(this));
        Set<Popup> set = this.getPopups();
        Intrinsics.checkNotNullExpressionValue(set, "getPopups(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            it = (Popup)element$iv$iv;
            boolean bl = false;
            if (!(!it.isDefault())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv3 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            it = (Popup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List popupNames = (List)destination$iv$iv;
        Set<Hud> set2 = this.getHuds();
        Intrinsics.checkNotNullExpressionValue(set2, "getHuds(...)");
        Iterable $this$filter$iv2 = set2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Hud it2 = (Hud)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isDefault())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable $this$map$iv3 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv2 = $this$map$iv3;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Hud it2 = (Hud)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it2.getName());
        }
        List hudNames = (List)destination$iv$iv2;
        Set<Compass> set3 = this.getCompasses();
        Intrinsics.checkNotNullExpressionValue(set3, "getCompasses(...)");
        Iterable $this$filter$iv3 = set3;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Compass it3 = (Compass)element$iv$iv;
            boolean bl = false;
            if (!(!it3.isDefault())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Compass it3 = (Compass)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it3.getName());
        }
        List compassNames = (List)destination$iv$iv3;
        this.popupKey.clear();
        this.componentMap.clear();
        this.popupGroup.clear();
        this.addSupplier((Collection<? extends HudObject>)PopupManagerImpl.INSTANCE.getDefaultPopups());
        this.addSupplier((Collection<? extends HudObject>)HudManagerImpl.INSTANCE.getDefaultHuds());
        this.addSupplier((Collection<? extends HudObject>)CompassManagerImpl.INSTANCE.getDefaultCompasses());
        Iterable $this$forEach$iv = popupNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Popup popup;
            String it4 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it4);
            if (PopupManagerImpl.INSTANCE.getPopup(it4) == null) continue;
            boolean bl2 = false;
            if (popup.isDefault()) continue;
            popup.add(this);
        }
        $this$forEach$iv = hudNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Hud hud;
            String it5 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it5);
            if (HudManagerImpl.INSTANCE.getHud(it5) == null) continue;
            boolean bl3 = false;
            if (hud.isDefault()) continue;
            hud.add(this);
        }
        $this$forEach$iv = compassNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Compass hud;
            String it6 = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it6);
            if (CompassManagerImpl.INSTANCE.getCompass(it6) == null) continue;
            boolean bl4 = false;
            if (hud.isDefault()) continue;
            hud.add(this);
        }
    }

    @Override
    public final synchronized void cancel() {
        Map $this$forEach$iv = this.popupGroup;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((PopupIteratorGroup)it.getValue()).clear();
        }
        PluginsKt.getVOLATILE_CODE().removeBossBar(this);
        this.cancelTick();
        this.autoSave.cancel();
        this.locationProvide.cancel();
    }

    @Override
    @NotNull
    public SenderType type() {
        return SenderType.PLAYER;
    }

    @Override
    @NotNull
    public Set<PointedLocation> pointers() {
        return this.pointers;
    }

    private static final String pointers$lambda$0(PointedLocation it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.name();
    }

    private static final Unit autoSave$lambda$1(HudPlayerImpl this$0) {
        this$0.save();
        return Unit.INSTANCE;
    }

    private static final Unit locationProvide$lambda$2(HudPlayerImpl this$0) {
        PlayerManagerImpl.INSTANCE.provideLocation(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit startTick$lambda$4(HudPlayerImpl this$0) {
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final boolean update$lambda$7(HudPlayerImpl this$0, ArrayList $compList, Map.Entry entry) {
        Object object;
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
        HudObject.Identifier k2 = (HudObject.Identifier)k;
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
        HudComponentSupplier v2 = (HudComponentSupplier)v;
        Object object2 = this$0;
        try {
            HudPlayerImpl $this$update_u24lambda_u247_u24lambda_u245 = object2;
            boolean bl = false;
            $compList.addAll((Collection)v2.get());
            object = Result.constructor-impl(false);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            FunctionsKt.handle((Throwable)e, "Unable to update " + k2 + ".");
        }
        object = true;
        return (Boolean)(Result.isFailure-impl(object2) ? object : object2);
    }

    private static final boolean update$lambda$8(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit reload$lambda$11(HudPlayerImpl this$0) {
        this$0.save();
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$12(HudPlayerImpl this$0) {
        PlayerManagerImpl.INSTANCE.provideLocation(this$0);
        return Unit.INSTANCE;
    }
}

