/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.command.CommandListener;
import kr.toxicity.command.CommandLogger;
import kr.toxicity.command.MessageSender;
import kr.toxicity.command.SenderType;
import kr.toxicity.hud.api.BetterHud;
import kr.toxicity.hud.api.adapter.LocationWrapper;
import kr.toxicity.hud.api.adapter.WorldWrapper;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.configuration.HudObjectType;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.player.PointedLocationSource;
import kr.toxicity.hud.api.plugin.ReloadFlagType;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.plugin.ReloadState;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.update.UpdateEvent;
import kr.toxicity.hud.command.CompassIcon;
import kr.toxicity.hud.command.CompassStack;
import kr.toxicity.hud.command.HudPlayerStack;
import kr.toxicity.hud.command.HudStack;
import kr.toxicity.hud.command.PopupStack;
import kr.toxicity.hud.command.Vec3;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.CommandManager;
import kr.toxicity.hud.manager.CompassManagerImpl;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.manager.HudManagerImpl;
import kr.toxicity.hud.manager.PlaceholderManagerImpl;
import kr.toxicity.hud.manager.PlayerManagerImpl;
import kr.toxicity.hud.manager.PopupManagerImpl;
import kr.toxicity.hud.placeholder.PlaceholderSource;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.ExceptionsKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.io.ByteStreamsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.BetterCommand;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.ClassSerializer;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandMessage;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandModule;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Aliases;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.CanBeNull;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Command;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Description;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Option;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Permission;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Sender;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Source;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.annotation.Vararg;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.PluginsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00130\u00130\u0012\u00a2\u0006\u0002\b\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lkr/toxicity/hud/manager/CommandManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "library", "Lkr/toxicity/hud/shaded/kr/toxicity/command/impl/BetterCommand;", "Lorg/jetbrains/annotations/NotNull;", "getLibrary", "()Lkr/toxicity/command/impl/BetterCommand;", "module", "Lkr/toxicity/hud/shaded/kr/toxicity/command/impl/CommandModule;", "Lkr/toxicity/command/BetterCommandSource;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "getModule$annotations", "getModule", "()Lkr/toxicity/command/impl/CommandModule;", "start", "", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nCommandManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandManager.kt\nkr/toxicity/hud/manager/CommandManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,558:1\n1563#2:559\n1634#2,3:560\n1563#2:563\n1634#2,3:564\n1563#2:568\n1634#2,3:569\n1#3:567\n*S KotlinDebug\n*F\n+ 1 CommandManager.kt\nkr/toxicity/hud/manager/CommandManager\n*L\n55#1:559\n55#1:560,3\n101#1:563\n101#1:564,3\n115#1:568\n115#1:569,3\n*E\n"})
public final class CommandManager
implements BetterHudManager {
    @NotNull
    public static final CommandManager INSTANCE;
    @NotNull
    private static final String managerName;
    private static final boolean supportExternalPacks;
    @NotNull
    private static final BetterCommand library;
    @NotNull
    private static final CommandModule<BetterCommandSource> module;

    private CommandManager() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @NotNull
    public final BetterCommand getLibrary() {
        return library;
    }

    @NotNull
    public final CommandModule<BetterCommandSource> getModule() {
        return module;
    }

    public static /* synthetic */ void getModule$annotations() {
    }

    @Override
    public void start() {
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        library.reload();
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void library$lambda$2$lambda$1(File $this_apply, String name, InputStream stream) {
        File file = new File($this_apply, name);
        if (!file.exists()) {
            Closeable closeable = new FileOutputStream(file);
            int n = 8192;
            closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            Throwable throwable = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull(stream);
                ByteStreamsKt.copyTo$default(stream, it, 0, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    private static final void library$lambda$3(Throwable it) {
        if (ConfigManagerImpl.INSTANCE.debug()) {
            String[] stringArray = new String[2];
            stringArray[0] = "Stack trace:";
            Intrinsics.checkNotNull(it);
            stringArray[1] = ExceptionsKt.stackTraceToString(it);
            PluginsKt.warn(stringArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final HudPlayerStack library$lambda$5(BetterCommandSource betterCommandSource, String s) {
        HudPlayerStack hudPlayerStack;
        if (s != null) {
            switch (s.hashCode()) {
                case 96673: {
                    if (!s.equals("all")) break;
                    hudPlayerStack = new HudPlayerStack(PlayerManagerImpl.INSTANCE.getAllHudPlayer());
                    return hudPlayerStack;
                }
            }
        }
        Intrinsics.checkNotNull(s);
        HudPlayer hudPlayer = PlayerManagerImpl.INSTANCE.getHudPlayer(s);
        if (hudPlayer == null) return null;
        HudPlayer it = hudPlayer;
        boolean bl = false;
        hudPlayerStack = new HudPlayerStack((Collection<? extends HudPlayer>)CollectionsKt.listOf(it));
        return hudPlayerStack;
    }

    /*
     * WARNING - void declaration
     */
    private static final List library$lambda$7(BetterCommandSource it) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = PlayerManagerImpl.INSTANCE.getAllHudPlayer();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            HudPlayer hudPlayer = (HudPlayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.name());
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), "all");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final HudStack library$lambda$9(BetterCommandSource betterCommandSource, String s) {
        HudStack hudStack;
        String string = s;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 96673: {
                    if (!string.equals("all")) break;
                    n = 1;
                    break;
                }
                case 1544803905: {
                    if (!string.equals("default")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Collection collection = HudObjectType.HUD.all();
                    Intrinsics.checkNotNullExpressionValue(collection, "all(...)");
                    hudStack = new HudStack(collection);
                    return hudStack;
                }
                case 2: {
                    List list = HudObjectType.HUD.defaultObjects().toList();
                    Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
                    hudStack = new HudStack(list);
                    return hudStack;
                }
            }
        }
        Intrinsics.checkNotNull(s);
        Hud hud = HudManagerImpl.INSTANCE.getHud(s);
        if (hud == null) return null;
        Hud it = hud;
        boolean bl = false;
        hudStack = new HudStack((Collection<? extends Hud>)CollectionsKt.listOf(it));
        return hudStack;
    }

    private static final List library$lambda$10(BetterCommandSource it) {
        return CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)HudManagerImpl.INSTANCE.getAllNames()), "all");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final CompassStack library$lambda$12(BetterCommandSource betterCommandSource, String s) {
        CompassStack compassStack;
        String string = s;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 96673: {
                    if (!string.equals("all")) break;
                    n = 1;
                    break;
                }
                case 1544803905: {
                    if (!string.equals("default")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Collection collection = HudObjectType.COMPASS.all();
                    Intrinsics.checkNotNullExpressionValue(collection, "all(...)");
                    compassStack = new CompassStack(collection);
                    return compassStack;
                }
                case 2: {
                    List list = HudObjectType.COMPASS.defaultObjects().toList();
                    Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
                    compassStack = new CompassStack(list);
                    return compassStack;
                }
            }
        }
        Intrinsics.checkNotNull(s);
        Compass compass = CompassManagerImpl.INSTANCE.getCompass(s);
        if (compass == null) return null;
        Compass it = compass;
        boolean bl = false;
        compassStack = new CompassStack((Collection<? extends Compass>)CollectionsKt.listOf(it));
        return compassStack;
    }

    private static final List library$lambda$13(BetterCommandSource it) {
        return CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)CompassManagerImpl.INSTANCE.getAllNames()), "all");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final PopupStack library$lambda$15(BetterCommandSource betterCommandSource, String s) {
        PopupStack popupStack;
        String string = s;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 96673: {
                    if (!string.equals("all")) break;
                    n = 1;
                    break;
                }
                case 1544803905: {
                    if (!string.equals("default")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Collection collection = HudObjectType.POPUP.all();
                    Intrinsics.checkNotNullExpressionValue(collection, "all(...)");
                    popupStack = new PopupStack(collection);
                    return popupStack;
                }
                case 2: {
                    List list = HudObjectType.POPUP.defaultObjects().toList();
                    Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
                    popupStack = new PopupStack(list);
                    return popupStack;
                }
            }
        }
        Intrinsics.checkNotNull(s);
        Popup popup = PopupManagerImpl.INSTANCE.getPopup(s);
        if (popup == null) return null;
        Popup it = popup;
        boolean bl = false;
        popupStack = new PopupStack((Collection<? extends Popup>)CollectionsKt.listOf(it));
        return popupStack;
    }

    private static final List library$lambda$16(BetterCommandSource it) {
        return CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)PopupManagerImpl.INSTANCE.getAllNames()), "all");
    }

    private static final WorldWrapper library$lambda$17(BetterCommandSource betterCommandSource, String s) {
        return PluginsKt.getBOOTSTRAP().world(s);
    }

    /*
     * WARNING - void declaration
     */
    private static final List library$lambda$19(BetterCommandSource it) {
        void $this$mapTo$iv$iv;
        List list = PluginsKt.getBOOTSTRAP().worlds();
        Intrinsics.checkNotNullExpressionValue(list, "worlds(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            WorldWrapper worldWrapper = (WorldWrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.name());
        }
        return (List)destination$iv$iv;
    }

    private static final Vec3 library$lambda$21(BetterCommandSource betterCommandSource, String s) {
        Vec3 vec3;
        Intrinsics.checkNotNull(s);
        Object object = new char[]{'_'};
        List split = StringsKt.split$default((CharSequence)s, (char[])object, false, 0, 6, null);
        if (split.size() == 3) {
            Object object2;
            object = INSTANCE;
            try {
                Object $this$library_u24lambda_u2421_u24lambda_u2420 = object;
                boolean bl = false;
                object2 = Result.constructor-impl(new Vec3(Double.parseDouble((String)split.get(0)), Double.parseDouble((String)split.get(1)), Double.parseDouble((String)split.get(2))));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            object = object2;
            vec3 = (Vec3)(Result.isFailure-impl(object) ? null : object);
        } else {
            vec3 = null;
        }
        return vec3;
    }

    private static final List library$lambda$22(BetterCommandSource it) {
        return CollectionsKt.listOf("0_0_0");
    }

    private static final CompassIcon library$lambda$23(BetterCommandSource betterCommandSource, String s) {
        Intrinsics.checkNotNull(s);
        return new CompassIcon(s);
    }

    /*
     * WARNING - void declaration
     */
    private static final List library$lambda$25(BetterCommandSource it) {
        List list;
        if (it instanceof HudPlayer) {
            void $this$mapTo$iv$iv;
            Set set = ((HudPlayer)it).pointers();
            Intrinsics.checkNotNullExpressionValue(set, "pointers(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void s;
                PointedLocation pointedLocation = (PointedLocation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(s.name());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Boolean library$lambda$26() {
        return !ConfigManagerImpl.INSTANCE.debug();
    }

    private static final void module$lambda$27(CommandModule it) {
        it.permission("betterhud.hud").description(new CommandMessage("betterhud.hud.description", (Component)Component.text((String)"Manages player's hud."))).executes(new CommandListener(){
            private final MessageSender add_success;
            private final MessageSender add_failure;
            private final MessageSender remove_success;
            private final MessageSender remove_failure;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.hud.add.message.success", (Component)Component.text((String)"Successfully added.")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.add_success = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.hud.add.message.failure", (Component)Component.text((String)"Hud '[hud]' is already active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.add_failure = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.hud.remove.message.success", (Component)Component.text((String)"Successfully removed.")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.remove_success = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.hud.remove.message.failure", (Component)Component.text((String)"Hud '[hud]' is not active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.remove_failure = messageSender4;
            }

            @Command
            @Description(key="betterhud.hud.add.description", defaultValue="Adds the hud for a player.")
            @Aliases(aliases={"a"})
            @Permission(value="betterhud.hud.add")
            public final void add(@Source BetterCommandSource me, HudPlayerStack players, HudStack huds) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(huds, "huds");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = huds;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Hud hud = (Hud)element$iv2;
                        boolean bl2 = false;
                        boolean success = hud.add(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("hud", Component.text((String)hud.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.add_success.send(me, map);
                            continue;
                        }
                        this.add_failure.send(me, map);
                    }
                }
            }

            @Command
            @Description(key="betterhud.hud.remove.description", defaultValue="Removes the hud from a player.")
            @Aliases(aliases={"r"})
            @Permission(value="betterhud.hud.remove")
            public final void remove(@Source BetterCommandSource me, HudPlayerStack players, HudStack huds) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(huds, "huds");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = huds;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Hud hud = (Hud)element$iv2;
                        boolean bl2 = false;
                        boolean success = hud.remove(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("hud", Component.text((String)hud.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.remove_success.send(me, map);
                            continue;
                        }
                        this.remove_failure.send(me, map);
                    }
                }
            }
        });
    }

    private static final void module$lambda$28(CommandModule it) {
        String[] stringArray = new String[]{"com"};
        it.aliases(stringArray).description(new CommandMessage("betterhud.compass.description", (Component)Component.text((String)"Manages player's compass."))).permission("betterhud.compass").executes(new CommandListener(){
            private final MessageSender add_success;
            private final MessageSender add_failure;
            private final MessageSender remove_success;
            private final MessageSender remove_failure;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.compass.add.message.success", (Component)Component.text((String)"Successfully added.")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.add_success = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.compass.add.message.failure", (Component)Component.text((String)"Compass '[compass]' is already active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.add_failure = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.compass.remove.message.success", (Component)Component.text((String)"Successfully removed.")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.remove_success = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.compass.remove.message.failure", (Component)Component.text((String)"Compass '[compass]' is not active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.remove_failure = messageSender4;
            }

            @Command
            @Description(key="betterhud.compass.add.description", defaultValue="Adds the compass for a player.")
            @Aliases(aliases={"a"})
            @Permission(value="betterhud.compass.add")
            public final void add(@Source BetterCommandSource me, HudPlayerStack players, CompassStack compasses) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(compasses, "compasses");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = compasses;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Compass compass = (Compass)element$iv2;
                        boolean bl2 = false;
                        boolean success = compass.add(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("compass", Component.text((String)compass.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.add_success.send(me, map);
                            continue;
                        }
                        this.add_failure.send(me, map);
                    }
                }
            }

            @Command
            @Description(key="betterhud.compass.remove.description", defaultValue="Removes the compass from a player.")
            @Aliases(aliases={"r"})
            @Permission(value="betterhud.compass.remove")
            public final void remove(@Source BetterCommandSource me, HudPlayerStack players, CompassStack compasses) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(compasses, "compasses");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = compasses;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Compass compass = (Compass)element$iv2;
                        boolean bl2 = false;
                        boolean success = compass.remove(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("compass", Component.text((String)compass.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.remove_success.send(me, map);
                            continue;
                        }
                        this.remove_failure.send(me, map);
                    }
                }
            }
        });
    }

    private static final void module$lambda$29(CommandModule it) {
        String[] stringArray = new String[]{"pop"};
        it.aliases(stringArray).description(new CommandMessage("betterhud.popup.description", (Component)Component.text((String)"Manages player's popup."))).permission("betterhud.popup").executes(new CommandListener(){
            private final MessageSender add_success;
            private final MessageSender add_failure;
            private final MessageSender remove_success;
            private final MessageSender remove_failure;
            private final MessageSender show_success;
            private final MessageSender show_failure;
            private final MessageSender show_error1;
            private final MessageSender show_error2;
            private final MessageSender hide_success;
            private final MessageSender hide_failure;
            private final MessageSender hide_error1;
            private final MessageSender hide_error2;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.add.message.success", (Component)Component.text((String)"Successfully added.")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.add_success = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.add.message.failure", (Component)Component.text((String)"Popup '[popup]' is already active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.add_failure = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.remove.message.success", (Component)Component.text((String)"Successfully removed.")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.remove_success = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.remove.message.failure", (Component)Component.text((String)"Popup '[popup]' is not active for this player.")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.remove_failure = messageSender4;
                MessageSender messageSender5 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.show.message.success", (Component)Component.text((String)"Popup was successfully displayed to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender5, "registerKey(...)");
                this.show_success = messageSender5;
                MessageSender messageSender6 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.show.message.failure", (Component)Component.text((String)"Failed to show this popup to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender6, "registerKey(...)");
                this.show_failure = messageSender6;
                MessageSender messageSender7 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.show.message.error.1", (Component)Component.text((String)"Unable to show this popup in command to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender7, "registerKey(...)");
                this.show_error1 = messageSender7;
                MessageSender messageSender8 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.show.message.error.2", (Component)Component.text((String)"Cause: [cause]")));
                Intrinsics.checkNotNullExpressionValue(messageSender8, "registerKey(...)");
                this.show_error2 = messageSender8;
                MessageSender messageSender9 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.hide.message.success", (Component)Component.text((String)"Popup was successfully remove to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender9, "registerKey(...)");
                this.hide_success = messageSender9;
                MessageSender messageSender10 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.hide.message.failure", (Component)Component.text((String)"Failed to hide this popup to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender10, "registerKey(...)");
                this.hide_failure = messageSender10;
                MessageSender messageSender11 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.hide.message.error.1", (Component)Component.text((String)"Unable to hide this popup in command to [player].")));
                Intrinsics.checkNotNullExpressionValue(messageSender11, "registerKey(...)");
                this.hide_error1 = messageSender11;
                MessageSender messageSender12 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.popup.hide.message.error.2", (Component)Component.text((String)"Cause: [cause]")));
                Intrinsics.checkNotNullExpressionValue(messageSender12, "registerKey(...)");
                this.hide_error2 = messageSender12;
            }

            @Command
            @Description(key="betterhud.popup.add.description", defaultValue="Adds the popup for a player.")
            @Aliases(aliases={"a"})
            @Permission(value="betterhud.popup.add")
            public final void add(@Source BetterCommandSource me, HudPlayerStack players, PopupStack popups) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(popups, "popups");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = popups;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Popup popup = (Popup)element$iv2;
                        boolean bl2 = false;
                        boolean success = popup.add(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.add_success.send(me, map);
                            continue;
                        }
                        this.add_failure.send(me, map);
                    }
                }
            }

            @Command
            @Description(key="betterhud.popup.remove.description", defaultValue="Removes the popup from a player.")
            @Aliases(aliases={"r"})
            @Permission(value="betterhud.popup.remove")
            public final void remove(@Source BetterCommandSource me, HudPlayerStack players, PopupStack popups) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(popups, "popups");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = popups;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Popup popup = (Popup)element$iv2;
                        boolean bl2 = false;
                        boolean success = popup.remove(player);
                        if (++stack >= 6) continue;
                        Pair[] pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName()))};
                        Map<String, Component> map = MapsKt.mapOf(pairArray);
                        if (success) {
                            this.remove_success.send(me, map);
                            continue;
                        }
                        this.remove_failure.send(me, map);
                    }
                }
            }

            @Command
            @Description(key="betterhud.popup.show.description", defaultValue="Shows a popup for a player.")
            @Aliases(aliases={"s"})
            @Permission(value="betterhud.popup.show")
            public final void show(@Source BetterCommandSource me, HudPlayerStack players, PopupStack popups) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(popups, "popups");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = popups;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Object object;
                        Map<String, Object> map;
                        Pair[] pairArray;
                        Popup popup = (Popup)element$iv2;
                        boolean bl2 = false;
                        Object object2 = this;
                        try {
                            boolean success;
                            module.4.1 $this$show_u24lambda_u247_u24lambda_u246_u24lambda_u244 = object2;
                            boolean bl3 = false;
                            boolean bl4 = success = popup.show(UpdateEvent.EMPTY, player) != null;
                            if (++stack < 6) {
                                pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName()))};
                                map = MapsKt.mapOf(pairArray);
                                if (success) {
                                    $this$show_u24lambda_u247_u24lambda_u246_u24lambda_u244.show_success.send(me, map);
                                } else {
                                    $this$show_u24lambda_u247_u24lambda_u246_u24lambda_u244.show_failure.send(me, map);
                                }
                            }
                            object = Result.constructor-impl(Unit.INSTANCE);
                        }
                        catch (Throwable bl3) {
                            object = Result.constructor-impl(ResultKt.createFailure(bl3));
                        }
                        object2 = object;
                        Throwable throwable = Result.exceptionOrNull-impl(object2);
                        if (throwable == null) continue;
                        Object e = object = throwable;
                        boolean bl5 = false;
                        if (++stack >= 6) continue;
                        pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName())), TuplesKt.to("cause", Component.text((String)(e.getClass().getSimpleName() + ": " + ((Throwable)e).getMessage())))};
                        map = MapsKt.mapOf(pairArray);
                        this.show_error1.send(me, map);
                        this.show_error2.send(me, map);
                    }
                }
            }

            @Command
            @Description(key="betterhud.popup.hide.description", defaultValue="Hides a popup for a player.")
            @Aliases(aliases={"h"})
            @Permission(value="betterhud.popup.hide")
            public final void hide(@Source BetterCommandSource me, HudPlayerStack players, PopupStack popups) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(popups, "popups");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = popups;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        Object object;
                        Map<String, Object> map;
                        Pair[] pairArray;
                        Popup popup = (Popup)element$iv2;
                        boolean bl2 = false;
                        Object object2 = this;
                        try {
                            module.4.1 $this$hide_u24lambda_u2411_u24lambda_u2410_u24lambda_u248 = object2;
                            boolean bl3 = false;
                            boolean success = popup.hide(player);
                            if (++stack < 6) {
                                pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName()))};
                                map = MapsKt.mapOf(pairArray);
                                if (success) {
                                    $this$hide_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.hide_success.send(me, map);
                                } else {
                                    $this$hide_u24lambda_u2411_u24lambda_u2410_u24lambda_u248.hide_failure.send(me, map);
                                }
                            }
                            object = Result.constructor-impl(Unit.INSTANCE);
                        }
                        catch (Throwable bl3) {
                            object = Result.constructor-impl(ResultKt.createFailure(bl3));
                        }
                        object2 = object;
                        Throwable throwable = Result.exceptionOrNull-impl(object2);
                        if (throwable == null) continue;
                        Object e = object = throwable;
                        boolean bl4 = false;
                        if (++stack >= 6) continue;
                        pairArray = new Pair[]{TuplesKt.to("player", Component.text((String)player.name())), TuplesKt.to("popup", Component.text((String)popup.getName())), TuplesKt.to("cause", Component.text((String)(e.getClass().getSimpleName() + ": " + ((Throwable)e).getMessage())))};
                        map = MapsKt.mapOf(pairArray);
                        this.hide_error1.send(me, map);
                        this.hide_error2.send(me, map);
                    }
                }
            }
        });
    }

    private static final void module$lambda$30(CommandModule it) {
        String[] stringArray = new String[]{"t"};
        it.aliases(stringArray).description(new CommandMessage("betterhud.turn.description", (Component)Component.text((String)"Turns on or off HUD."))).permission("betterhud.turn").executes(new CommandListener(){
            private final MessageSender on_no_target;
            private final MessageSender on_success;
            private final MessageSender off_no_target;
            private final MessageSender off_success;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.turn.on.message.no_target", (Component)Component.text((String)"No target player provided.")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.on_no_target = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.turn.on.message.success", (Component)Component.text((String)"Successfully turned the HUD on.")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.on_success = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.turn.off.message.no_target", (Component)Component.text((String)"No target player provided.")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.off_no_target = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.turn.off.message.success", (Component)Component.text((String)"Successfully turned the HUD off.")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.off_success = messageSender4;
            }

            @Command
            @Description(key="betterhud.turn.on.description", defaultValue="Turns on your HUD.")
            @Permission(value="betterhud.turn.on")
            public final void on(@Source BetterCommandSource me, @Option HudPlayerStack target) {
                Intrinsics.checkNotNullParameter(me, "me");
                if (target != null && me.hasPermission("betterhud.turn.on.admin")) {
                    Iterable $this$forEach$iv = target;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HudPlayer p = (HudPlayer)element$iv;
                        boolean bl = false;
                        p.setHudEnabled(true);
                    }
                } else if (me instanceof HudPlayer) {
                    ((HudPlayer)me).setHudEnabled(true);
                } else {
                    this.on_no_target.send(me);
                    return;
                }
                this.on_success.send(me);
            }

            @Command
            @Description(key="betterhud.turn.off.description", defaultValue="Turns off your HUD.")
            @Permission(value="betterhud.turn.off")
            public final void off(@Source BetterCommandSource me, @Option HudPlayerStack target) {
                Intrinsics.checkNotNullParameter(me, "me");
                if (target != null && me.hasPermission("betterhud.turn.off.admin")) {
                    Iterable $this$forEach$iv = target;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HudPlayer p = (HudPlayer)element$iv;
                        boolean bl = false;
                        p.setHudEnabled(false);
                    }
                } else if (me instanceof HudPlayer) {
                    ((HudPlayer)me).setHudEnabled(false);
                } else {
                    this.off_no_target.send(me);
                    return;
                }
                this.off_success.send(me);
            }
        });
    }

    private static final void module$lambda$31(CommandModule it) {
        String[] stringArray = new String[]{"point"};
        it.aliases(stringArray).description(new CommandMessage("betterhud.pointer.description", (Component)Component.text((String)"Manages your compass pointer."))).permission("betterhud.pointer").executes(new CommandListener(){
            private final MessageSender set_success;
            private final MessageSender clear_success;
            private final MessageSender remove_success;
            private final MessageSender remove_failure;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.pointer.set.message.success", (Component)Component.text((String)"Successfully located.")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.set_success = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.pointer.clear.message.success", (Component)Component.text((String)"Cleared successfully.")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.clear_success = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.pointer.remove.message.success", (Component)Component.text((String)"Removed successfully in [player]")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.remove_success = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.pointer.remove.message.failure", (Component)Component.text((String)"This pointer doesn't exist: [pointer] in [player]")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.remove_failure = messageSender4;
            }

            @Command
            @Description(key="betterhud.pointer.set.description", defaultValue="Sets the compass pointer location of some player.")
            @Permission(value="betterhud.pointer.set")
            public final void set(@Source BetterCommandSource me, HudPlayerStack players, String name, WorldWrapper world, Vec3 vector, @Option CompassIcon icon) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(world, "world");
                Intrinsics.checkNotNullParameter(vector, "vector");
                CompassIcon compassIcon = icon;
                PointedLocation loc = new PointedLocation(PointedLocationSource.INTERNAL, name, compassIcon != null ? compassIcon.getString() : null, new LocationWrapper(world, vector.getX(), vector.getY(), vector.getZ(), 0.0f, 0.0f));
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    player.pointers().add(loc);
                }
                this.set_success.send(me);
            }

            @Command
            @Description(key="betterhud.pointer.clear.description", defaultValue="Clears the compass pointer location of some player.")
            @Permission(value="betterhud.pointer.clear")
            public final void clear(@Source BetterCommandSource me, HudPlayerStack players) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    player.pointers().clear();
                }
                this.clear_success.send(me);
            }

            @Command
            @Description(key="betterhud.pointer.remove.description", defaultValue="Removes the compass pointer location of some player.")
            @Permission(value="betterhud.pointer.remove")
            public final void remove(@Source BetterCommandSource me, HudPlayerStack players, String name) {
                Intrinsics.checkNotNullParameter(me, "me");
                Intrinsics.checkNotNullParameter(players, "players");
                Intrinsics.checkNotNullParameter(name, "name");
                int stack = 0;
                Iterable $this$forEach$iv = players;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HudPlayer player = (HudPlayer)element$iv;
                    boolean bl = false;
                    boolean success = player.pointers().removeIf(arg_0 -> module.6.1.remove$lambda$4$lambda$3(arg_0 -> module.6.1.remove$lambda$4$lambda$2(name, arg_0), arg_0));
                    if (++stack >= 6) continue;
                    Pair[] pairArray = new Pair[]{TuplesKt.to("pointer", Component.text((String)name)), TuplesKt.to("player", Component.text((String)player.name()))};
                    Map<String, Component> map = MapsKt.mapOf(pairArray);
                    if (success) {
                        this.remove_success.send(me, map);
                        continue;
                    }
                    this.remove_failure.send(me, map);
                }
            }

            private static final boolean remove$lambda$4$lambda$2(String $name, PointedLocation p) {
                return Intrinsics.areEqual(p.name(), $name);
            }

            private static final boolean remove$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
    }

    static {
        String[] stringArray;
        INSTANCE = new CommandManager();
        managerName = "Command";
        String[] $this$library_u24lambda_u242 = stringArray = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "lang");
        boolean bl = false;
        PluginsKt.getPLUGIN().loadAssets("lang", (arg_0, arg_1) -> CommandManager.library$lambda$2$lambda$1((File)$this$library_u24lambda_u242, arg_0, arg_1));
        CommandLogger commandLogger = (CommandLogger)PluginsKt.getBOOTSTRAP().logger();
        ComponentSerializer componentSerializer = (ComponentSerializer)MiniMessage.miniMessage();
        String[] stringArray2 = stringArray;
        BetterCommand betterCommand = new BetterCommand((File)stringArray2, (ComponentSerializer<Component, Component, String>)componentSerializer, commandLogger).exceptionHandler(CommandManager::library$lambda$3).addSerializer(HudPlayerStack.class, ClassSerializer.builder(CommandManager::library$lambda$5).name("player").suggests(CommandManager::library$lambda$7).nullMessage(new CommandMessage("betterhud.null.player", (Component)Component.text((String)"Unable to find this player: [value]"))).build()).addSerializer(HudStack.class, ClassSerializer.builder(CommandManager::library$lambda$9).name("hud").suggests(CommandManager::library$lambda$10).nullMessage(new CommandMessage("betterhud.null.hud", (Component)Component.text((String)"Unable to find this hud: [value]"))).build()).addSerializer(CompassStack.class, ClassSerializer.builder(CommandManager::library$lambda$12).name("compass").suggests(CommandManager::library$lambda$13).nullMessage(new CommandMessage("betterhud.null.compass", (Component)Component.text((String)"Unable to find this compass: [value]"))).build()).addSerializer(PopupStack.class, ClassSerializer.builder(CommandManager::library$lambda$15).name("popup").suggests(CommandManager::library$lambda$16).nullMessage(new CommandMessage("betterhud.null.popup", (Component)Component.text((String)"Unable to find this popup: [value]"))).build()).addSerializer(WorldWrapper.class, ClassSerializer.builder(CommandManager::library$lambda$17).name("world").suggests(CommandManager::library$lambda$19).nullMessage(new CommandMessage("betterhud.null.world", (Component)Component.text((String)"Unable to find this world: [value]"))).build()).addSerializer(Vec3.class, ClassSerializer.builder(CommandManager::library$lambda$21).name("vector").suggests(CommandManager::library$lambda$22).nullMessage(new CommandMessage("betterhud.null.vector", (Component)Component.text((String)"Invalid vector: [value]"))).build()).addSerializer(CompassIcon.class, ClassSerializer.builder(CommandManager::library$lambda$23).name("icon").suggests(CommandManager::library$lambda$25).nullMessage(new CommandMessage("betterhud.null.icon", (Component)Component.text((String)"Unable to find this icon: [icon]"))).build()).silentLog(CommandManager::library$lambda$26);
        Intrinsics.checkNotNullExpressionValue(betterCommand, "silentLog(...)");
        library = betterCommand;
        stringArray = new String[]{"betterhud", "bh"};
        CommandModule<BetterCommandSource> commandModule = library.module("hud").aliases(stringArray).permission("hud").executes(new CommandListener(){
            private final MessageSender reload_tryReload;
            private final MessageSender reload_onReload;
            private final MessageSender reload_success;
            private final MessageSender reload_failure1;
            private final MessageSender reload_failure2;
            private final MessageSender parse_failure1;
            private final MessageSender parse_failure2;
            private final MessageSender generate_tryGenerate;
            private final MessageSender generate_success;
            private final MessageSender generate_failure;
            {
                MessageSender messageSender = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.reload.message.try_reload", (Component)Component.text((String)"Trying to reload. please wait...")));
                Intrinsics.checkNotNullExpressionValue(messageSender, "registerKey(...)");
                this.reload_tryReload = messageSender;
                MessageSender messageSender2 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.reload.message.on_reload", (Component)Component.text((String)"The plugin is still reloading!")));
                Intrinsics.checkNotNullExpressionValue(messageSender2, "registerKey(...)");
                this.reload_onReload = messageSender2;
                MessageSender messageSender3 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.reload.message.success", (Component)Component.text((String)"Reload successful! ([time] ms)")));
                Intrinsics.checkNotNullExpressionValue(messageSender3, "registerKey(...)");
                this.reload_success = messageSender3;
                MessageSender messageSender4 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.reload.message.failure.1", (Component)Component.text((String)"Reload failed.")));
                Intrinsics.checkNotNullExpressionValue(messageSender4, "registerKey(...)");
                this.reload_failure1 = messageSender4;
                MessageSender messageSender5 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.reload.message.failure.2", (Component)Component.text((String)"Cause: [cause]")));
                Intrinsics.checkNotNullExpressionValue(messageSender5, "registerKey(...)");
                this.reload_failure2 = messageSender5;
                MessageSender messageSender6 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.parse.message.failure.1", (Component)Component.text((String)"Parse failed.")));
                Intrinsics.checkNotNullExpressionValue(messageSender6, "registerKey(...)");
                this.parse_failure1 = messageSender6;
                MessageSender messageSender7 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.parse.message.failure.2", (Component)Component.text((String)"Cause: [cause]")));
                Intrinsics.checkNotNullExpressionValue(messageSender7, "registerKey(...)");
                this.parse_failure2 = messageSender7;
                MessageSender messageSender8 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.generate.message.try_generate", (Component)Component.text((String)"Trying to generate. please wait...")));
                Intrinsics.checkNotNullExpressionValue(messageSender8, "registerKey(...)");
                this.generate_tryGenerate = messageSender8;
                MessageSender messageSender9 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.generate.message.success", (Component)Component.text((String)"The lang file '[name]' is successfully generated.")));
                Intrinsics.checkNotNullExpressionValue(messageSender9, "registerKey(...)");
                this.generate_success = messageSender9;
                MessageSender messageSender10 = CommandManager.INSTANCE.getLibrary().registerKey(new CommandMessage("betterhud.generate.message.failure", (Component)Component.text((String)"Generate failure. Maybe [name] already exists.")));
                Intrinsics.checkNotNullExpressionValue(messageSender10, "registerKey(...)");
                this.generate_failure = messageSender10;
            }

            @Command
            @Description(key="betterhud.reload.description", defaultValue="Reload BetterHud.")
            @Aliases(aliases={"re", "rl"})
            @Permission(value="betterhud.reload")
            public final void reload(@Source BetterCommandSource me, @Option @CanBeNull String args) {
                Intrinsics.checkNotNullParameter(me, "me");
                this.reload_tryReload.send(me);
                PluginsKt.asyncTask(() -> module.1.reload$lambda$1(me, args, this));
            }

            @Command
            @Description(key="betterhud.reload.parse", defaultValue="Tests BetterHud's text placeholder.")
            @Aliases(aliases={"p"})
            @Permission(value="betterhud.parse")
            @Sender(type={SenderType.PLAYER})
            public final void parse(@Source HudPlayer me, @Vararg String argument) {
                block2: {
                    Object object;
                    Intrinsics.checkNotNullParameter(me, "me");
                    Intrinsics.checkNotNullParameter(argument, "argument");
                    Object object2 = this;
                    try {
                        module.1 $this$parse_u24lambda_u242 = object2;
                        boolean bl = false;
                        Audience audience = me.audience();
                        MiniMessage miniMessage = MiniMessage.miniMessage();
                        Function1<UpdateEvent, Function1<HudPlayer, String>> function1 = PlaceholderManagerImpl.INSTANCE.parse(argument, PlaceholderSource.Companion.getEmpty());
                        UpdateEvent updateEvent = UpdateEvent.EMPTY;
                        Intrinsics.checkNotNullExpressionValue(updateEvent, "EMPTY");
                        audience.sendMessage(miniMessage.deserialize((Object)function1.invoke(updateEvent).invoke(me)));
                        object = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl(ResultKt.createFailure(bl));
                    }
                    object2 = object;
                    Throwable throwable = Result.exceptionOrNull-impl(object2);
                    if (throwable == null) break block2;
                    Object e = object = throwable;
                    boolean bl = false;
                    this.parse_failure1.send((BetterCommandSource)me);
                    this.parse_failure2.send((BetterCommandSource)me, MapsKt.mapOf(TuplesKt.to("cause", Component.text((String)(e.getClass().getSimpleName() + ": " + ((Throwable)e).getMessage())))));
                }
            }

            @Command
            @Description(key="betterhud.generate.description", defaultValue="Generates default language file.")
            @Aliases(aliases={"gen"})
            @Permission(value="betterhud.generate")
            public final void generate(@Source BetterCommandSource me) {
                Intrinsics.checkNotNullParameter(me, "me");
                this.generate_tryGenerate.send(me);
                PluginsKt.asyncTask(() -> module.1.generate$lambda$4(me, this));
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit reload$lambda$1(BetterCommandSource $me, String $args, module.1 this$0) {
                Object object;
                BetterCommandSource betterCommandSource;
                BetterHud betterHud;
                block10: {
                    block9: {
                        void it;
                        char[] cArray;
                        betterHud = PluginsKt.getPLUGIN();
                        betterCommandSource = $me;
                        object = $args;
                        if ($args == null || (object = StringsKt.split$default((CharSequence)object, cArray = new char[]{' '}, false, 0, 6, null)) == null) break block9;
                        Object object2 = object;
                        BetterCommandSource betterCommandSource2 = betterCommandSource;
                        BetterHud betterHud2 = betterHud;
                        boolean bl = false;
                        Set set = ReloadFlagType.from((Collection)((Collection)it));
                        Intrinsics.checkNotNullExpressionValue(set, "from(...)");
                        Collection $this$toTypedArray$iv = set;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        ReloadFlagType[] reloadFlagTypeArray = thisCollection$iv.toArray(new ReloadFlagType[0]);
                        betterHud = betterHud2;
                        betterCommandSource = betterCommandSource2;
                        object = reloadFlagTypeArray;
                        if (reloadFlagTypeArray != null) break block10;
                    }
                    object = new ReloadFlagType[]{};
                }
                ReloadFlagType[] reloadFlagTypeArray = object;
                ReloadState reloadState = betterHud.reload(betterCommandSource, Arrays.copyOf(reloadFlagTypeArray, reloadFlagTypeArray.length));
                Intrinsics.checkNotNullExpressionValue(reloadState, "reload(...)");
                ReloadState reload2 = reloadState;
                if (reload2 instanceof ReloadState.OnReload) {
                    this$0.reload_onReload.send($me);
                } else if (reload2 instanceof ReloadState.Success) {
                    this$0.reload_success.send($me, MapsKt.mapOf(TuplesKt.to("time", PluginsKt.withDecimal(((ReloadState.Success)reload2).time()))));
                } else if (reload2 instanceof ReloadState.Failure) {
                    this$0.reload_failure1.send($me);
                    this$0.reload_failure2.send($me, MapsKt.mapOf(TuplesKt.to("cause", Component.text((String)(((ReloadState.Failure)reload2).throwable().getClass().getSimpleName() + ": " + ((ReloadState.Failure)reload2).throwable().getMessage())))));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
            }

            private static final Unit generate$lambda$4(BetterCommandSource $me, module.1 this$0) {
                Locale locale = $me.locale();
                Intrinsics.checkNotNullExpressionValue(locale, "locale(...)");
                Locale locale2 = locale;
                Map<String, TextComponent> localeString = MapsKt.mapOf(TuplesKt.to("name", Component.text((String)locale2.toString())));
                if (CommandManager.INSTANCE.getLibrary().generateDefaultLang(locale2)) {
                    this$0.generate_success.send($me, localeString);
                } else {
                    this$0.generate_failure.send($me, localeString);
                }
                return Unit.INSTANCE;
            }
        }).children("hud", CommandManager::module$lambda$27).children("compass", CommandManager::module$lambda$28).children("popup", CommandManager::module$lambda$29).children("turn", CommandManager::module$lambda$30).children("pointer", CommandManager::module$lambda$31);
        Intrinsics.checkNotNullExpressionValue(commandModule, "children(...)");
        module = commandModule;
    }
}

