/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.manager.CompassManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.compass.CompassImpl;
import kr.toxicity.hud.compass.CompassType;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lkr/toxicity/hud/manager/CompassManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/CompassManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "compassMap", "Ljava/util/HashMap;", "Lkr/toxicity/hud/compass/CompassImpl;", "start", "", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "getCompass", "Lkr/toxicity/hud/api/compass/Compass;", "name", "getAllNames", "", "getAllCompasses", "dist"})
public final class CompassManagerImpl
implements BetterHudManager,
CompassManager {
    @NotNull
    public static final CompassManagerImpl INSTANCE = new CompassManagerImpl();
    @NotNull
    private static final String managerName = "Background";
    private static final boolean supportExternalPacks = true;
    @NotNull
    private static final HashMap<String, CompassImpl> compassMap = new HashMap();

    private CompassManagerImpl() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    @Override
    public void preReload() {
        compassMap.clear();
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        compassMap.clear();
        File assets = FilesKt.subFolder(workingDirectory, "assets");
        File file = FilesKt.subFolder(workingDirectory, "compasses");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> CompassManagerImpl.reload$lambda$5(info, resource, assets, arg_0, arg_1, arg_2));
    }

    @Override
    public void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Compass getCompass(@NotNull String name) {
        CompassImpl compassImpl;
        Intrinsics.checkNotNullParameter(name, "name");
        HashMap<String, CompassImpl> hashMap = compassMap;
        synchronized (hashMap) {
            boolean bl = false;
            compassImpl = compassMap.get(name);
        }
        return compassImpl;
    }

    @NotNull
    public Set<String> getAllNames() {
        Set<String> set = Collections.unmodifiableSet(compassMap.keySet());
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    @NotNull
    public Set<Compass> getAllCompasses() {
        Collection<CompassImpl> collection = compassMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final String reload$lambda$5$lambda$3$lambda$2$lambda$0() {
        return "type value not set.";
    }

    private static final CompassImpl reload$lambda$5$lambda$3$lambda$2(YamlObject $c, GlobalResource $resource, File $assets, String $s) {
        YamlElement yamlElement = $c.get("type");
        String $this$reload_u24lambda_u245_u24lambda_u243_u24lambda_u242_u24lambda_u241 = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, CompassManagerImpl::reload$lambda$5$lambda$3$lambda$2$lambda$0);
        boolean bl = false;
        String string = $this$reload_u24lambda_u245_u24lambda_u243_u24lambda_u242_u24lambda_u241.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return CompassType.valueOf(string).build($resource, $assets, $s, $c);
    }

    private static final String reload$lambda$5$lambda$4(String $s, File $f) {
        return "Unable to load this compass: " + $s + " in " + $f.getName();
    }

    private static final Unit reload$lambda$5(ReloadInfo $info, GlobalResource $resource, File $assets, File f, String s, YamlObject c) {
        Object object;
        Intrinsics.checkNotNullParameter(f, "f");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(c, "c");
        CompassManagerImpl compassManagerImpl = INSTANCE;
        try {
            CompassManagerImpl $this$reload_u24lambda_u245_u24lambda_u243 = compassManagerImpl;
            boolean bl = false;
            MapsKt.putSync((Map)compassMap, "compass", () -> CompassManagerImpl.reload$lambda$5$lambda$3$lambda$2(c, $resource, $assets, s));
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        FunctionsKt.handleFailure(object, $info, () -> CompassManagerImpl.reload$lambda$5$lambda$4(s, f));
        return Unit.INSTANCE;
    }
}

