/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import com.google.gson.JsonObject;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.database.HudDatabase;
import kr.toxicity.hud.api.database.HudDatabaseConnector;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.manager.DatabaseManager;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.configuration.PluginConfiguration;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.CompassManagerImpl;
import kr.toxicity.hud.manager.DatabaseManagerImpl;
import kr.toxicity.hud.manager.HudManagerImpl;
import kr.toxicity.hud.manager.PopupManagerImpl;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import kr.toxicity.hud.yaml.YamlObjectImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J \u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkr/toxicity/hud/manager/DatabaseManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/DatabaseManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "defaultConnector", "Lkr/toxicity/hud/api/database/HudDatabaseConnector;", "currentConnector", "connectionMap", "", "current", "Lkr/toxicity/hud/api/database/HudDatabase;", "Lorg/jetbrains/annotations/NotNull;", "start", "", "getCurrentDatabase", "addDatabase", "name", "connector", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "dist"})
public final class DatabaseManagerImpl
implements BetterHudManager,
DatabaseManager {
    @NotNull
    public static final DatabaseManagerImpl INSTANCE = new DatabaseManagerImpl();
    @NotNull
    private static final String managerName = "Database";
    private static final boolean supportExternalPacks;
    @NotNull
    private static final HudDatabaseConnector defaultConnector;
    @NotNull
    private static HudDatabaseConnector currentConnector;
    @NotNull
    private static final Map<String, HudDatabaseConnector> connectionMap;
    @NotNull
    private static HudDatabase current;

    private DatabaseManagerImpl() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    @NotNull
    public HudDatabase getCurrentDatabase() {
        return current;
    }

    public boolean addDatabase(@NotNull String name, @NotNull HudDatabaseConnector connector) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(connector, "connector");
        return connectionMap.putIfAbsent(name, connector) == null;
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Object object;
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        DatabaseManagerImpl databaseManagerImpl = this;
        try {
            DatabaseManagerImpl $this$reload_u24lambda_u2413 = databaseManagerImpl;
            boolean bl = false;
            YamlObject db = PluginConfiguration.DATABASE.create();
            YamlElement yamlElement = db.get("type");
            String type = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, DatabaseManagerImpl::reload$lambda$13$lambda$10);
            YamlElement yamlElement2 = db.get("info");
            YamlObject dbInfo = FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asObject() : null, DatabaseManagerImpl::reload$lambda$13$lambda$11);
            HudDatabaseConnector connector = FunctionsKt.ifNull(connectionMap.get(type), () -> DatabaseManagerImpl.reload$lambda$13$lambda$12(type));
            if (currentConnector == connector) {
                return;
            }
            current.close();
            HudDatabase hudDatabase = connector.connect(dbInfo);
            Intrinsics.checkNotNullExpressionValue(hudDatabase, "connect(...)");
            current = hudDatabase;
            currentConnector = connector;
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        FunctionsKt.handleFailure(object, info, DatabaseManagerImpl::reload$lambda$14);
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final HudDatabase defaultConnector$lambda$0(YamlObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new HudDatabase(){
            private boolean closed;

            private final File getFile(HudPlayer player) {
                return FilesKt.subFile(FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), ".users"), player.uuid() + ".yml");
            }

            public boolean isClosed() {
                return this.closed;
            }

            public void close() {
                this.closed = true;
            }

            public void load(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                PluginsKt.asyncTask(() -> defaultConnector.1.1.load$lambda$8(this, player));
            }

            /*
             * WARNING - void declaration
             */
            public boolean save(HudPlayer player) {
                Collection<Map> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LinkedHashMap<String, Object> linkedHashMap;
                Intrinsics.checkNotNullParameter(player, "player");
                LinkedHashMap<String, Object> $this$save_u24lambda_u2415 = linkedHashMap = new LinkedHashMap<String, Object>();
                boolean bl = false;
                defaultConnector.1.1.save$lambda$15$save($this$save_u24lambda_u2415, "popups", () -> defaultConnector.1.1.save$lambda$15$lambda$11(player));
                defaultConnector.1.1.save$lambda$15$save($this$save_u24lambda_u2415, "huds", () -> defaultConnector.1.1.save$lambda$15$lambda$12(player));
                defaultConnector.1.1.save$lambda$15$save($this$save_u24lambda_u2415, "compasses", () -> defaultConnector.1.1.save$lambda$15$lambda$13(player));
                Set set = player.pointers();
                Intrinsics.checkNotNullExpressionValue(set, "pointers(...)");
                Iterable iterable = set;
                String string = "locations";
                LinkedHashMap<String, Object> linkedHashMap2 = $this$save_u24lambda_u2415;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PointedLocation pointedLocation = (PointedLocation)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.serialize());
                }
                collection = (List)destination$iv$iv;
                linkedHashMap2.put(string, collection);
                YamlsKt.saveToYaml((Map<String, ? extends Object>)linkedHashMap, this.getFile(player));
                return true;
            }

            /*
             * WARNING - void declaration
             */
            private static final void load$lambda$8$add(YamlObject yaml, HudPlayer $player, String name, Function1<? super String, ? extends HudObject> mapper) {
                block2: {
                    void $this$forEach$iv;
                    void $this$mapNotNullTo$iv$iv;
                    YamlElement yamlElement = yaml.get(name);
                    if (yamlElement == null || (yamlElement = yamlElement.asArray()) == null) break block2;
                    Iterable $this$mapNotNull$iv = (Iterable)yamlElement;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        HudObject it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        YamlElement it = (YamlElement)element$iv$iv;
                        boolean bl2 = false;
                        String string = it.asString();
                        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                        if (mapper.invoke(string) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv) {
                        HudObject it = (HudObject)element$iv;
                        boolean bl = false;
                        if (it.isDefault()) continue;
                        it.add($player);
                    }
                }
            }

            private static final HudObject load$lambda$8$lambda$2(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (HudObject)HudManagerImpl.INSTANCE.getHud(it);
            }

            private static final HudObject load$lambda$8$lambda$3(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (HudObject)PopupManagerImpl.INSTANCE.getPopup(it);
            }

            private static final HudObject load$lambda$8$lambda$4(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (HudObject)CompassManagerImpl.INSTANCE.getCompass(it);
            }

            private static final String load$lambda$8$lambda$7$lambda$6(HudPlayer $player) {
                return "unable to load " + $player.name() + "'s location.";
            }

            private static final Unit load$lambda$8(defaultConnector.1.1 this$0, HudPlayer $player) {
                block3: {
                    YamlObject yaml = YamlsKt.toYaml(this$0.getFile($player));
                    defaultConnector.1.1.load$lambda$8$add(yaml, $player, "huds", defaultConnector.1.1::load$lambda$8$lambda$2);
                    defaultConnector.1.1.load$lambda$8$add(yaml, $player, "popups", defaultConnector.1.1::load$lambda$8$lambda$3);
                    defaultConnector.1.1.load$lambda$8$add(yaml, $player, "compasses", defaultConnector.1.1::load$lambda$8$lambda$4);
                    YamlElement yamlElement = yaml.get("locations");
                    if (yamlElement == null || (yamlElement = yamlElement.asArray()) == null) break block3;
                    Iterable $this$forEach$iv = (Iterable)yamlElement;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Object object;
                        YamlElement it = (YamlElement)element$iv;
                        boolean bl = false;
                        defaultConnector.1.1 var9_9 = this$0;
                        try {
                            defaultConnector.1.1 $this$load_u24lambda_u248_u24lambda_u247_u24lambda_u245 = var9_9;
                            boolean bl2 = false;
                            object = Result.constructor-impl($player.pointers().add(PointedLocation.deserialize((YamlObject)it.asObject())));
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl(ResultKt.createFailure(throwable));
                        }
                        FunctionsKt.handleFailure(object, () -> defaultConnector.1.1.load$lambda$8$lambda$7$lambda$6($player));
                    }
                }
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final void save$lambda$15$save(LinkedHashMap<String, Object> $this_apply, String name, Function0<? extends Set<? extends HudObject>> supplier) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                HudObject it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = supplier.invoke();
                String string = name;
                LinkedHashMap<String, Object> linkedHashMap = $this_apply;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (HudObject)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isDefault())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<String> collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (HudObject)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                linkedHashMap.put(string, collection);
            }

            private static final Set save$lambda$15$lambda$11(HudPlayer $player) {
                Set set = $player.getPopups();
                Intrinsics.checkNotNullExpressionValue(set, "getPopups(...)");
                return set;
            }

            private static final Set save$lambda$15$lambda$12(HudPlayer $player) {
                Set set = $player.getHuds();
                Intrinsics.checkNotNullExpressionValue(set, "getHuds(...)");
                return set;
            }

            private static final Set save$lambda$15$lambda$13(HudPlayer $player) {
                Set set = $player.getCompasses();
                Intrinsics.checkNotNullExpressionValue(set, "getCompasses(...)");
                return set;
            }
        };
    }

    private static final String connectionMap$lambda$9$lambda$1() {
        return "unable to find the host value.";
    }

    private static final String connectionMap$lambda$9$lambda$2() {
        return "unable to find the database value.";
    }

    private static final String connectionMap$lambda$9$lambda$5$lambda$3() {
        return "unable to find the name value.";
    }

    private static final String connectionMap$lambda$9$lambda$5$lambda$4() {
        return "unable to find the password value.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HudDatabase connectionMap$lambda$9(YamlObject it) {
        HikariConfig hikariConfig;
        Intrinsics.checkNotNullParameter(it, "it");
        Class.forName("com.mysql.cj.jdbc.Driver");
        YamlElement yamlElement = it.get("host");
        String host = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, DatabaseManagerImpl::connectionMap$lambda$9$lambda$1);
        YamlElement yamlElement2 = it.get("database");
        String database = FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asString() : null, DatabaseManagerImpl::connectionMap$lambda$9$lambda$2);
        HikariConfig $this$connectionMap_u24lambda_u249_u24lambda_u245 = hikariConfig = new HikariConfig();
        boolean bl = false;
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setJdbcUrl("jdbc:mysql://" + host + "/" + database);
        YamlElement yamlElement3 = it.get("name");
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setUsername(FunctionsKt.ifNull(yamlElement3 != null ? yamlElement3.asString() : null, DatabaseManagerImpl::connectionMap$lambda$9$lambda$5$lambda$3));
        YamlElement yamlElement4 = it.get("password");
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setPassword(FunctionsKt.ifNull(yamlElement4 != null ? yamlElement4.asString() : null, DatabaseManagerImpl::connectionMap$lambda$9$lambda$5$lambda$4));
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setMaximumPoolSize(10);
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setMinimumIdle(2);
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setIdleTimeout(30000L);
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setMaxLifetime(1800000L);
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setValidationTimeout(5000L);
        $this$connectionMap_u24lambda_u249_u24lambda_u245.setConnectionTestQuery("SELECT 1");
        HikariConfig hikariConfig2 = hikariConfig;
        HikariConfig $this$connectionMap_u24lambda_u249_u24lambda_u248 = hikariConfig = new HikariDataSource(hikariConfig2);
        boolean bl2 = false;
        AutoCloseable autoCloseable = $this$connectionMap_u24lambda_u249_u24lambda_u248.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl3 = false;
            AutoCloseable autoCloseable2 = connection.createStatement();
            Throwable throwable2 = null;
            try {
                Statement s = (Statement)autoCloseable2;
                boolean bl4 = false;
                s.execute("CREATE TABLE IF NOT EXISTS enabled_hud(uuid CHAR(36) NOT NULL, type VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL);");
                s.execute("CREATE TABLE IF NOT EXISTS enabled_pointed_location(uuid CHAR(36), name VARCHAR(255), value TEXT NOT NULL, PRIMARY KEY(uuid, name));");
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        HikariConfig mysql = hikariConfig;
        return new HudDatabase((HikariDataSource)mysql){
            final /* synthetic */ HikariDataSource $mysql;
            {
                this.$mysql = $mysql;
            }

            public void close() {
                this.$mysql.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean transaction(Function1<? super Connection, Unit> block) {
                Object object;
                Intrinsics.checkNotNullParameter(block, "block");
                Object object2 = this;
                Object object3 = this.$mysql;
                try {
                    connectionMap.1.1 $this$transaction_u24lambda_u240 = object2;
                    boolean bl = false;
                    AutoCloseable autoCloseable = object3.getConnection();
                    Throwable throwable = null;
                    try {
                        Unit unit = block.invoke((Connection)autoCloseable);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                    object = Result.constructor-impl(true);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object2 = FunctionsKt.handleFailure(object, connectionMap.1.1::transaction$lambda$1);
                object3 = false;
                return (Boolean)(Result.isFailure-impl(object2) ? object3 : object2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void query(Connection $this$query, String sql, Function1<? super PreparedStatement, Unit> query, Function1<? super ResultSet, Unit> block) {
                Intrinsics.checkNotNullParameter($this$query, "<this>");
                Intrinsics.checkNotNullParameter(sql, "sql");
                Intrinsics.checkNotNullParameter(query, "query");
                Intrinsics.checkNotNullParameter(block, "block");
                AutoCloseable autoCloseable = $this$query.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    PreparedStatement statement = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull(statement);
                    query.invoke(statement);
                    ResultSet resultSet = statement.executeQuery();
                    Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
                    this.query(resultSet, block);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }

            public static /* synthetic */ void query$default(connectionMap.1.1 var0, Connection connection, String string, Function1 function1, Function1 function12, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = connectionMap.1.1::query$lambda$2;
                }
                var0.query(connection, string, function1, function12);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final int update(Connection $this$update, String sql, Function1<? super PreparedStatement, Unit> block) {
                int n;
                Intrinsics.checkNotNullParameter($this$update, "<this>");
                Intrinsics.checkNotNullParameter(sql, "sql");
                Intrinsics.checkNotNullParameter(block, "block");
                AutoCloseable autoCloseable = $this$update.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    PreparedStatement statement = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    Intrinsics.checkNotNull(statement);
                    block.invoke(statement);
                    n = statement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                return n;
            }

            public static /* synthetic */ int update$default(connectionMap.1.1 var0, Connection connection, String string, Function1 function1, int n, Object object) {
                if ((n & 2) != 0) {
                    function1 = connectionMap.1.1::update$lambda$4;
                }
                return var0.update(connection, string, function1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void query(ResultSet $this$query, Function1<? super ResultSet, Unit> block) {
                Intrinsics.checkNotNullParameter($this$query, "<this>");
                Intrinsics.checkNotNullParameter(block, "block");
                AutoCloseable autoCloseable = $this$query;
                Throwable throwable = null;
                try {
                    ResultSet result = (ResultSet)autoCloseable;
                    boolean bl = false;
                    while (result.next()) {
                        block.invoke($this$query);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }

            public boolean isClosed() {
                return this.$mysql.isClosed();
            }

            public void load(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                PluginsKt.asyncTask(() -> connectionMap.1.1.load$lambda$22(player, this));
            }

            public boolean save(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                String string = player.uuid().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String uuid = string;
                return this.transaction(arg_0 -> connectionMap.1.1.save$lambda$31(this, player, uuid, arg_0));
            }

            private static final String transaction$lambda$1() {
                return "Unable to connect mysql";
            }

            private static final Unit query$lambda$2(PreparedStatement $this$HudDatabaseConnector) {
                Intrinsics.checkNotNullParameter($this$HudDatabaseConnector, "$this$HudDatabaseConnector");
                return Unit.INSTANCE;
            }

            private static final Unit update$lambda$4(PreparedStatement $this$HudDatabaseConnector) {
                Intrinsics.checkNotNullParameter($this$HudDatabaseConnector, "$this$HudDatabaseConnector");
                return Unit.INSTANCE;
            }

            private static final Unit load$lambda$22$lambda$21$lambda$7(String $uuid, PreparedStatement $this$query) {
                Intrinsics.checkNotNullParameter($this$query, "$this$query");
                $this$query.setString(1, $uuid);
                return Unit.INSTANCE;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final Unit load$lambda$22$lambda$21$lambda$11(HudPlayer $player, ResultSet $this$query) {
                block6: {
                    Intrinsics.checkNotNullParameter($this$query, "$this$query");
                    String string = $this$query.getString("type");
                    if (string == null) return Unit.INSTANCE;
                    switch (string.hashCode()) {
                        case 106852524: {
                            if (string.equals("popup")) break;
                            return Unit.INSTANCE;
                        }
                        case 950484242: {
                            if (!string.equals("compass")) {
                                return Unit.INSTANCE;
                            }
                            break block6;
                        }
                        case 103671: {
                            if (!string.equals("hud")) return Unit.INSTANCE;
                            String string2 = $this$query.getString("name");
                            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                            Hud hud = HudManagerImpl.INSTANCE.getHud(string2);
                            if (hud == null) return Unit.INSTANCE;
                            Hud h = hud;
                            boolean bl = false;
                            if (h.isDefault()) return Unit.INSTANCE;
                            h.add($player);
                            return Unit.INSTANCE;
                        }
                    }
                    String string3 = $this$query.getString("popup");
                    Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                    Popup popup = PopupManagerImpl.INSTANCE.getPopup(string3);
                    if (popup == null) return Unit.INSTANCE;
                    Popup p = popup;
                    boolean bl = false;
                    if (p.isDefault()) return Unit.INSTANCE;
                    p.add($player);
                    return Unit.INSTANCE;
                }
                String string = $this$query.getString("compass");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                Compass compass = CompassManagerImpl.INSTANCE.getCompass(string);
                if (compass == null) return Unit.INSTANCE;
                Compass c = compass;
                boolean bl = false;
                if (c.isDefault()) return Unit.INSTANCE;
                c.add($player);
                return Unit.INSTANCE;
            }

            private static final Unit load$lambda$22$lambda$21$lambda$12(String $uuid, PreparedStatement $this$query) {
                Intrinsics.checkNotNullParameter($this$query, "$this$query");
                $this$query.setString(1, $uuid);
                return Unit.INSTANCE;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final Unit load$lambda$22$lambda$21$lambda$16(HudPlayer $player, ResultSet $this$query) {
                block6: {
                    Intrinsics.checkNotNullParameter($this$query, "$this$query");
                    String string = $this$query.getString("type");
                    if (string == null) return Unit.INSTANCE;
                    switch (string.hashCode()) {
                        case 106852524: {
                            if (string.equals("popup")) break;
                            return Unit.INSTANCE;
                        }
                        case 950484242: {
                            if (!string.equals("compass")) {
                                return Unit.INSTANCE;
                            }
                            break block6;
                        }
                        case 103671: {
                            if (!string.equals("hud")) return Unit.INSTANCE;
                            String string2 = $this$query.getString("name");
                            Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
                            Hud hud = HudManagerImpl.INSTANCE.getHud(string2);
                            if (hud == null) return Unit.INSTANCE;
                            Hud h = hud;
                            boolean bl = false;
                            if (h.isDefault()) return Unit.INSTANCE;
                            h.add($player);
                            return Unit.INSTANCE;
                        }
                    }
                    String string3 = $this$query.getString("popup");
                    Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                    Popup popup = PopupManagerImpl.INSTANCE.getPopup(string3);
                    if (popup == null) return Unit.INSTANCE;
                    Popup p = popup;
                    boolean bl = false;
                    if (p.isDefault()) return Unit.INSTANCE;
                    p.add($player);
                    return Unit.INSTANCE;
                }
                String string = $this$query.getString("compass");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                Compass compass = CompassManagerImpl.INSTANCE.getCompass(string);
                if (compass == null) return Unit.INSTANCE;
                Compass c = compass;
                boolean bl = false;
                if (c.isDefault()) return Unit.INSTANCE;
                c.add($player);
                return Unit.INSTANCE;
            }

            private static final Unit load$lambda$22$lambda$21$lambda$17(String $uuid, PreparedStatement $this$query) {
                Intrinsics.checkNotNullParameter($this$query, "$this$query");
                $this$query.setString(1, $uuid);
                return Unit.INSTANCE;
            }

            private static final String load$lambda$22$lambda$21$lambda$20$lambda$19(HudPlayer $player) {
                return "unable to load " + $player.name() + "'s location.";
            }

            private static final Unit load$lambda$22$lambda$21$lambda$20(HudPlayer $player, ResultSet $this$query) {
                Object object;
                Intrinsics.checkNotNullParameter($this$query, "$this$query");
                ResultSet resultSet = $this$query;
                try {
                    ResultSet $this$load_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418 = resultSet;
                    boolean bl = false;
                    Set set = $player.pointers();
                    String string = $this$load_u24lambda_u2422_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418.getString("value");
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    object = Result.constructor-impl(set.add(PointedLocation.deserialize((JsonObject)GsonsKt.toBase64Json(string).getAsJsonObject())));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                FunctionsKt.handleFailure(object, () -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$20$lambda$19($player));
                return Unit.INSTANCE;
            }

            private static final Unit load$lambda$22$lambda$21(connectionMap.1.1 this$0, String $uuid, HudPlayer $player, Connection $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                this$0.query($this$transaction, "SELECT type, name FROM enabled_hud WHERE uuid = ?;", arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$7($uuid, arg_0), arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$11($player, arg_0));
                this$0.query($this$transaction, "SELECT type, name FROM enabled_hud WHERE uuid = ?;", arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$12($uuid, arg_0), arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$16($player, arg_0));
                this$0.query($this$transaction, "SELECT value FROM enabled_pointed_location WHERE uuid = ?;", arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$17($uuid, arg_0), arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21$lambda$20($player, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit load$lambda$22(HudPlayer $player, connectionMap.1.1 this$0) {
                String string = $player.uuid().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String uuid = string;
                this$0.transaction(arg_0 -> connectionMap.1.1.load$lambda$22$lambda$21(this$0, uuid, $player, arg_0));
                return Unit.INSTANCE;
            }

            private static final Unit save$lambda$31$lambda$23(String $uuid, PreparedStatement $this$update) {
                Intrinsics.checkNotNullParameter($this$update, "$this$update");
                $this$update.setString(1, $uuid);
                return Unit.INSTANCE;
            }

            private static final Unit save$lambda$31$lambda$24(String $uuid, PreparedStatement $this$update) {
                Intrinsics.checkNotNullParameter($this$update, "$this$update");
                $this$update.setString(1, $uuid);
                return Unit.INSTANCE;
            }

            private static final CharSequence save$lambda$31$save$lambda$26(String $uuid, String $name, HudObject h) {
                Intrinsics.checkNotNullParameter(h, "h");
                return "('" + $uuid + "', '" + $name + "', '" + h.getName() + "')";
            }

            /*
             * WARNING - void declaration
             */
            private static final void save$lambda$31$save(connectionMap.1.1 this$0, Connection $this_transaction, String uuid, String name, Function0<? extends Set<? extends HudObject>> supplier) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = supplier.invoke();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    HudObject obj = (HudObject)element$iv$iv;
                    boolean bl = false;
                    if (!(!obj.isDefault())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String values2 = CollectionsKt.joinToString$default((List)destination$iv$iv, ", ", null, null, 0, null, arg_0 -> connectionMap.1.1.save$lambda$31$save$lambda$26(uuid, name, arg_0), 30, null);
                if (((CharSequence)values2).length() > 0) {
                    connectionMap.1.1.update$default(this$0, $this_transaction, "INSERT INTO enabled_hud(uuid, type, name) VALUES " + values2 + ";", null, 2, null);
                }
            }

            private static final Set save$lambda$31$lambda$27(HudPlayer $player) {
                Set set = $player.getHuds();
                Intrinsics.checkNotNullExpressionValue(set, "getHuds(...)");
                return set;
            }

            private static final Set save$lambda$31$lambda$28(HudPlayer $player) {
                Set set = $player.getPopups();
                Intrinsics.checkNotNullExpressionValue(set, "getPopups(...)");
                return set;
            }

            private static final Set save$lambda$31$lambda$29(HudPlayer $player) {
                Set set = $player.getCompasses();
                Intrinsics.checkNotNullExpressionValue(set, "getCompasses(...)");
                return set;
            }

            private static final CharSequence save$lambda$31$lambda$30(String $uuid, PointedLocation p) {
                String string = p.name();
                Map map = p.serialize();
                Intrinsics.checkNotNullExpressionValue(map, "serialize(...)");
                return "('" + $uuid + "', '" + string + "', '" + GsonsKt.toBase64String(GsonsKt.toJsonElement(map)) + "')";
            }

            private static final Unit save$lambda$31(connectionMap.1.1 this$0, HudPlayer $player, String $uuid, Connection $this$transaction) {
                Intrinsics.checkNotNullParameter($this$transaction, "$this$transaction");
                this$0.update($this$transaction, "DELETE FROM enabled_hud WHERE uuid = ?;", arg_0 -> connectionMap.1.1.save$lambda$31$lambda$23($uuid, arg_0));
                this$0.update($this$transaction, "DELETE FROM enabled_pointed_location WHERE uuid = ?;", arg_0 -> connectionMap.1.1.save$lambda$31$lambda$24($uuid, arg_0));
                connectionMap.1.1.save$lambda$31$save(this$0, $this$transaction, $uuid, "hud", () -> connectionMap.1.1.save$lambda$31$lambda$27($player));
                connectionMap.1.1.save$lambda$31$save(this$0, $this$transaction, $uuid, "popup", () -> connectionMap.1.1.save$lambda$31$lambda$28($player));
                connectionMap.1.1.save$lambda$31$save(this$0, $this$transaction, $uuid, "compass", () -> connectionMap.1.1.save$lambda$31$lambda$29($player));
                Set set = $player.pointers();
                Intrinsics.checkNotNullExpressionValue(set, "pointers(...)");
                String pointerValues = CollectionsKt.joinToString$default(set, ", ", null, null, 0, null, arg_0 -> connectionMap.1.1.save$lambda$31$lambda$30($uuid, arg_0), 30, null);
                if (((CharSequence)pointerValues).length() > 0) {
                    connectionMap.1.1.update$default(this$0, $this$transaction, "INSERT INTO enabled_pointed_location(uuid, name, value) VALUES " + pointerValues + ";", null, 2, null);
                }
                return Unit.INSTANCE;
            }
        };
    }

    private static final String reload$lambda$13$lambda$10() {
        return "type value not set.";
    }

    private static final String reload$lambda$13$lambda$11() {
        return "info configuration not set.";
    }

    private static final String reload$lambda$13$lambda$12(String $type) {
        return "this database doesn't exist: " + $type;
    }

    private static final String reload$lambda$14() {
        HudDatabase hudDatabase = defaultConnector.connect((YamlObject)new YamlObjectImpl("", new LinkedHashMap()));
        Intrinsics.checkNotNullExpressionValue(hudDatabase, "connect(...)");
        current = hudDatabase;
        return "Unable to connect the database.";
    }

    static {
        currentConnector = defaultConnector = DatabaseManagerImpl::defaultConnector$lambda$0;
        Pair[] pairArray = new Pair[]{TuplesKt.to("yml", defaultConnector), TuplesKt.to("mysql", DatabaseManagerImpl::connectionMap$lambda$9)};
        connectionMap = MapsKt.mutableMapOf(pairArray);
        HudDatabase hudDatabase = defaultConnector.connect((YamlObject)new YamlObjectImpl("", new LinkedHashMap()));
        Intrinsics.checkNotNullExpressionValue(hudDatabase, "connect(...)");
        current = hudDatabase;
    }
}

