/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kr.toxicity.hud.api.listener.HudListener;
import kr.toxicity.hud.api.manager.ListenerManager;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.update.UpdateEvent;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.ListenerManagerImpl;
import kr.toxicity.hud.manager.PlaceholderManagerImpl;
import kr.toxicity.hud.placeholder.Placeholder;
import kr.toxicity.hud.placeholder.PlaceholderBuilder;
import kr.toxicity.hud.placeholder.PlaceholderSource;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.shaded.net.jodah.expiringmap.ExpirationPolicy;
import kr.toxicity.hud.shaded.net.jodah.expiringmap.ExpiringMap;
import kr.toxicity.hud.util.FunctionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0004+,-.B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0016J\u0014\u0010\u001b\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u001e\u001a\u00020\u0014J0\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\n2\u001e\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\"0\"H\u0016J \u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R2\u0010\u0011\u001a&\u0012\u0004\u0012\u00020\n\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00130\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lkr/toxicity/hud/manager/ListenerManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/ListenerManager;", "<init>", "()V", "MIN_THRESHOLD", "", "DELTA_MIN_THRESHOLD", "DELTA_THRESHOLD", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "listenerMap", "", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "Lkr/toxicity/hud/api/yaml/YamlObject;", "Lkr/toxicity/hud/api/update/UpdateEvent;", "Lkr/toxicity/hud/api/listener/HudListener;", "start", "", "getAllListenerKeys", "", "checkMinThreshold", "other", "getListener", "section", "addListener", "name", "listenerFunction", "Ljava/util/function/Function;", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "LazyValueKey", "LazyValueAccess", "LazyListenerSetting", "LazyListener", "dist"})
public final class ListenerManagerImpl
implements BetterHudManager,
ListenerManager {
    @NotNull
    public static final ListenerManagerImpl INSTANCE = new ListenerManagerImpl();
    private static final double MIN_THRESHOLD = 0.01;
    private static final double DELTA_MIN_THRESHOLD = 0.1;
    private static final double DELTA_THRESHOLD = 0.75;
    @NotNull
    private static final String managerName = "Listener";
    private static final boolean supportExternalPacks;
    @NotNull
    private static final Map<String, Function1<YamlObject, Function1<UpdateEvent, HudListener>>> listenerMap;

    private ListenerManagerImpl() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @Override
    public void start() {
    }

    @NotNull
    public Set<String> getAllListenerKeys() {
        Set<String> set = Collections.unmodifiableSet(listenerMap.keySet());
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    private final boolean checkMinThreshold(double $this$checkMinThreshold, double other) {
        return other <= $this$checkMinThreshold + 0.01 && other >= $this$checkMinThreshold - 0.01;
    }

    @NotNull
    public final Function1<UpdateEvent, HudListener> getListener(@NotNull YamlObject section) {
        Function1<UpdateEvent, HudListener> listener;
        block2: {
            Object object;
            LazyListenerSetting setting;
            block4: {
                block3: {
                    Intrinsics.checkNotNullParameter(section, "section");
                    YamlElement yamlElement = section.get("class");
                    String clazz = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, ListenerManagerImpl::getListener$lambda$6);
                    listener = FunctionsKt.ifNull(listenerMap.get(clazz), () -> ListenerManagerImpl.getListener$lambda$7(clazz)).invoke(section);
                    if (!section.getAsBoolean("lazy", false)) break block2;
                    setting = new LazyListenerSetting(section);
                    object = section.get("initial-value");
                    if (object == null || (object = object.asString()) == null) break block3;
                    Object it = object;
                    boolean bl = false;
                    PlaceholderBuilder<?> placeholderBuilder = PlaceholderManagerImpl.INSTANCE.find((String)it, new PlaceholderSource.Impl(section)).assertNumber(getListener.initialValue.1.1.INSTANCE);
                    boolean bl2 = false;
                    Function1<UpdateEvent, Function1> function1 = arg_0 -> ListenerManagerImpl.getListener$lambda$12$lambda$11$lambda$10(placeholderBuilder, arg_0);
                    object = function1;
                    if (function1 != null) break block4;
                }
                object = ListenerManagerImpl::getListener$lambda$14;
            }
            Object initialValue2 = object;
            return arg_0 -> ListenerManagerImpl.getListener$lambda$15(listener, setting, (Function1)initialValue2, arg_0);
        }
        return listener;
    }

    public void addListener(@NotNull String name, @NotNull Function<YamlObject, Function<UpdateEvent, HudListener>> listenerFunction) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(listenerFunction, "listenerFunction");
        listenerMap.put(name, arg_0 -> ListenerManagerImpl.addListener$lambda$18(listenerFunction, arg_0));
    }

    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final String listenerMap$lambda$5$lambda$0() {
        return "value value not set.";
    }

    private static final String listenerMap$lambda$5$lambda$1() {
        return "max value not set.";
    }

    private static final double listenerMap$lambda$5$lambda$4$lambda$3(Placeholder $value, Placeholder $max, HudPlayer it) {
        Object object;
        Intrinsics.checkNotNullParameter(it, "it");
        Object object2 = INSTANCE;
        try {
            ListenerManagerImpl $this$listenerMap_u24lambda_u245_u24lambda_u244_u24lambda_u243_u24lambda_u242 = object2;
            boolean bl = false;
            Object r = $value.invoke(it);
            Intrinsics.checkNotNull(r, "null cannot be cast to non-null type kotlin.Number");
            double d = ((Number)r).doubleValue();
            Object r2 = $max.invoke(it);
            Intrinsics.checkNotNull(r2, "null cannot be cast to non-null type kotlin.Number");
            object = Result.constructor-impl(d / ((Number)r2).doubleValue());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        Double d = (Double)(Result.isFailure-impl(object2) ? null : object2);
        return d != null ? d : 0.0;
    }

    private static final HudListener listenerMap$lambda$5$lambda$4(PlaceholderBuilder $v, PlaceholderBuilder $m, UpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Placeholder value = $v.build(event);
        Placeholder max = $m.build(event);
        if (!Intrinsics.areEqual(value.getClazz(), max.getClazz()) || !Intrinsics.areEqual(value.getClazz(), Number.class)) {
            throw new RuntimeException("this type is not a number: " + value.getClazz().getSimpleName() + " and " + max.getClazz().getSimpleName());
        }
        return arg_0 -> ListenerManagerImpl.listenerMap$lambda$5$lambda$4$lambda$3(value, max, arg_0);
    }

    private static final Function1 listenerMap$lambda$5(YamlObject c) {
        Intrinsics.checkNotNullParameter(c, "c");
        PlaceholderSource.Impl source = new PlaceholderSource.Impl(c);
        YamlElement yamlElement = c.get("value");
        PlaceholderBuilder<?> v = PlaceholderManagerImpl.INSTANCE.find(FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, ListenerManagerImpl::listenerMap$lambda$5$lambda$0), source);
        YamlElement yamlElement2 = c.get("max");
        PlaceholderBuilder<?> m = PlaceholderManagerImpl.INSTANCE.find(FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asString() : null, ListenerManagerImpl::listenerMap$lambda$5$lambda$1), source);
        return arg_0 -> ListenerManagerImpl.listenerMap$lambda$5$lambda$4(v, m, arg_0);
    }

    private static final String getListener$lambda$6() {
        return "class value not set.";
    }

    private static final String getListener$lambda$7(String $clazz) {
        return "this class doesn't exist: " + $clazz;
    }

    private static final double getListener$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8(Placeholder $placeholder, HudPlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object r = $placeholder.invoke(player);
        Intrinsics.checkNotNull(r, "null cannot be cast to non-null type kotlin.Number");
        return ((Number)r).doubleValue();
    }

    private static final Function1 getListener$lambda$12$lambda$11$lambda$10(PlaceholderBuilder $placeholderBuilder, UpdateEvent reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        Placeholder placeholder = $placeholderBuilder.build(reason);
        boolean bl = false;
        return arg_0 -> ListenerManagerImpl.getListener$lambda$12$lambda$11$lambda$10$lambda$9$lambda$8(placeholder, arg_0);
    }

    private static final double getListener$lambda$14$lambda$13(HudPlayer it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return 1.0;
    }

    private static final Function1 getListener$lambda$14(UpdateEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ListenerManagerImpl::getListener$lambda$14$lambda$13;
    }

    private static final LazyListener getListener$lambda$15(Function1 $listener, LazyListenerSetting $setting, Function1 $initialValue, UpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Object object = event.getKey();
        Intrinsics.checkNotNullExpressionValue(object, "getKey(...)");
        return new LazyListener(object, (HudListener)$listener.invoke(event), $setting, (Function1)$initialValue.invoke(event));
    }

    private static final HudListener addListener$lambda$18$lambda$17$lambda$16(Function $t, UpdateEvent it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (HudListener)$t.apply(it);
    }

    private static final Function1 addListener$lambda$18(Function $listenerFunction, YamlObject c) {
        Intrinsics.checkNotNullParameter(c, "c");
        Function t = (Function)$listenerFunction.apply(c);
        boolean bl = false;
        return arg_0 -> ListenerManagerImpl.addListener$lambda$18$lambda$17$lambda$16(t, arg_0);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("placeholder", ListenerManagerImpl::listenerMap$lambda$5)};
        listenerMap = MapsKt.mutableMapOf(pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0002\u001a\u00020\u0015*\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyListener;", "Lkr/toxicity/hud/api/listener/HudListener;", "key", "", "delegate", "setting", "Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyListenerSetting;", "initialBuild", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "Lkr/toxicity/hud/api/player/HudPlayer;", "", "<init>", "(Ljava/lang/Object;Lkr/toxicity/hud/api/listener/HudListener;Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyListenerSetting;Lkotlin/jvm/functions/Function1;)V", "getKey", "()Ljava/lang/Object;", "getDelegate", "()Lkr/toxicity/hud/api/listener/HudListener;", "getSetting", "()Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyListenerSetting;", "getInitialBuild", "()Lkotlin/jvm/functions/Function1;", "Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyValueKey;", "getValue", "player", "clear", "", "dist"})
    private static final class LazyListener
    implements HudListener {
        @NotNull
        private final Object key;
        @NotNull
        private final HudListener delegate;
        @NotNull
        private final LazyListenerSetting setting;
        @NotNull
        private final Function1<HudPlayer, Double> initialBuild;

        public LazyListener(@NotNull Object key, @NotNull HudListener delegate, @NotNull LazyListenerSetting setting, @NotNull Function1<? super HudPlayer, Double> initialBuild) {
            Intrinsics.checkNotNullParameter(key, "key");
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            Intrinsics.checkNotNullParameter(setting, "setting");
            Intrinsics.checkNotNullParameter(initialBuild, "initialBuild");
            this.key = key;
            this.delegate = delegate;
            this.setting = setting;
            this.initialBuild = initialBuild;
        }

        @NotNull
        public final Object getKey() {
            return this.key;
        }

        @NotNull
        public final HudListener getDelegate() {
            return this.delegate;
        }

        @NotNull
        public final LazyListenerSetting getSetting() {
            return this.setting;
        }

        @NotNull
        public final Function1<HudPlayer, Double> getInitialBuild() {
            return this.initialBuild;
        }

        private final LazyValueKey key(HudPlayer $this$key) {
            UUID uUID = $this$key.uuid();
            Intrinsics.checkNotNullExpressionValue(uUID, "uuid(...)");
            return new LazyValueKey(uUID, this.key);
        }

        public double getValue(@NotNull HudPlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            double get2 = this.delegate.getValue(player);
            return ((LazyValueAccess)this.setting.getCache().computeIfAbsent((Object)this.key(player), arg_0 -> LazyListener.getValue$lambda$1(arg_0 -> LazyListener.getValue$lambda$0(this, player, arg_0), arg_0))).invoke(get2);
        }

        public void clear(@NotNull HudPlayer player) {
            Intrinsics.checkNotNullParameter(player, "player");
            this.setting.getCache().remove((Object)this.key(player));
            this.delegate.clear(player);
        }

        private static final LazyValueAccess getValue$lambda$0(LazyListener this$0, HudPlayer $player, LazyValueKey it) {
            return new LazyValueAccess(this$0.setting.getDelay(), this$0.setting.getMultiplier(), RangesKt.coerceAtMost(RangesKt.coerceAtLeast(((Number)this$0.initialBuild.invoke($player)).doubleValue(), 0.0), 1.0));
        }

        private static final LazyValueAccess getValue$lambda$1(Function1 $tmp0, Object p0) {
            return (LazyValueAccess)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyListenerSetting;", "", "section", "Lkr/toxicity/hud/api/yaml/YamlObject;", "<init>", "(Lkr/toxicity/hud/api/yaml/YamlObject;)V", "delay", "", "getDelay", "()I", "multiplier", "", "getMultiplier", "()D", "cache", "Lkr/toxicity/hud/shaded/net/jodah/expiringmap/ExpiringMap;", "Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyValueKey;", "Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyValueAccess;", "getCache", "()Lnet/jodah/expiringmap/ExpiringMap;", "dist"})
    private static final class LazyListenerSetting {
        private final int delay;
        private final double multiplier;
        @NotNull
        private final ExpiringMap<LazyValueKey, LazyValueAccess> cache;

        public LazyListenerSetting(@NotNull YamlObject section) {
            Intrinsics.checkNotNullParameter(section, "section");
            this.delay = RangesKt.coerceAtLeast(section.getAsInt("delay", 0), 0);
            this.multiplier = RangesKt.coerceAtMost(RangesKt.coerceAtLeast(section.getAsDouble("multiplier", 0.5), 0.0), 1.0);
            ExpiringMap expiringMap = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.ACCESSED).expiration(RangesKt.coerceAtLeast(section.getAsLong("expiring-second", 5L), 1L), TimeUnit.SECONDS).build();
            Intrinsics.checkNotNullExpressionValue(expiringMap, "build(...)");
            this.cache = expiringMap;
        }

        public final int getDelay() {
            return this.delay;
        }

        public final double getMultiplier() {
            return this.multiplier;
        }

        @NotNull
        public final ExpiringMap<LazyValueKey, LazyValueAccess> getCache() {
            return this.cache;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyValueAccess;", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "", "delay", "", "multiplier", "value", "<init>", "(IDD)V", "t", "delta", "invoke", "plus", "(D)Ljava/lang/Double;", "dist"})
    private static final class LazyValueAccess
    implements Function1<Double, Double> {
        private final int delay;
        private final double multiplier;
        private double value;
        private int t;
        private double delta;

        public LazyValueAccess(int delay, double multiplier, double value) {
            this.delay = delay;
            this.multiplier = multiplier;
            this.value = value;
        }

        @Override
        @NotNull
        public Double invoke(double plus2) {
            double newDelta = plus2 - this.value;
            if (Math.abs(newDelta) >= 0.1 && Math.abs(newDelta - this.delta) > 0.75 * Math.abs(this.delta)) {
                this.t = 0;
            }
            this.delta = newDelta;
            ++this.t;
            if (this.t < this.delay) {
                return this.value;
            }
            this.value = INSTANCE.checkMinThreshold(this.value, plus2) ? plus2 : this.value * (1.0 - this.multiplier) + plus2 * this.multiplier;
            return this.value;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/hud/manager/ListenerManagerImpl$LazyValueKey;", "", "uuid", "Ljava/util/UUID;", "key", "<init>", "(Ljava/util/UUID;Ljava/lang/Object;)V", "getUuid", "()Ljava/util/UUID;", "getKey", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dist"})
    private static final class LazyValueKey {
        @NotNull
        private final UUID uuid;
        @NotNull
        private final Object key;

        public LazyValueKey(@NotNull UUID uuid, @NotNull Object key) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(key, "key");
            this.uuid = uuid;
            this.key = key;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final Object getKey() {
            return this.key;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        @NotNull
        public final Object component2() {
            return this.key;
        }

        @NotNull
        public final LazyValueKey copy(@NotNull UUID uuid, @NotNull Object key) {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            Intrinsics.checkNotNullParameter(key, "key");
            return new LazyValueKey(uuid, key);
        }

        public static /* synthetic */ LazyValueKey copy$default(LazyValueKey lazyValueKey, UUID uUID, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                uUID = lazyValueKey.uuid;
            }
            if ((n & 2) != 0) {
                object = lazyValueKey.key;
            }
            return lazyValueKey.copy(uUID, object);
        }

        @NotNull
        public String toString() {
            return "LazyValueKey(uuid=" + this.uuid + ", key=" + this.key + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + this.key.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LazyValueKey)) {
                return false;
            }
            LazyValueKey lazyValueKey = (LazyValueKey)other;
            if (!Intrinsics.areEqual(this.uuid, lazyValueKey.uuid)) {
                return false;
            }
            return Intrinsics.areEqual(this.key, lazyValueKey.key);
        }
    }
}

