/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.bootstrap.fabric;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kr.toxicity.hud.api.adapter.LocationWrapper;
import kr.toxicity.hud.api.scheduler.HudScheduler;
import kr.toxicity.hud.api.scheduler.HudTask;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.NoWhenBranchMatchedException;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntries;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntriesKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.ListsKt;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler;", "Lkr/toxicity/hud/api/scheduler/HudScheduler;", "<init>", "()V", "serverTasks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$SyncFabricTask;", "worldTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "executors", "Ljava/util/concurrent/ScheduledExecutorService;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "stopAll", "", "task", "Lkr/toxicity/hud/api/scheduler/HudTask;", "runnable", "Ljava/lang/Runnable;", "location", "Lkr/toxicity/hud/api/adapter/LocationWrapper;", "taskLater", "delay", "", "asyncTask", "asyncTaskLater", "asyncTaskTimer", "period", "SyncFabricTask", "TaskType", "AsyncFabricTask", "fabric"})
public final class FabricScheduler
implements HudScheduler {
    @NotNull
    private final ConcurrentLinkedQueue<SyncFabricTask> serverTasks = new ConcurrentLinkedQueue();
    @NotNull
    private final ConcurrentHashMap<String, Collection<SyncFabricTask>> worldTasks = new ConcurrentHashMap();
    private final ScheduledExecutorService executors = Executors.newScheduledThreadPool(256);

    public FabricScheduler() {
        ServerTickEvents.START_SERVER_TICK.register(arg_0 -> FabricScheduler._init_$lambda$0(this, arg_0));
        ServerTickEvents.START_WORLD_TICK.register(arg_0 -> FabricScheduler._init_$lambda$1(this, arg_0));
    }

    public final void stopAll() {
        this.serverTasks.clear();
        this.worldTasks.clear();
        this.executors.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized HudTask task(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        SyncFabricTask task = new SyncFabricTask(TaskType.REMOVE, 0L, 1L, runnable);
        ConcurrentLinkedQueue<SyncFabricTask> concurrentLinkedQueue = this.serverTasks;
        synchronized (concurrentLinkedQueue) {
            boolean bl = false;
            boolean bl2 = this.serverTasks.add(task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HudTask task(@NotNull LocationWrapper location, @NotNull Runnable runnable) {
        Collection list;
        Collection collection;
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        SyncFabricTask task = new SyncFabricTask(TaskType.REMOVE, 0L, 1L, runnable);
        ConcurrentHashMap<String, Collection<SyncFabricTask>> concurrentHashMap = this.worldTasks;
        synchronized (concurrentHashMap) {
            boolean bl = false;
            Collection collection2 = this.worldTasks.computeIfAbsent(location.world().name(), arg_0 -> FabricScheduler.task$lambda$1$1(FabricScheduler::task$lambda$1$0, arg_0));
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var7_4
            collection = collection2;
        }
        Intrinsics.checkNotNullExpressionValue(collection, "synchronized(...)");
        Collection collection3 = list = collection;
        synchronized (collection3) {
            boolean bl = false;
            boolean bl2 = list.add(task);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public HudTask taskLater(long delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        SyncFabricTask task = new SyncFabricTask(TaskType.REMOVE, delay, 1L, runnable);
        ConcurrentLinkedQueue<SyncFabricTask> concurrentLinkedQueue = this.serverTasks;
        synchronized (concurrentLinkedQueue) {
            boolean bl = false;
            boolean bl2 = this.serverTasks.add(task);
        }
        return task;
    }

    @NotNull
    public HudTask asyncTask(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        ScheduledFuture<?> scheduledFuture = this.executors.schedule(runnable, 1L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "schedule(...)");
        return new AsyncFabricTask(scheduledFuture);
    }

    @NotNull
    public HudTask asyncTaskLater(long delay, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        if (delay < 0L) {
            throw new RuntimeException("delay < 0");
        }
        ScheduledFuture<?> scheduledFuture = this.executors.schedule(runnable, delay * (long)50, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "schedule(...)");
        return new AsyncFabricTask(scheduledFuture);
    }

    @NotNull
    public HudTask asyncTaskTimer(long delay, long period, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        if (delay < 0L) {
            throw new RuntimeException("delay < 0");
        }
        if (period < 1L) {
            throw new RuntimeException("period < 1");
        }
        ScheduledFuture<?> scheduledFuture = this.executors.scheduleAtFixedRate(runnable, delay * (long)50, period * (long)50, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, "scheduleAtFixedRate(...)");
        return new AsyncFabricTask(scheduledFuture);
    }

    private static final void _init_$lambda$0(FabricScheduler this$0, MinecraftServer it) {
        ListsKt.removeIfSync((Collection)this$0.serverTasks, FabricScheduler::lambda$0$0);
    }

    private static final boolean lambda$0$0(SyncFabricTask it) {
        it.run();
        return it.isCancelled();
    }

    private static final void _init_$lambda$1(FabricScheduler this$0, class_3218 it) {
        Collection<Collection<SyncFabricTask>> collection = this$0.worldTasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        ListsKt.removeIfSync(collection, FabricScheduler::lambda$1$0);
    }

    private static final boolean lambda$1$0(Collection list) {
        Intrinsics.checkNotNullParameter(list, "list");
        ListsKt.removeIfSync(list, FabricScheduler::lambda$1$0$0);
        return list.isEmpty();
    }

    private static final boolean lambda$1$0$0(SyncFabricTask it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.run();
        return it.isCancelled();
    }

    private static final Collection task$lambda$1$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ConcurrentLinkedQueue();
    }

    private static final Collection task$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Collection)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$AsyncFabricTask;", "Lkr/toxicity/hud/api/scheduler/HudTask;", "delegate", "Ljava/util/concurrent/ScheduledFuture;", "<init>", "(Ljava/util/concurrent/ScheduledFuture;)V", "cancel", "", "isCancelled", "", "fabric"})
    private static final class AsyncFabricTask
    implements HudTask {
        @NotNull
        private final ScheduledFuture<?> delegate;

        public AsyncFabricTask(@NotNull ScheduledFuture<?> delegate) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            this.delegate = delegate;
        }

        public void cancel() {
            this.delegate.cancel(true);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\f\u001a\u00020\u000eH\u0016J\u0006\u0010\u0007\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$SyncFabricTask;", "Lkr/toxicity/hud/api/scheduler/HudTask;", "type", "Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$TaskType;", "delay", "", "period", "run", "Ljava/lang/Runnable;", "<init>", "(Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$TaskType;JJLjava/lang/Runnable;)V", "i", "cancel", "", "", "isCancelled", "fabric"})
    private static final class SyncFabricTask
    implements HudTask {
        @NotNull
        private final TaskType type;
        private final long period;
        @NotNull
        private final Runnable run;
        private long i;
        private volatile boolean cancel;

        public SyncFabricTask(@NotNull TaskType type, long delay, long period, @NotNull Runnable run) {
            Intrinsics.checkNotNullParameter((Object)type, "type");
            Intrinsics.checkNotNullParameter(run, "run");
            this.type = type;
            this.period = period;
            this.run = run;
            this.i = -delay;
        }

        public synchronized void cancel() {
            this.cancel = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            this.run.run();
            ++this.i;
            if (this.i >= this.period) {
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 1: {
                        SyncFabricTask syncFabricTask = this;
                        synchronized (syncFabricTask) {
                            boolean bl = false;
                            this.cancel = true;
                            Unit unit = Unit.INSTANCE;
                            break;
                        }
                    }
                    case 2: {
                        this.i = 0L;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }

        public synchronized boolean isCancelled() {
            return this.cancel;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TaskType.values().length];
                try {
                    nArray[TaskType.REMOVE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TaskType.LOOP.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lkr/toxicity/hud/bootstrap/fabric/FabricScheduler$TaskType;", "", "<init>", "(Ljava/lang/String;I)V", "REMOVE", "LOOP", "fabric"})
    private static final class TaskType
    extends Enum<TaskType> {
        public static final /* enum */ TaskType REMOVE = new TaskType();
        public static final /* enum */ TaskType LOOP = new TaskType();
        private static final /* synthetic */ TaskType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TaskType[] values() {
            return (TaskType[])$VALUES.clone();
        }

        public static TaskType valueOf(String value) {
            return Enum.valueOf(TaskType.class, value);
        }

        @NotNull
        public static EnumEntries<TaskType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = taskTypeArray = new TaskType[]{TaskType.REMOVE, TaskType.LOOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

