/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.placeholder;

import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import kr.toxicity.hud.api.placeholder.PlaceholderContainer;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.update.UpdateEvent;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface HudPlaceholder<T> {
    @NotNull
    public Function<HudPlayer, T> invoke(@NotNull @Unmodifiable List<String> var1, @NotNull UpdateEvent var2);

    public int getRequiredArgsLength();

    @NotNull
    public static <T> HudPlaceholder<T> of(final @NotNull PlaceholderFunction<T> biFunction) {
        Objects.requireNonNull(biFunction);
        return new HudPlaceholder<T>(){

            @Override
            @NotNull
            public Function<HudPlayer, T> invoke(@NotNull @Unmodifiable List<String> args, @NotNull UpdateEvent reason) {
                return (Function)biFunction.apply(args, reason);
            }

            @Override
            public int getRequiredArgsLength() {
                return 0;
            }
        };
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface PlaceholderFunction<T>
    extends BiFunction<List<String>, UpdateEvent, Function<HudPlayer, T>> {
        @NotNull
        public static <T> PlaceholderFunction<T> of(@NotNull Function<HudPlayer, T> function) {
            return (l, u) -> function;
        }
    }

    public static class Builder<T> {
        private int requiredArgsLength = 0;
        private PlaceholderFunction<T> function = (l, u) -> {
            throw new RuntimeException();
        };

        private Builder() {
        }

        @NotNull
        public Builder<T> requiredArgsLength(int requiredArgsLength) {
            this.requiredArgsLength = requiredArgsLength;
            return this;
        }

        @NotNull
        public Builder<T> function(@NotNull PlaceholderFunction<T> function) {
            this.function = Objects.requireNonNull(function, "function");
            return this;
        }

        @NotNull
        public HudPlaceholder<T> build() {
            return new HudPlaceholder<T>(){

                @Override
                @NotNull
                public Function<HudPlayer, T> invoke(@NotNull @Unmodifiable List<String> args, @NotNull UpdateEvent reason) {
                    return (Function)function.apply(args, reason);
                }

                @Override
                public int getRequiredArgsLength() {
                    return requiredArgsLength;
                }
            };
        }

        public void add(@NotNull String name, @NotNull PlaceholderContainer<T> container) {
            container.addPlaceholder(name, this.build());
        }

        @Generated
        public int getRequiredArgsLength() {
            return this.requiredArgsLength;
        }

        @Generated
        public PlaceholderFunction<T> getFunction() {
            return this.function;
        }
    }
}

