/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kr.toxicity.hud.api.adapter.LocationWrapper;
import kr.toxicity.hud.api.player.PointedLocationSource;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PointedLocation(@NotNull PointedLocationSource source, @NotNull String name, @Nullable String icon, @NotNull LocationWrapper location) {
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointedLocation that = (PointedLocation)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    @NotNull
    public static PointedLocation deserialize(@NotNull YamlObject data) {
        return new PointedLocation(PointedLocationSource.INTERNAL, data.getAsString("name", "unknown"), Optional.ofNullable(data.get("icon")).map(YamlElement::asString).orElse(null), LocationWrapper.deserialize(Objects.requireNonNull(data.get("location"), "location").asObject()));
    }

    @NotNull
    public static PointedLocation deserialize(@NotNull JsonObject data) {
        return new PointedLocation(PointedLocationSource.INTERNAL, Optional.ofNullable(data.getAsJsonPrimitive("name")).map(JsonPrimitive::getAsString).orElse("unknown"), Optional.ofNullable(data.getAsJsonPrimitive("icon")).map(JsonPrimitive::getAsString).orElse(null), LocationWrapper.deserialize(Objects.requireNonNull(data.getAsJsonObject("location"), "location")));
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        if (this.icon != null) {
            map.put("icon", this.icon);
        }
        map.put("location", this.location.serialize());
        return map;
    }
}

