/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.nms.v1_19_R1.entity;

import java.util.Set;
import kr.toxicity.hud.nms.v1_19_R1.entity.CraftsKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.util.TriState;
import net.minecraft.world.entity.Entity;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lkr/toxicity/hud/nms/v1_19_R1/entity/CraftEntityView;", "Lorg/bukkit/craftbukkit/v1_19_R1/entity/CraftEntity;", "source", "<init>", "(Lorg/bukkit/craftbukkit/v1_19_R1/entity/CraftEntity;)V", "getSource", "()Lorg/bukkit/craftbukkit/v1_19_R1/entity/CraftEntity;", "getType", "Lorg/bukkit/entity/EntityType;", "getHandle", "Lnet/minecraft/world/entity/Entity;", "getPersistentDataContainer", "Lorg/bukkit/craftbukkit/v1_19_R1/persistence/CraftPersistentDataContainer;", "getLastDamageCause", "Lorg/bukkit/event/entity/EntityDamageEvent;", "setLastDamageCause", "", "event", "permissionValue", "Lnet/kyori/adventure/util/TriState;", "permission", "Lorg/bukkit/permissions/Permission;", "", "getEffectivePermissions", "", "Lorg/bukkit/permissions/PermissionAttachmentInfo;", "hasPermission", "", "name", "perm", "isPermissionSet", "recalculatePermissions", "v1_19_R1"})
public final class CraftEntityView
extends CraftEntity {
    @NotNull
    private final CraftEntity source;

    public CraftEntityView(@NotNull CraftEntity source) {
        Intrinsics.checkNotNullParameter(source, "source");
        Server server = Bukkit.getServer();
        Intrinsics.checkNotNull(server, "null cannot be cast to non-null type org.bukkit.craftbukkit.v1_19_R1.CraftServer");
        super((CraftServer)server, CraftsKt.getUnsafeHandle(source));
        this.source = source;
    }

    @NotNull
    public final CraftEntity getSource() {
        return this.source;
    }

    @NotNull
    public EntityType getType() {
        EntityType entityType = this.source.getType();
        Intrinsics.checkNotNullExpressionValue(entityType, "getType(...)");
        return entityType;
    }

    @Nullable
    public Entity getHandle() {
        return CraftsKt.getUnsafeHandle(this.source);
    }

    @NotNull
    public CraftPersistentDataContainer getPersistentDataContainer() {
        CraftPersistentDataContainer craftPersistentDataContainer = this.source.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(craftPersistentDataContainer, "getPersistentDataContainer(...)");
        return craftPersistentDataContainer;
    }

    @Nullable
    public EntityDamageEvent getLastDamageCause() {
        return this.source.getLastDamageCause();
    }

    public void setLastDamageCause(@Nullable EntityDamageEvent event) {
        this.source.setLastDamageCause(event);
    }

    @NotNull
    public TriState permissionValue(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        TriState triState = this.source.permissionValue(permission);
        Intrinsics.checkNotNullExpressionValue(triState, "permissionValue(...)");
        return triState;
    }

    @NotNull
    public TriState permissionValue(@NotNull String permission) {
        Intrinsics.checkNotNullParameter(permission, "permission");
        TriState triState = this.source.permissionValue(permission);
        Intrinsics.checkNotNullExpressionValue(triState, "permissionValue(...)");
        return triState;
    }

    @NotNull
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        Set set = this.source.getEffectivePermissions();
        Intrinsics.checkNotNullExpressionValue(set, "getEffectivePermissions(...)");
        return set;
    }

    public boolean hasPermission(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.source.hasPermission(name);
    }

    public boolean hasPermission(@NotNull Permission perm) {
        Intrinsics.checkNotNullParameter(perm, "perm");
        return this.source.hasPermission(perm);
    }

    public boolean isPermissionSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.source.isPermissionSet(name);
    }

    public boolean isPermissionSet(@NotNull Permission perm) {
        Intrinsics.checkNotNullParameter(perm, "perm");
        return this.source.isPermissionSet(perm);
    }

    public void recalculatePermissions() {
        this.source.recalculatePermissions();
    }
}

