/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.configuration;

import java.util.Map;
import java.util.Objects;
import kr.toxicity.hud.api.configuration.HudComponentSupplier;
import kr.toxicity.hud.api.configuration.HudObjectType;
import kr.toxicity.hud.api.player.HudPlayer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public interface HudObject {
    @NotNull
    public String getName();

    public boolean isDefault();

    @NotNull
    public HudObjectType<?> getType();

    public long tick();

    @ApiStatus.Internal
    @NotNull
    default public HudComponentSupplier<?> getComponentsByType(@NotNull HudPlayer player) {
        return this.getType().invoke(this, player);
    }

    @ApiStatus.Internal
    @NotNull
    default public Identifier identifier() {
        return new Identifier(this);
    }

    default public boolean add(@NotNull HudPlayer player) {
        Map<Identifier, HudComponentSupplier<?>> objects = player.getHudObjects();
        return objects.putIfAbsent(this.identifier(), this.getComponentsByType(player)) == null;
    }

    default public boolean remove(@NotNull HudPlayer player) {
        Map<Identifier, HudComponentSupplier<?>> objects = player.getHudObjects();
        return objects.remove(this.identifier()) != null;
    }

    public record Identifier(@NotNull HudObject source) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            HudObject source1;
            if (!(o instanceof Identifier)) return false;
            Identifier identifier = (Identifier)o;
            try {
                HudObject hudObject;
                source1 = hudObject = identifier.source();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (this.source.getClass() != source1.getClass()) return false;
            if (!Objects.equals(this.source.getName(), source1.getName())) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.source.getName().hashCode());
        }
    }
}

