/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.configuration;

import java.util.Collections;
import java.util.function.BiFunction;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.configuration.HudComponentSupplier;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.update.UpdateEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public record HudObjectType<T extends HudObject>(@NotNull Class<T> clazz, @NotNull String name, @NotNull BiFunction<T, HudPlayer, HudComponentSupplier<T>> function) {
    public static final HudObjectType<Hud> HUD = new HudObjectType<Hud>(Hud.class, "hud", Hud::createRenderer);
    public static final HudObjectType<Popup> POPUP = new HudObjectType<Popup>(Popup.class, "popup", (popup, player) -> HudComponentSupplier.of(popup, () -> {
        popup.show(UpdateEvent.EMPTY, (HudPlayer)player);
        return Collections.emptyList();
    }));
    public static final HudObjectType<Compass> COMPASS = new HudObjectType<Compass>(Compass.class, "compass", Compass::indicate);

    @ApiStatus.Internal
    @NotNull
    public HudComponentSupplier<?> invoke(@NotNull HudObject object, @NotNull HudPlayer player) {
        try {
            return this.function.apply((HudObject)this.clazz.cast(object), player);
        }
        catch (Throwable e) {
            return HudComponentSupplier.empty(object);
        }
    }
}

