/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.manager;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kr.toxicity.hud.api.BetterHudAPI;
import kr.toxicity.hud.api.BetterHudBootstrap;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ShaderManager {
    public static final ShaderTag EMPTY_TAG = ShaderManager.newTag().add("GenerateOtherMainMethod", Collections.emptyList()).add("GenerateOtherDefinedMethod", Collections.emptyList());
    public static final ShaderTagSupplier EMPTY_SUPPLIER = () -> EMPTY_TAG;

    public void addConstant(@NotNull String var1, @NotNull String var2);

    public void addTagSupplier(@NotNull ShaderType var1, @NotNull ShaderTagSupplier var2);

    @NotNull
    public static ShaderTag newTag() {
        return new ShaderTag();
    }

    public static class ShaderTag {
        private final Map<String, List<String>> lines = new HashMap<String, List<String>>();

        private ShaderTag() {
        }

        @NotNull
        public ShaderTag add(@NotNull String tag, @NotNull List<String> line) {
            Objects.requireNonNull(tag);
            Objects.requireNonNull(line);
            List<String> get2 = this.lines.get(tag);
            if (get2 == null) {
                this.lines.put(tag, line);
            } else {
                ArrayList<String> list = new ArrayList<String>(get2.size() + line.size());
                list.addAll(get2);
                list.addAll(line);
                this.lines.put(tag, list);
            }
            return this;
        }

        @NotNull
        public ShaderTag plus(@NotNull ShaderTag tag) {
            Objects.requireNonNull(tag);
            ShaderTag newTag = new ShaderTag();
            this.lines.forEach(newTag::add);
            tag.lines.forEach(newTag::add);
            return newTag;
        }

        @ApiStatus.Internal
        @Nullable
        public List<String> get(@NotNull String tagName) {
            return this.lines.get(tagName);
        }
    }

    @FunctionalInterface
    public static interface ShaderTagSupplier
    extends Supplier<ShaderTag> {
        default public ShaderTagSupplier plus(@NotNull ShaderTagSupplier other) {
            return () -> ((ShaderTag)this.get()).plus((ShaderTag)other.get());
        }
    }

    public static enum ShaderType {
        TEXT_VERTEX("text.vsh"),
        TEXT_FRAGMENT("text.fsh"),
        ITEM_VERTEX("item.vsh"),
        ITEM_FRAGMENT("item.fsh"),
        BLOCK_VERTEX("block.vsh"),
        BLOCK_FRAGMENT("block.fsh");

        @NotNull
        private final String fileName;

        @NotNull
        public List<String> lines() {
            ArrayList<String> lines;
            block36: {
                BetterHudBootstrap bootstrap = BetterHudAPI.inst().bootstrap();
                File dataFolder = bootstrap.dataFolder();
                File shaderLocation = new File(dataFolder, "shaders");
                if (!shaderLocation.exists() && !shaderLocation.mkdirs()) {
                    bootstrap.logger().warn("Unable to create folder BetterHud/shaders.");
                }
                File dataFile = new File(shaderLocation, this.fileName);
                lines = new ArrayList<String>();
                if (!dataFile.exists()) {
                    try (InputStream resourceStream = Objects.requireNonNull(bootstrap.resource(this.fileName), "Unknown resource: " + this.fileName);
                         FileOutputStream fileStream = new FileOutputStream(dataFile);
                         BufferedOutputStream bufferedFileStream = new BufferedOutputStream(fileStream);){
                        byte[] bytes = resourceStream.readAllBytes();
                        bufferedFileStream.write(bytes);
                        try (BufferedReader read = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));){
                            String line;
                            while ((line = read.readLine()) != null) {
                                lines.add(line);
                            }
                            break block36;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Unable to read a lines of stream.");
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("plugin jar file has a problem.");
                    }
                }
                try (BufferedReader read = new BufferedReader(new FileReader(dataFile, StandardCharsets.UTF_8));){
                    String line;
                    while ((line = read.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read a lines of stream.");
                }
            }
            return lines;
        }

        @Generated
        private ShaderType(String fileName) {
            if (fileName == null) {
                throw new NullPointerException("fileName is marked non-null but is null");
            }
            this.fileName = fileName;
        }

        @NotNull
        @Generated
        public String getFileName() {
            return this.fileName;
        }
    }
}

