/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.background.HudBackground;
import kr.toxicity.hud.image.LoadedImage;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.EncodeManager;
import kr.toxicity.hud.pack.PackGenerator;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.FilesKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.EncodesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/manager/BackgroundManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "backgroundMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/hud/background/HudBackground;", "Lkr/toxicity/hud/shaded/kotlin/collections/HashMap;", "start", "", "getBackground", "name", "reload", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "dist"})
public final class BackgroundManager
implements BetterHudManager {
    @NotNull
    public static final BackgroundManager INSTANCE = new BackgroundManager();
    @NotNull
    private static final HashMap<String, HudBackground> backgroundMap = new HashMap();

    private BackgroundManager() {
    }

    @Override
    public void start() {
    }

    @Nullable
    public final HudBackground getBackground(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return backgroundMap.get(name);
    }

    @Override
    public void reload(@NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        File folder = kr.toxicity.hud.util.FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "backgrounds");
        backgroundMap.clear();
        kr.toxicity.hud.util.FilesKt.forEach(folder, arg_0 -> BackgroundManager.reload$lambda$4(info, folder, resource, arg_0));
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final byte[] reload$lambda$4$lambda$3$getImage$lambda$1$lambda$0(LoadedImage $this_apply) {
        return ImagesKt.toByteArray($this_apply.getImage());
    }

    private static final LoadedImage reload$lambda$4$lambda$3$getImage(File backgroundFolder, String name, GlobalResource $resource, String imageName) {
        LoadedImage loadedImage;
        LoadedImage $this$reload_u24lambda_u244_u24lambda_u243_u24getImage_u24lambda_u241 = loadedImage = FunctionsKt.ifNull(ImagesKt.removeEmptyWidth$default(ImagesKt.toImage(kr.toxicity.hud.util.FilesKt.ifNotExist(new File(backgroundFolder, imageName + ".png"), "this image doesn't exist: " + imageName + ".png in " + name)), 0, 0, 3, null), "this image is empty: " + imageName + ".png in " + name);
        boolean bl = false;
        PackGenerator.INSTANCE.addTask((Iterable<String>)CollectionsKt.plus((Collection)$resource.getTextures(), EncodesKt.encodeKey("background_" + name + "_" + imageName, EncodeManager.EncodeNamespace.TEXTURES) + ".png"), () -> BackgroundManager.reload$lambda$4$lambda$3$getImage$lambda$1$lambda$0($this$reload_u24lambda_u244_u24lambda_u243_u24getImage_u24lambda_u241));
        return loadedImage;
    }

    private static final HudBackground reload$lambda$4$lambda$3$lambda$2(String $name, YamlObject $yaml, File $backgroundFolder, GlobalResource $resource) {
        return new HudBackground($name, BackgroundManager.reload$lambda$4$lambda$3$getImage($backgroundFolder, $name, $resource, "left"), BackgroundManager.reload$lambda$4$lambda$3$getImage($backgroundFolder, $name, $resource, "right"), BackgroundManager.reload$lambda$4$lambda$3$getImage($backgroundFolder, $name, $resource, "body"), new PixelLocation($yaml));
    }

    private static final Unit reload$lambda$4$lambda$3(File $it, File $folder, GlobalResource $resource, BackgroundManager $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        YamlObject yaml = YamlsKt.toYaml($it);
        String name = FilesKt.getNameWithoutExtension($it);
        File backgroundFolder = kr.toxicity.hud.util.FilesKt.subFolder($folder, name);
        MapsKt.putSync((Map)backgroundMap, "background", () -> BackgroundManager.reload$lambda$4$lambda$3$lambda$2(name, yaml, backgroundFolder, $resource));
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$4(ReloadInfo $info, File $folder, GlobalResource $resource, File it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(FilesKt.getExtension(it), "yml")) {
            BetterCommandSource betterCommandSource = $info.sender();
            Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
            FunctionsKt.runWithExceptionHandling(INSTANCE, betterCommandSource, "Unable to load this yml: " + it.getName(), arg_0 -> BackgroundManager.reload$lambda$4$lambda$3(it, $folder, $resource, arg_0));
        }
        return Unit.INSTANCE;
    }
}

