/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.manager.CompassManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.compass.CompassImpl;
import kr.toxicity.hud.compass.CompassType;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkr/toxicity/hud/manager/CompassManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/CompassManager;", "<init>", "()V", "compassMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/hud/compass/CompassImpl;", "start", "", "reload", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "getCompass", "Lkr/toxicity/hud/api/compass/Compass;", "name", "getAllNames", "", "getDefaultCompasses", "getAllCompasses", "dist"})
@SourceDebugExtension(value={"SMAP\nCompassManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompassManagerImpl.kt\nkr/toxicity/hud/manager/CompassManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n774#2:48\n865#2,2:49\n*S KotlinDebug\n*F\n+ 1 CompassManagerImpl.kt\nkr/toxicity/hud/manager/CompassManagerImpl\n*L\n42#1:48\n42#1:49,2\n*E\n"})
public final class CompassManagerImpl
implements BetterHudManager,
CompassManager {
    @NotNull
    public static final CompassManagerImpl INSTANCE = new CompassManagerImpl();
    @NotNull
    private static final HashMap<String, CompassImpl> compassMap = new HashMap();

    private CompassManagerImpl() {
    }

    @Override
    public void start() {
    }

    @Override
    public void reload(@NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        compassMap.clear();
        File assets = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "assets");
        File file = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "compasses");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> CompassManagerImpl.reload$lambda$3(info, resource, assets, arg_0, arg_1, arg_2));
    }

    @Override
    public void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Compass getCompass(@NotNull String name) {
        CompassImpl compassImpl;
        Intrinsics.checkNotNullParameter(name, "name");
        HashMap<String, CompassImpl> hashMap = compassMap;
        synchronized (hashMap) {
            boolean bl = false;
            compassImpl = compassMap.get(name);
        }
        return compassImpl;
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        Set<String> set = Collections.unmodifiableSet(compassMap.keySet());
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Compass> getDefaultCompasses() {
        void $this$filterTo$iv$iv;
        Collection<CompassImpl> collection = compassMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompassImpl it = (CompassImpl)element$iv$iv;
            boolean bl = false;
            if (!it.isDefault()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public Set<Compass> getAllCompasses() {
        Collection<CompassImpl> collection = compassMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final CompassImpl reload$lambda$3$lambda$2$lambda$1(YamlObject $c, GlobalResource $resource, File $assets, String $s) {
        YamlElement yamlElement = $c.get("type");
        String $this$reload_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240 = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, "type value not set.");
        boolean bl = false;
        String string = $this$reload_u24lambda_u243_u24lambda_u242_u24lambda_u241_u24lambda_u240.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return CompassType.valueOf(string).build($resource, $assets, $s, $c);
    }

    private static final Unit reload$lambda$3$lambda$2(YamlObject $c, GlobalResource $resource, File $assets, String $s, CompassManagerImpl $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        MapsKt.putSync((Map)compassMap, "compass", () -> CompassManagerImpl.reload$lambda$3$lambda$2$lambda$1($c, $resource, $assets, $s));
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$3(ReloadInfo $info, GlobalResource $resource, File $assets, File f, String s, YamlObject c) {
        Intrinsics.checkNotNullParameter(f, "f");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(c, "c");
        BetterCommandSource betterCommandSource = $info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        FunctionsKt.runWithExceptionHandling(INSTANCE, betterCommandSource, "Unable to load this compass: " + s + " in " + f.getName(), arg_0 -> CompassManagerImpl.reload$lambda$3$lambda$2(c, $resource, $assets, s, arg_0));
        return Unit.INSTANCE;
    }
}

