/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.toxicity.hud.api.compass.Compass;
import kr.toxicity.hud.api.configuration.HudObject;
import kr.toxicity.hud.api.database.HudDatabase;
import kr.toxicity.hud.api.database.HudDatabaseConnector;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.manager.DatabaseManager;
import kr.toxicity.hud.api.player.HudPlayer;
import kr.toxicity.hud.api.player.PointedLocation;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.popup.Popup;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.configuration.PluginConfiguration;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.manager.CompassManagerImpl;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.manager.DatabaseManagerImpl;
import kr.toxicity.hud.manager.HudManagerImpl;
import kr.toxicity.hud.manager.PopupManagerImpl;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.AdventuresKt;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import kr.toxicity.hud.yaml.YamlObjectImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/hud/manager/DatabaseManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/DatabaseManager;", "<init>", "()V", "defaultConnector", "Lkr/toxicity/hud/api/database/HudDatabaseConnector;", "connectionMap", "", "", "current", "Lkr/toxicity/hud/api/database/HudDatabase;", "Lorg/jetbrains/annotations/NotNull;", "start", "", "getCurrentDatabase", "addDatabase", "", "name", "connector", "reload", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "end", "dist"})
public final class DatabaseManagerImpl
implements BetterHudManager,
DatabaseManager {
    @NotNull
    public static final DatabaseManagerImpl INSTANCE = new DatabaseManagerImpl();
    @NotNull
    private static final HudDatabaseConnector defaultConnector = DatabaseManagerImpl::defaultConnector$lambda$0;
    @NotNull
    private static final Map<String, HudDatabaseConnector> connectionMap;
    @NotNull
    private static HudDatabase current;

    private DatabaseManagerImpl() {
    }

    @Override
    public void start() {
    }

    @Override
    @NotNull
    public HudDatabase getCurrentDatabase() {
        return current;
    }

    @Override
    public boolean addDatabase(@NotNull String name, @NotNull HudDatabaseConnector connector) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(connector, "connector");
        return connectionMap.putIfAbsent(name, connector) == null;
    }

    @Override
    public void reload(@NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter(info, "info");
            Intrinsics.checkNotNullParameter(resource, "resource");
            Object object2 = this;
            try {
                DatabaseManagerImpl $this$reload_u24lambda_u244 = object2;
                boolean bl = false;
                current.close();
                YamlObject db = PluginConfiguration.DATABASE.create();
                YamlElement yamlElement = db.get("type");
                String type = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, "type value not set.");
                YamlElement yamlElement2 = db.get("info");
                YamlObject dbInfo = FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asObject() : null, "info configuration not set.");
                current = FunctionsKt.ifNull(connectionMap.get(type), "this database doesn't exist: " + type).connect(dbInfo);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block3;
            Object e = object = throwable;
            boolean bl = false;
            current = defaultConnector.connect(new YamlObjectImpl("", new LinkedHashMap()));
            String[] stringArray = new String[]{"Unable to connect the database.", "Reason: " + ((Throwable)e).getMessage()};
            PluginsKt.warn(stringArray);
            if (ConfigManagerImpl.INSTANCE.debug()) {
                ((Throwable)e).printStackTrace();
            }
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    @Override
    public void postReload() {
        BetterHudManager.DefaultImpls.postReload(this);
    }

    private static final HudDatabase defaultConnector$lambda$0(YamlObject it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new HudDatabase(){
            private boolean closed;

            private final File getFile(HudPlayer player) {
                return FilesKt.subFile(FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), ".users"), player.uuid() + ".yml");
            }

            public boolean isClosed() {
                return this.closed;
            }

            public void close() {
                this.closed = true;
            }

            public void load(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                PluginsKt.asyncTask(() -> defaultConnector.1.1.load$lambda$7(this, player));
            }

            /*
             * WARNING - void declaration
             */
            public boolean save(HudPlayer player) {
                Collection<Map<String, Object>> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LinkedHashMap<String, Object> linkedHashMap;
                Intrinsics.checkNotNullParameter(player, "player");
                LinkedHashMap<String, Object> $this$save_u24lambda_u2414 = linkedHashMap = new LinkedHashMap<String, Object>();
                boolean bl = false;
                defaultConnector.1.1.save$lambda$14$save($this$save_u24lambda_u2414, "popups", () -> defaultConnector.1.1.save$lambda$14$lambda$10(player));
                defaultConnector.1.1.save$lambda$14$save($this$save_u24lambda_u2414, "huds", () -> defaultConnector.1.1.save$lambda$14$lambda$11(player));
                defaultConnector.1.1.save$lambda$14$save($this$save_u24lambda_u2414, "compasses", () -> defaultConnector.1.1.save$lambda$14$lambda$12(player));
                Set<PointedLocation> set = player.pointers();
                Intrinsics.checkNotNullExpressionValue(set, "pointers(...)");
                Iterable iterable = set;
                String string = "locations";
                LinkedHashMap<String, Object> linkedHashMap2 = $this$save_u24lambda_u2414;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PointedLocation pointedLocation = (PointedLocation)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.serialize());
                }
                collection = (List)destination$iv$iv;
                linkedHashMap2.put(string, collection);
                YamlsKt.saveToYaml((Map<String, ? extends Object>)linkedHashMap, this.getFile(player));
                return true;
            }

            /*
             * WARNING - void declaration
             */
            private static final void load$lambda$7$add(YamlObject yaml, HudPlayer $player, String name, Function1<? super String, ? extends HudObject> mapper) {
                block2: {
                    void $this$forEach$iv;
                    void $this$mapNotNullTo$iv$iv;
                    YamlElement yamlElement = yaml.get(name);
                    if (yamlElement == null || (yamlElement = yamlElement.asArray()) == null) break block2;
                    Iterable $this$mapNotNull$iv = (Iterable)((Object)yamlElement);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        HudObject it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        YamlElement it = (YamlElement)element$iv$iv;
                        boolean bl2 = false;
                        String string = it.asString();
                        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
                        if (mapper.invoke(string) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (E element$iv : $this$forEach$iv) {
                        HudObject it = (HudObject)element$iv;
                        boolean bl = false;
                        if (it.isDefault()) continue;
                        it.add($player);
                    }
                }
            }

            private static final HudObject load$lambda$7$lambda$2(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return HudManagerImpl.INSTANCE.getHud(it);
            }

            private static final HudObject load$lambda$7$lambda$3(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return PopupManagerImpl.INSTANCE.getPopup(it);
            }

            private static final HudObject load$lambda$7$lambda$4(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return CompassManagerImpl.INSTANCE.getCompass(it);
            }

            private static final boolean load$lambda$7$lambda$6$lambda$5(HudPlayer $player, YamlElement $it, defaultConnector.1.1 $this$runWithExceptionHandling) {
                Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
                return $player.pointers().add(PointedLocation.deserialize($it.asObject()));
            }

            private static final Unit load$lambda$7(defaultConnector.1.1 this$0, HudPlayer $player) {
                block1: {
                    YamlObject yaml = YamlsKt.toYaml(this$0.getFile($player));
                    defaultConnector.1.1.load$lambda$7$add(yaml, $player, "huds", defaultConnector.1.1::load$lambda$7$lambda$2);
                    defaultConnector.1.1.load$lambda$7$add(yaml, $player, "popups", defaultConnector.1.1::load$lambda$7$lambda$3);
                    defaultConnector.1.1.load$lambda$7$add(yaml, $player, "compasses", defaultConnector.1.1::load$lambda$7$lambda$4);
                    YamlElement yamlElement = yaml.get("locations");
                    if (yamlElement == null || (yamlElement = yamlElement.asArray()) == null) break block1;
                    Iterable $this$forEach$iv = (Iterable)((Object)yamlElement);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        YamlElement it = (YamlElement)element$iv;
                        boolean bl = false;
                        FunctionsKt.runWithExceptionHandling(this$0, AdventuresKt.getCONSOLE(), "unable to load " + $player.name() + "'s location.", arg_0 -> defaultConnector.1.1.load$lambda$7$lambda$6$lambda$5($player, it, arg_0));
                    }
                }
                return Unit.INSTANCE;
            }

            /*
             * WARNING - void declaration
             */
            private static final void save$lambda$14$save(LinkedHashMap<String, Object> $this_apply, String name, Function0<? extends Set<? extends HudObject>> supplier) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                HudObject it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = supplier.invoke();
                String string = name;
                LinkedHashMap<String, Object> linkedHashMap = $this_apply;
                boolean $i$f$filter = false;
                void var5_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (HudObject)element$iv$iv;
                    boolean bl = false;
                    if (!(!it.isDefault())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<String> collection = (List)destination$iv$iv;
                $this$filter$iv = collection;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (HudObject)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                collection = (List)destination$iv$iv;
                linkedHashMap.put(string, collection);
            }

            private static final Set save$lambda$14$lambda$10(HudPlayer $player) {
                Set<Popup> set = $player.getPopups();
                Intrinsics.checkNotNullExpressionValue(set, "getPopups(...)");
                return set;
            }

            private static final Set save$lambda$14$lambda$11(HudPlayer $player) {
                Set<Hud> set = $player.getHuds();
                Intrinsics.checkNotNullExpressionValue(set, "getHuds(...)");
                return set;
            }

            private static final Set save$lambda$14$lambda$12(HudPlayer $player) {
                Set<Compass> set = $player.getCompasses();
                Intrinsics.checkNotNullExpressionValue(set, "getCompasses(...)");
                return set;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HudDatabase connectionMap$lambda$3(YamlObject it) {
        Connection connection;
        Intrinsics.checkNotNullParameter(it, "it");
        Class.forName("com.mysql.cj.jdbc.Driver");
        YamlElement yamlElement = it.get("host");
        String host = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, "unable to find the host value.");
        YamlElement yamlElement2 = it.get("database");
        String database = FunctionsKt.ifNull(yamlElement2 != null ? yamlElement2.asString() : null, "unable to find the database value.");
        YamlElement yamlElement3 = it.get("name");
        String name = FunctionsKt.ifNull(yamlElement3 != null ? yamlElement3.asString() : null, "unable to find the name value.");
        YamlElement yamlElement4 = it.get("password");
        String password = FunctionsKt.ifNull(yamlElement4 != null ? yamlElement4.asString() : null, "unable to find the password value.");
        Connection $this$connectionMap_u24lambda_u243_u24lambda_u242 = connection = DriverManager.getConnection("jdbc:mysql://" + host + "/" + database + "?autoReconnect=true&useSSL=false&cmaxReconnets=5&initialTimeout=1", name, password);
        boolean bl = false;
        AutoCloseable autoCloseable = $this$connectionMap_u24lambda_u243_u24lambda_u242.createStatement();
        Throwable throwable = null;
        try {
            Statement s = (Statement)autoCloseable;
            boolean bl2 = false;
            s.execute("CREATE TABLE IF NOT EXISTS enabled_hud(uuid CHAR(36) NOT NULL, type VARCHAR(255) NOT NULL, name VARCHAR(255) NOT NULL);");
            s.execute("CREATE TABLE IF NOT EXISTS enabled_pointed_location(uuid CHAR(36), name VARCHAR(255), value TEXT NOT NULL, PRIMARY KEY(uuid, name));");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Connection mysql = connection;
        return new HudDatabase(mysql){
            final /* synthetic */ Connection $mysql;
            {
                this.$mysql = $mysql;
            }

            public void close() {
                this.$mysql.close();
            }

            public boolean isClosed() {
                return this.$mysql.isClosed();
            }

            public void load(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                PluginsKt.asyncTask(() -> connectionMap.1.1.load$lambda$6(player, this.$mysql, this));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean save(HudPlayer player) {
                Intrinsics.checkNotNullParameter(player, "player");
                String string = player.uuid().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String uuid = string;
                Connection $this$save_u24lambda_u2417 = this.$mysql;
                boolean bl = false;
                AutoCloseable autoCloseable = $this$save_u24lambda_u2417.prepareStatement("DELETE FROM enabled_hud WHERE uuid = '" + uuid + "';");
                Throwable throwable = null;
                try {
                    PreparedStatement s22 = (PreparedStatement)autoCloseable;
                    boolean bl2 = false;
                    int s22 = s22.executeUpdate();
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                autoCloseable = $this$save_u24lambda_u2417.prepareStatement("DELETE FROM enabled_pointed_location WHERE uuid = '" + uuid + "';");
                throwable = null;
                try {
                    PreparedStatement s = (PreparedStatement)autoCloseable;
                    boolean bl3 = false;
                    int n = s.executeUpdate();
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                connectionMap.1.1.save$lambda$17$save($this$save_u24lambda_u2417, uuid, "hud", () -> connectionMap.1.1.save$lambda$17$lambda$12(player));
                connectionMap.1.1.save$lambda$17$save($this$save_u24lambda_u2417, uuid, "popup", () -> connectionMap.1.1.save$lambda$17$lambda$13(player));
                connectionMap.1.1.save$lambda$17$save($this$save_u24lambda_u2417, uuid, "compass", () -> connectionMap.1.1.save$lambda$17$lambda$14(player));
                Set<PointedLocation> set = player.pointers();
                Intrinsics.checkNotNullExpressionValue(set, "pointers(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PointedLocation it = (PointedLocation)element$iv;
                    boolean bl4 = false;
                    AutoCloseable autoCloseable2 = $this$save_u24lambda_u2417.prepareStatement("INSERT INTO enabled_pointed_location(uuid, name, value) VALUES(?, ?, ?);");
                    Throwable throwable2 = null;
                    try {
                        PreparedStatement s = (PreparedStatement)autoCloseable2;
                        boolean bl5 = false;
                        s.setString(1, uuid);
                        s.setString(2, it.name());
                        Map<String, Object> map = it.serialize();
                        Intrinsics.checkNotNullExpressionValue(map, "serialize(...)");
                        s.setString(3, GsonsKt.toBase64String(GsonsKt.toJsonElement(map)));
                        s.executeUpdate();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable2, throwable2);
                    }
                }
                return true;
            }

            private static final boolean load$lambda$6$lambda$5$lambda$4(HudPlayer $player, ResultSet $result, connectionMap.1.1 $this$runWithExceptionHandling) {
                Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
                Set<PointedLocation> set = $player.pointers();
                String string = $result.getString("value");
                Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                return set.add(PointedLocation.deserialize(GsonsKt.toBase64Json(string).getAsJsonObject()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private static final Unit load$lambda$6(HudPlayer $player, Connection $mysql, connectionMap.1.1 this$0) {
                ResultSet result2;
                Object s;
                String string = $player.uuid().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String uuid = string;
                AutoCloseable autoCloseable = $mysql.prepareStatement("SELECT type, name FROM enabled_hud WHERE uuid = '" + uuid + "';");
                Throwable throwable = null;
                try {
                    s = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    result2 = s.executeQuery();
                    while (result2.next()) {
                        block21: {
                            block22: {
                                Popup p;
                                String string2 = result2.getString("type");
                                if (string2 == null) continue;
                                switch (string2.hashCode()) {
                                    case 106852524: {
                                        if (string2.equals("popup")) break;
                                        break block21;
                                    }
                                    case 950484242: {
                                        if (string2.equals("compass")) break block22;
                                        break block21;
                                    }
                                    case 103671: {
                                        if (!string2.equals("hud")) break block21;
                                        String string3 = result2.getString("name");
                                        Intrinsics.checkNotNullExpressionValue(string3, "getString(...)");
                                        if (HudManagerImpl.INSTANCE.getHud(string3) != null) {
                                            Hud h;
                                            boolean bl2 = false;
                                            if (!h.isDefault()) {
                                                h.add($player);
                                            }
                                        }
                                        break block21;
                                    }
                                }
                                String string4 = result2.getString("popup");
                                Intrinsics.checkNotNullExpressionValue(string4, "getString(...)");
                                if (PopupManagerImpl.INSTANCE.getPopup(string4) == null) continue;
                                boolean bl3 = false;
                                if (p.isDefault()) continue;
                                p.add($player);
                                continue;
                            }
                            String string5 = result2.getString("compass");
                            Intrinsics.checkNotNullExpressionValue(string5, "getString(...)");
                            if (CompassManagerImpl.INSTANCE.getCompass(string5) != null) {
                                Compass c;
                                boolean bl4 = false;
                                if (c.isDefault()) continue;
                                c.add($player);
                                continue;
                            }
                        }
                    }
                    s = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                autoCloseable = $mysql.prepareStatement("SELECT value FROM enabled_pointed_location WHERE uuid = '" + uuid + "';");
                throwable = null;
                try {
                    s = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    result2 = s.executeQuery();
                    while (result2.next()) {
                        FunctionsKt.runWithExceptionHandling(this$0, AdventuresKt.getCONSOLE(), "unable to load " + $player.name() + "'s location.", arg_0 -> connectionMap.1.1.load$lambda$6$lambda$5$lambda$4($player, result2, arg_0));
                    }
                    Unit unit = Unit.INSTANCE;
                    return Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final void save$lambda$17$save(Connection $this_run, String uuid, String name, Function0<? extends Set<? extends HudObject>> supplier) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = supplier.invoke();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    HudObject h = (HudObject)element$iv$iv;
                    boolean bl = false;
                    if (!(!h.isDefault())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    HudObject h = (HudObject)element$iv;
                    boolean bl = false;
                    AutoCloseable autoCloseable = $this_run.prepareStatement("INSERT INTO enabled_hud(uuid, type, name) VALUES(?, ?, ?);");
                    Throwable throwable = null;
                    try {
                        PreparedStatement s = (PreparedStatement)autoCloseable;
                        boolean bl2 = false;
                        s.setString(1, uuid);
                        s.setString(2, name);
                        s.setString(3, h.getName());
                        s.executeUpdate();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally(autoCloseable, throwable);
                    }
                }
            }

            private static final Set save$lambda$17$lambda$12(HudPlayer $player) {
                Set<Hud> set = $player.getHuds();
                Intrinsics.checkNotNullExpressionValue(set, "getHuds(...)");
                return set;
            }

            private static final Set save$lambda$17$lambda$13(HudPlayer $player) {
                Set<Popup> set = $player.getPopups();
                Intrinsics.checkNotNullExpressionValue(set, "getPopups(...)");
                return set;
            }

            private static final Set save$lambda$17$lambda$14(HudPlayer $player) {
                Set<Compass> set = $player.getCompasses();
                Intrinsics.checkNotNullExpressionValue(set, "getCompasses(...)");
                return set;
            }
        };
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("yml", defaultConnector), TuplesKt.to("mysql", DatabaseManagerImpl::connectionMap$lambda$3)};
        connectionMap = MapsKt.mutableMapOf(pairArray);
        HudDatabase hudDatabase = defaultConnector.connect(new YamlObjectImpl("", new LinkedHashMap()));
        Intrinsics.checkNotNullExpressionValue(hudDatabase, "connect(...)");
        current = hudDatabase;
    }
}

