/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.hud.Hud;
import kr.toxicity.hud.api.manager.HudManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.hud.HudImpl;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/hud/manager/HudManagerImpl;", "Lkr/toxicity/hud/manager/BetterHudManager;", "Lkr/toxicity/hud/api/manager/HudManager;", "<init>", "()V", "hudMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/hud/hud/HudImpl;", "start", "", "getHud", "Lkr/toxicity/hud/api/hud/Hud;", "name", "reload", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "getAllNames", "", "getDefaultHuds", "", "getAllHuds", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nHudManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudManagerImpl.kt\nkr/toxicity/hud/manager/HudManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1863#2,2:51\n774#2:53\n865#2,2:54\n*S KotlinDebug\n*F\n+ 1 HudManagerImpl.kt\nkr/toxicity/hud/manager/HudManagerImpl\n*L\n33#1:51,2\n40#1:53\n40#1:54,2\n*E\n"})
public final class HudManagerImpl
implements BetterHudManager,
HudManager {
    @NotNull
    public static final HudManagerImpl INSTANCE = new HudManagerImpl();
    @NotNull
    private static final HashMap<String, HudImpl> hudMap = new HashMap();

    private HudManagerImpl() {
    }

    @Override
    public void start() {
    }

    @Override
    @Nullable
    public Hud getHud(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return hudMap.get(name);
    }

    @Override
    public void reload(@NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        hudMap.clear();
        File file = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "huds");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> HudManagerImpl.reload$lambda$2(info, resource, arg_0, arg_1, arg_2));
    }

    @Override
    public void postReload() {
        Collection<HudImpl> collection = hudMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HudImpl it = (HudImpl)element$iv;
            boolean bl = false;
            it.setJsonArray(null);
        }
    }

    @Override
    @NotNull
    public Set<String> getAllNames() {
        Set<String> set = Collections.unmodifiableSet(hudMap.keySet());
        Intrinsics.checkNotNullExpressionValue(set, "unmodifiableSet(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Hud> getDefaultHuds() {
        void $this$filterTo$iv$iv;
        Collection<HudImpl> collection = hudMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            HudImpl it = (HudImpl)element$iv$iv;
            boolean bl = false;
            if (!it.isDefault()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @Override
    @NotNull
    public Set<Hud> getAllHuds() {
        Collection<HudImpl> collection = hudMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    private static final HudImpl reload$lambda$2$lambda$1$lambda$0(String $s, GlobalResource $resource, YamlObject $yamlObject) {
        return new HudImpl($s, $resource, $yamlObject);
    }

    private static final Unit reload$lambda$2$lambda$1(String $s, GlobalResource $resource, YamlObject $yamlObject, HudManagerImpl $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        MapsKt.putSync((Map)hudMap, "hud", () -> HudManagerImpl.reload$lambda$2$lambda$1$lambda$0($s, $resource, $yamlObject));
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$2(ReloadInfo $info, GlobalResource $resource, File file, String s, YamlObject yamlObject) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
        BetterCommandSource betterCommandSource = $info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        FunctionsKt.runWithExceptionHandling(INSTANCE, betterCommandSource, "Unable to load this hud: " + s + " in " + file.getName(), arg_0 -> HudManagerImpl.reload$lambda$2$lambda$1(s, $resource, yamlObject, arg_0));
        return Unit.INSTANCE;
    }
}

