/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.component.WidthComponent;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.element.ImageElement;
import kr.toxicity.hud.image.NamedLoadedImage;
import kr.toxicity.hud.image.enums.ImageType;
import kr.toxicity.hud.layout.HudLayout;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.pack.PackGenerator;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\fJ\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0016R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lkr/toxicity/hud/manager/ImageManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "imageMap", "Ljava/util/HashMap;", "", "Lkr/toxicity/hud/element/ImageElement;", "Lkr/toxicity/hud/shaded/kotlin/collections/HashMap;", "imageNameComponent", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkr/toxicity/hud/layout/HudLayout$Identifier;", "Lkr/toxicity/hud/api/component/WidthComponent;", "allImage", "", "Lkr/toxicity/hud/shaded/kotlin/jvm/internal/EnhancedNullability;", "getAllImage", "()Ljava/util/Collection;", "getImage", "group", "setImage", "", "component", "start", "name", "reload", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nImageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageManager.kt\nkr/toxicity/hud/manager/ImageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1863#2:72\n1663#2,8:73\n1863#2,2:81\n1864#2:83\n*S KotlinDebug\n*F\n+ 1 ImageManager.kt\nkr/toxicity/hud/manager/ImageManager\n*L\n51#1:72\n54#1:73,8\n56#1:81,2\n51#1:83\n*E\n"})
public final class ImageManager
implements BetterHudManager {
    @NotNull
    public static final ImageManager INSTANCE = new ImageManager();
    @NotNull
    private static final HashMap<String, ImageElement> imageMap = new HashMap();
    @NotNull
    private static final ConcurrentHashMap<HudLayout.Identifier, WidthComponent> imageNameComponent = new ConcurrentHashMap();

    private ImageManager() {
    }

    @NotNull
    public final Collection<ImageElement> getAllImage() {
        Collection<ImageElement> collection = imageMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    @Nullable
    public final synchronized WidthComponent getImage(@NotNull HudLayout.Identifier group) {
        Intrinsics.checkNotNullParameter(group, "group");
        return imageNameComponent.get(group);
    }

    public final synchronized void setImage(@NotNull HudLayout.Identifier group, @NotNull WidthComponent component) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(component, "component");
        ((Map)imageNameComponent).put(group, component);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ImageElement getImage(@NotNull String name) {
        ImageElement imageElement;
        Intrinsics.checkNotNullParameter(name, "name");
        HashMap<String, ImageElement> hashMap = imageMap;
        synchronized (hashMap) {
            boolean bl = false;
            imageElement = imageMap.get(name);
        }
        return imageElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        HashMap<String, ImageElement> hashMap = imageMap;
        synchronized (hashMap) {
            boolean $i$a$-synchronized-ImageManager$reload$22 = false;
            imageMap.clear();
            imageNameComponent.clear();
            Unit $i$a$-synchronized-ImageManager$reload$22 = Unit.INSTANCE;
        }
        File assets = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "assets");
        File file = FilesKt.subFolder(PluginsKt.getDATA_FOLDER(), "images");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> ImageManager.reload$lambda$4(info, assets, arg_0, arg_1, arg_2));
        Collection<ImageElement> collection = imageMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            ImageElement value = (ImageElement)element$iv;
            boolean bl = false;
            List<NamedLoadedImage> list = value.getImage();
            if (!(!((Collection)list).isEmpty())) continue;
            Iterable $this$distinctBy$iv = list;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                NamedLoadedImage it = (NamedLoadedImage)e$iv;
                boolean bl2 = false;
                String key$iv = it.getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                NamedLoadedImage it = (NamedLoadedImage)element$iv2;
                boolean bl3 = false;
                PackGenerator.INSTANCE.addTask((Iterable<String>)CollectionsKt.plus((Collection)resource.getTextures(), it.getName()), () -> ImageManager.reload$lambda$8$lambda$7$lambda$6(it));
            }
        }
    }

    @Override
    public void postReload() {
        imageNameComponent.clear();
    }

    @Override
    public void end() {
    }

    @Override
    public void preReload() {
        BetterHudManager.DefaultImpls.preReload(this);
    }

    private static final ImageElement reload$lambda$4$lambda$3$lambda$2(ImageElement $image) {
        return $image;
    }

    private static final Unit reload$lambda$4$lambda$3(YamlObject $yamlObject, File $assets, ReloadInfo $info, File $file, String $s, ImageManager $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        YamlElement yamlElement = $yamlObject.get("type");
        String string = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, "type value not set.").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        ImageType imageType = ImageType.valueOf(string);
        BetterCommandSource betterCommandSource = $info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        ImageElement image = imageType.createElement($assets, betterCommandSource, $file, $s, $yamlObject);
        MapsKt.putSync((Map)imageMap, "image", () -> ImageManager.reload$lambda$4$lambda$3$lambda$2(image));
        return Unit.INSTANCE;
    }

    private static final Unit reload$lambda$4(ReloadInfo $info, File $assets, File file, String s, YamlObject yamlObject) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
        BetterCommandSource betterCommandSource = $info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        FunctionsKt.runWithExceptionHandling(INSTANCE, betterCommandSource, "Unable to load this image: " + s + " in " + file.getName(), arg_0 -> ImageManager.reload$lambda$4$lambda$3(yamlObject, $assets, $info, file, s, arg_0));
        return Unit.INSTANCE;
    }

    private static final byte[] reload$lambda$8$lambda$7$lambda$6(NamedLoadedImage $it) {
        return ImagesKt.toByteArray($it.getImage().getImage());
    }
}

