/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.manager.ConfigManager;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackFile;
import kr.toxicity.hud.pack.PackType;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ListsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/pack/PackGenerator;", "", "<init>", "()V", "tasks", "Ljava/util/TreeMap;", "", "Lkr/toxicity/hud/pack/PackFile;", "generate", "", "", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "addTask", "", "dir", "", "byteArray", "Lkr/toxicity/hud/shaded/kotlin/Function0;", "dist"})
@SourceDebugExtension(value={"SMAP\nPackGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1863#2,2:60\n*S KotlinDebug\n*F\n+ 1 PackGenerator.kt\nkr/toxicity/hud/pack/PackGenerator\n*L\n15#1:60,2\n*E\n"})
public final class PackGenerator {
    @NotNull
    public static final PackGenerator INSTANCE = new PackGenerator();
    @NotNull
    private static final TreeMap<String, PackFile> tasks = new TreeMap();

    private PackGenerator() {
    }

    @NotNull
    public final Map<String, byte[]> generate(@NotNull ReloadInfo info) {
        Map map;
        Intrinsics.checkNotNullParameter(info, "info");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        BetterCommandSource sender = betterCommandSource;
        Map map2 = FunctionsKt.runWithExceptionHandling(this, sender, "Unable to make a resource pack.", arg_0 -> PackGenerator.generate$lambda$8(info, sender, arg_0));
        Throwable throwable = Result.exceptionOrNull-impl(map2);
        if (throwable == null) {
            map = map2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        Map resourcePack = map;
        tasks.clear();
        return resourcePack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTask(@NotNull Iterable<String> dir, @NotNull Function0<byte[]> byteArray) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        String str = CollectionsKt.joinToString$default(dir, "/", null, null, 0, null, null, 62, null);
        TreeMap<String, PackFile> treeMap = tasks;
        synchronized (treeMap) {
            boolean bl = false;
            PackFile packFile = tasks.computeIfAbsent(str, arg_0 -> PackGenerator.addTask$lambda$12$lambda$11(arg_0 -> PackGenerator.addTask$lambda$12$lambda$10(str, byteArray, arg_0), arg_0));
        }
    }

    private static final Unit generate$lambda$8$lambda$4$addFile$lambda$0(PackGenerator $this_runWithExceptionHandling, int $mergeLength, File t) {
        Intrinsics.checkNotNullParameter(t, "t");
        PackGenerator.generate$lambda$8$lambda$4$addFile($this_runWithExceptionHandling, $mergeLength, t);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] generate$lambda$8$lambda$4$addFile$lambda$2(File $target) {
        byte[] byArray;
        Closeable closeable = new FileInputStream($target);
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            byArray = stream.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(byArray, "use(...)");
        return byArray;
    }

    private static final void generate$lambda$8$lambda$4$addFile(PackGenerator $this_runWithExceptionHandling, int mergeLength, File target) {
        if (target.isDirectory()) {
            FilesKt.forEach(target, arg_0 -> PackGenerator.generate$lambda$8$lambda$4$addFile$lambda$0($this_runWithExceptionHandling, mergeLength, arg_0));
        } else {
            String string = target.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            String string2 = string.substring(mergeLength);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            char[] cArray = new char[]{File.separatorChar};
            $this_runWithExceptionHandling.addTask(StringsKt.split$default((CharSequence)string2, cArray, false, 0, 6, null), () -> PackGenerator.generate$lambda$8$lambda$4$addFile$lambda$2(target));
        }
    }

    private static final Unit generate$lambda$8$lambda$4$lambda$3(PackGenerator $this_runWithExceptionHandling, int $mergeLength, File target) {
        Intrinsics.checkNotNullParameter(target, "target");
        PackGenerator.generate$lambda$8$lambda$4$addFile($this_runWithExceptionHandling, $mergeLength, target);
        return Unit.INSTANCE;
    }

    private static final Unit generate$lambda$8$lambda$6$lambda$5(PackType.Generator $saveTask, PackFile $t, PackGenerator $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        Intrinsics.checkNotNull($t);
        $saveTask.invoke($t);
        String[] stringArray = new String[]{"Pack file " + $t.getPath() + " is generated."};
        PluginsKt.debug(ConfigManager.DebugLevel.FILE, stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit generate$lambda$8$lambda$6(PackGenerator $this_runWithExceptionHandling, BetterCommandSource $sender, PackType.Generator $saveTask, PackFile t) {
        Intrinsics.checkNotNullParameter(t, "t");
        FunctionsKt.runWithExceptionHandling($this_runWithExceptionHandling, $sender, "Unable to save this file: " + t.getPath(), arg_0 -> PackGenerator.generate$lambda$8$lambda$6$lambda$5($saveTask, t, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit generate$lambda$8$lambda$7(PackType.Generator $saveTask, PackGenerator $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        $saveTask.close();
        return Unit.INSTANCE;
    }

    private static final Map generate$lambda$8(ReloadInfo $info, BetterCommandSource $sender, PackGenerator $this$runWithExceptionHandling) {
        Intrinsics.checkNotNullParameter($this$runWithExceptionHandling, "$this$runWithExceptionHandling");
        Iterable $this$forEach$iv = ConfigManagerImpl.INSTANCE.getMergeOtherFolders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            File file = PluginsKt.getDATA_FOLDER().getParentFile();
            Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
            File mergeTarget = FilesKt.subFolder(file, it);
            int mergeLength = mergeTarget.getPath().length() + 1;
            FilesKt.forEach(mergeTarget, arg_0 -> PackGenerator.generate$lambda$8$lambda$4$lambda$3($this$runWithExceptionHandling, mergeLength, arg_0));
        }
        PackType.Generator saveTask = ConfigManagerImpl.INSTANCE.getPackType().createGenerator($info);
        Collection<PackFile> collection = tasks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        ListsKt.forEachAsync(collection, arg_0 -> PackGenerator.generate$lambda$8$lambda$6($this$runWithExceptionHandling, $sender, saveTask, arg_0));
        FunctionsKt.runWithExceptionHandling($this$runWithExceptionHandling, $sender, "Unable to finalized resource pack build.", arg_0 -> PackGenerator.generate$lambda$8$lambda$7(saveTask, arg_0));
        return saveTask.getResourcePack();
    }

    private static final PackFile addTask$lambda$12$lambda$10(String $str, Function0 $byteArray, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new PackFile($str, $byteArray);
    }

    private static final PackFile addTask$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        return (PackFile)$tmp0.invoke(p0);
    }
}

