/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import com.google.gson.JsonElement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.plugin.ReloadFlagType;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackFile;
import kr.toxicity.hud.pack.PackUUID;
import kr.toxicity.hud.pack.PackUploader;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Pair;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.TuplesKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntries;
import kr.toxicity.hud.shaded.kotlin.enums.EnumEntriesKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.text.StringsKt;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import kr.toxicity.hud.util.SendersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0003\u000b\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u000e"}, d2={"Lkr/toxicity/hud/pack/PackType;", "", "<init>", "(Ljava/lang/String;I)V", "FOLDER", "ZIP", "NONE", "createGenerator", "Lkr/toxicity/hud/pack/PackType$Generator;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "Companion", "Builder", "Generator", "dist"})
public abstract class PackType
extends Enum<PackType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final DecimalFormat decimal;
    public static final /* enum */ PackType FOLDER;
    public static final /* enum */ PackType ZIP;
    public static final /* enum */ PackType NONE;
    private static final /* synthetic */ PackType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PackType() {
    }

    @NotNull
    public abstract Generator createGenerator(@NotNull ReloadInfo var1);

    public static PackType[] values() {
        return (PackType[])$VALUES.clone();
    }

    public static PackType valueOf(String value) {
        return Enum.valueOf(PackType.class, value);
    }

    @NotNull
    public static EnumEntries<PackType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ PackType(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        FOLDER = new FOLDER("FOLDER", 0);
        ZIP = new ZIP("ZIP", 1);
        NONE = new NONE("NONE", 2);
        $VALUES = packTypeArray = new PackType[]{PackType.FOLDER, PackType.ZIP, PackType.NONE};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        decimal = new DecimalFormat("#,###.###");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/hud/pack/PackType$Builder;", "", "<init>", "()V", "byte", "", "getByte", "()J", "setByte", "(J)V", "byteArrayMap", "Ljava/util/HashMap;", "", "", "getByteArrayMap", "()Ljava/util/HashMap;", "dist"})
    private static class Builder {
        private volatile long byte;
        @NotNull
        private final HashMap<String, byte[]> byteArrayMap = new HashMap();

        public final long getByte() {
            return this.byte;
        }

        public final void setByte(long l) {
            this.byte = l;
        }

        @NotNull
        public final HashMap<String, byte[]> getByteArrayMap() {
            return this.byteArrayMap;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lkr/toxicity/hud/pack/PackType$Companion;", "", "<init>", "()V", "decimal", "Ljava/text/DecimalFormat;", "mbFormat", "", "long", "", "dist"})
    public static final class Companion {
        private Companion() {
        }

        private final String mbFormat(long l) {
            DecimalFormat decimalFormat = decimal;
            BigDecimal bigDecimal = new BigDecimal(l + ".000").divide(new BigDecimal("1048576.000"), RoundingMode.HALF_EVEN);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "divide(...)");
            return decimalFormat.format(bigDecimal) + "MB";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001:\u0001\bJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"kr/toxicity/hud/pack/PackType.FOLDER", "Lkr/toxicity/hud/pack/PackType;", "beforeByte", "", "createGenerator", "Lkr/toxicity/hud/pack/PackType$Generator;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "FileTreeBuilder", "dist"})
    static final class FOLDER
    extends PackType {
        private volatile long beforeByte;

        /*
         * WARNING - void declaration
         */
        FOLDER() {
            void var1_1;
        }

        @Override
        @NotNull
        public Generator createGenerator(@NotNull ReloadInfo info) {
            Intrinsics.checkNotNullParameter(info, "info");
            File file = PluginsKt.getDATA_FOLDER().getParentFile();
            Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
            File build2 = FilesKt.subFolder(file, ConfigManagerImpl.INSTANCE.getBuildFolderLocation());
            int pathLength = build2.getPath().length() + 1;
            FileTreeBuilder builder = new FileTreeBuilder(build2);
            FilesKt.forEach(build2, arg_0 -> FOLDER.createGenerator$lambda$2(pathLength, builder, info, arg_0));
            return new Generator(builder){
                final /* synthetic */ FileTreeBuilder $builder;
                {
                    this.$builder = $builder;
                }

                public Map<String, byte[]> getResourcePack() {
                    Map<String, byte[]> map = Collections.unmodifiableMap((Map)this.$builder.getByteArrayMap());
                    Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(...)");
                    return map;
                }

                public void close() {
                    if (PackUploader.INSTANCE.stop()) {
                        String[] stringArray = new String[]{"Resource pack host is stopped."};
                        PluginsKt.info(stringArray);
                    }
                    this.$builder.close();
                }

                public void invoke(PackFile p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    this.$builder.save(p1);
                }
            };
        }

        private static final Unit createGenerator$getAllLocation$lambda$1(int $length, FileTreeBuilder $builder, ReloadInfo $info, File it) {
            Intrinsics.checkNotNullParameter(it, "it");
            kr.toxicity.hud.pack.PackType$FOLDER.createGenerator$getAllLocation($builder, $info, it, $length);
            return Unit.INSTANCE;
        }

        private static final void createGenerator$getAllLocation(FileTreeBuilder builder, ReloadInfo $info, File file, int length) {
            TreeMap<String, File> treeMap = builder.getLocationMap();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
            String string2 = string.substring(length);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            File file2 = treeMap.put(string2, file);
            if (file2 != null) {
                File it = file2;
                boolean bl = false;
                BetterCommandSource betterCommandSource = $info.sender();
                Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
                SendersKt.warn(betterCommandSource, "Duplicated file skipped: " + file.getPath() + " and " + it.getPath());
            }
            FilesKt.forEach(file, arg_0 -> FOLDER.createGenerator$getAllLocation$lambda$1(length, builder, $info, arg_0));
        }

        private static final Unit createGenerator$lambda$2(int $pathLength, FileTreeBuilder $builder, ReloadInfo $info, File it) {
            Intrinsics.checkNotNullParameter(it, "it");
            kr.toxicity.hud.pack.PackType$FOLDER.createGenerator$getAllLocation($builder, $info, it, $pathLength);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u008a\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"kr/toxicity/hud/pack/PackType.FOLDER.FileTreeBuilder", "Lkr/toxicity/hud/pack/PackType$Builder;", "build", "Ljava/io/File;", "<init>", "(Lkr/toxicity/hud/pack/PackType$FOLDER;Ljava/io/File;)V", "locationMap", "Ljava/util/TreeMap;", "", "getLocationMap", "()Ljava/util/TreeMap;", "save", "", "packFile", "Lkr/toxicity/hud/pack/PackFile;", "close", "dist"})
        public final class FileTreeBuilder
        extends Builder {
            private final File build;
            private final TreeMap<String, File> locationMap;

            public FileTreeBuilder(File build2) {
                Intrinsics.checkNotNullParameter(build2, "build");
                this.build = build2;
                this.locationMap = new TreeMap(Comparator.reverseOrder());
            }

            public final TreeMap<String, File> getLocationMap() {
                return this.locationMap;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void save(PackFile packFile) {
                File file;
                Object object;
                Intrinsics.checkNotNullParameter(packFile, "packFile");
                String replace = StringsKt.replace$default(packFile.getPath(), '/', File.separatorChar, false, 4, null);
                byte[] arr = packFile.invoke();
                Object object2 = this;
                synchronized (object2) {
                    boolean bl = false;
                    this.setByte(this.getByte() + (long)arr.length);
                    ((Map)this.getByteArrayMap()).put(packFile.getPath(), arr);
                    object = Unit.INSTANCE;
                }
                Object object3 = this.locationMap;
                synchronized (object3) {
                    boolean $i$a$-synchronized-PackType$FOLDER$FileTreeBuilder$save$32 = false;
                    File $i$a$-synchronized-PackType$FOLDER$FileTreeBuilder$save$32 = this.locationMap.remove(replace);
                    // MONITOREXIT @DISABLED, blocks:[1, 5] lbl25 : MonitorExitStatement: MONITOREXIT : var6_10
                    file = $i$a$-synchronized-PackType$FOLDER$FileTreeBuilder$save$32;
                }
                Object object4 = file;
                if (file == null) {
                    Object $this$save_u24lambda_u242 = object = new File(this.build, replace);
                    boolean bl = false;
                    ((File)$this$save_u24lambda_u242).getParentFile().mkdirs();
                    object4 = object;
                }
                object2 = object4;
                object2 = new FileOutputStream((File)object2);
                int n = 8192;
                object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
                Throwable throwable = null;
                try {
                    BufferedOutputStream stream = (BufferedOutputStream)object2;
                    boolean bl = false;
                    stream.write(arr);
                    object3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void close() {
                FOLDER fOLDER = FOLDER.this;
                FileTreeBuilder fileTreeBuilder = this;
                synchronized (fileTreeBuilder) {
                    boolean bl = false;
                    if (ConfigManagerImpl.INSTANCE.getClearBuildFolder()) {
                        Iterator<File> iterator2 = this.locationMap.values().iterator();
                        while (iterator2.hasNext()) {
                            File next;
                            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                            File[] fileArray = next.listFiles();
                            if (fileArray != null ? !(fileArray.length == 0) : false) continue;
                            next.delete();
                        }
                    }
                    String[] stringArray = new String[]{"File packed: " + (String)(fOLDER.beforeByte > 0L ? Companion.mbFormat(fOLDER.beforeByte) + " -> " + Companion.mbFormat(this.getByte()) : Companion.mbFormat(this.getByte()))};
                    PluginsKt.info(stringArray);
                    if (fOLDER.beforeByte != this.getByte()) {
                        fOLDER.beforeByte = this.getByte();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00060\u0004j\u0002`\u0005R\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lkr/toxicity/hud/pack/PackType$Generator;", "Lkr/toxicity/hud/shaded/kotlin/Function1;", "Lkr/toxicity/hud/pack/PackFile;", "", "Ljava/lang/AutoCloseable;", "Lkr/toxicity/hud/shaded/kotlin/AutoCloseable;", "resourcePack", "", "", "", "getResourcePack", "()Ljava/util/Map;", "dist"})
    public static interface Generator
    extends Function1<PackFile, Unit>,
    AutoCloseable {
        @NotNull
        public Map<String, byte[]> getResourcePack();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"kr/toxicity/hud/pack/PackType.NONE", "Lkr/toxicity/hud/pack/PackType;", "createGenerator", "Lkr/toxicity/hud/pack/PackType$Generator;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "dist"})
    static final class NONE
    extends PackType {
        /*
         * WARNING - void declaration
         */
        NONE() {
            void var1_1;
        }

        @Override
        @NotNull
        public Generator createGenerator(@NotNull ReloadInfo info) {
            Intrinsics.checkNotNullParameter(info, "info");
            Builder builder = new Builder();
            return new Generator(builder){
                final /* synthetic */ Builder $builder;
                {
                    this.$builder = $builder;
                }

                public Map<String, byte[]> getResourcePack() {
                    Map<String, byte[]> map = Collections.unmodifiableMap((Map)this.$builder.getByteArrayMap());
                    Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(...)");
                    return map;
                }

                public void close() {
                    if (PackUploader.INSTANCE.stop()) {
                        String[] stringArray = new String[]{"Resource pack host is stopped."};
                        PluginsKt.info(stringArray);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void invoke(PackFile p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    byte[] byArray = p1.invoke();
                    Builder builder = this.$builder;
                    Builder builder2 = this.$builder;
                    Builder builder3 = builder;
                    synchronized (builder3) {
                        boolean bl = false;
                        builder2.setByte(builder2.getByte() + (long)byArray.length);
                        ((Map)builder2.getByteArrayMap()).put(p1.getPath(), byArray);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            };
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001:\u0001\bJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"kr/toxicity/hud/pack/PackType.ZIP", "Lkr/toxicity/hud/pack/PackType;", "beforeByte", "", "createGenerator", "Lkr/toxicity/hud/pack/PackType$Generator;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "ZipBuilder", "dist"})
    static final class ZIP
    extends PackType {
        private volatile long beforeByte;

        /*
         * WARNING - void declaration
         */
        ZIP() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Generator createGenerator(@NotNull ReloadInfo info) {
            void $this$createGenerator_u24lambda_u241;
            Object $this$createGenerator_u24lambda_u240;
            Intrinsics.checkNotNullParameter(info, "info");
            boolean protection = ConfigManagerImpl.INSTANCE.getEnableProtection();
            boolean host = ConfigManagerImpl.INSTANCE.getEnableSelfHost();
            ZIP zIP = this;
            try {
                $this$createGenerator_u24lambda_u240 = zIP;
                boolean bl = false;
                $this$createGenerator_u24lambda_u240 = Result.constructor-impl(MessageDigest.getInstance("SHA-1"));
            }
            catch (Throwable bl) {
                $this$createGenerator_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            zIP = $this$createGenerator_u24lambda_u240;
            MessageDigest message = (MessageDigest)((Object)(Result.isFailure-impl((Object)zIP) ? null : zIP));
            File file = new File(PluginsKt.getDATA_FOLDER().getParentFile(), ConfigManagerImpl.INSTANCE.getBuildFolderLocation() + ".zip");
            this.beforeByte = file.length();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Pair[] pairArray = (Pair[])stream;
            int n = 8192;
            Pair[] pairArray2 = pairArray = new ZipOutputStream(pairArray instanceof BufferedOutputStream ? (BufferedOutputStream)pairArray : new BufferedOutputStream((OutputStream)pairArray, n));
            ZIP zIP2 = this;
            boolean bl = false;
            $this$createGenerator_u24lambda_u241.setComment("BetterHud resource pack.");
            $this$createGenerator_u24lambda_u241.setLevel(9);
            Pair[] pairArray3 = pairArray;
            ZIP zIP3 = zIP2;
            ZipBuilder zip = zIP3.new ZipBuilder((ZipOutputStream)pairArray3);
            if (host) {
                InputStream inputStream = PluginsKt.getBOOTSTRAP().resource("icon.png");
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    int n2 = 8192;
                    closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n2);
                    Throwable throwable = null;
                    try {
                        BufferedInputStream it = (BufferedInputStream)closeable;
                        boolean bl2 = false;
                        ZipEntry zipEntry = new ZipEntry("pack.png");
                        byte[] byArray = it.readAllBytes();
                        Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                        kr.toxicity.hud.pack.PackType$ZIP.createGenerator$addEntry(zip, this, info, protection, zipEntry, byArray);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                }
                pairArray = new Pair[1];
                pairArray2 = new Pair[]{TuplesKt.to("pack_format", PluginsKt.getBOOTSTRAP().mcmetaVersion()), TuplesKt.to("description", "BetterHud's self-host pack.")};
                pairArray[0] = TuplesKt.to("pack", GsonsKt.jsonObjectOf(pairArray2));
                kr.toxicity.hud.pack.PackType$ZIP.createGenerator$addEntry(zip, this, info, protection, new ZipEntry("pack.mcmeta"), GsonsKt.toByteArray((JsonElement)GsonsKt.jsonObjectOf(pairArray)));
            }
            return new Generator(zip, stream, this, message, info, file, host, protection){
                final /* synthetic */ ZipBuilder $zip;
                final /* synthetic */ ByteArrayOutputStream $stream;
                final /* synthetic */ ZIP this$0;
                final /* synthetic */ MessageDigest $message;
                final /* synthetic */ ReloadInfo $info;
                final /* synthetic */ File $file;
                final /* synthetic */ boolean $host;
                final /* synthetic */ boolean $protection;
                {
                    this.$zip = $zip;
                    this.$stream = $stream;
                    this.this$0 = $receiver;
                    this.$message = $message;
                    this.$info = $info;
                    this.$file = $file;
                    this.$host = $host;
                    this.$protection = $protection;
                }

                public Map<String, byte[]> getResourcePack() {
                    Map<String, byte[]> map = Collections.unmodifiableMap((Map)this.$zip.getByteArrayMap());
                    Intrinsics.checkNotNullExpressionValue(map, "unmodifiableMap(...)");
                    return map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    ZipBuilder zipBuilder = this.$zip;
                    ZipBuilder zipBuilder2 = this.$zip;
                    ByteArrayOutputStream byteArrayOutputStream = this.$stream;
                    ZIP zIP = this.this$0;
                    MessageDigest messageDigest = this.$message;
                    ReloadInfo reloadInfo = this.$info;
                    File file = this.$file;
                    boolean bl = this.$host;
                    ZipBuilder zipBuilder3 = zipBuilder;
                    synchronized (zipBuilder3) {
                        Object object;
                        boolean bl2 = false;
                        zipBuilder2.getZip().close();
                        byte[] finalByte = byteArrayOutputStream.toByteArray();
                        String[] stringArray = new String[]{"File packed: " + (String)(kr.toxicity.hud.pack.PackType$ZIP.access$getBeforeByte$p(zIP) > 0L ? kr.toxicity.hud.pack.PackType$Companion.access$mbFormat(PackType.Companion, kr.toxicity.hud.pack.PackType$ZIP.access$getBeforeByte$p(zIP)) + " -> " + kr.toxicity.hud.pack.PackType$Companion.access$mbFormat(PackType.Companion, finalByte.length) : kr.toxicity.hud.pack.PackType$Companion.access$mbFormat(PackType.Companion, finalByte.length))};
                        PluginsKt.info(stringArray);
                        if (messageDigest == null) {
                            stringArray = new String[]{"Unable to find SHA-1 algorithm, skipped."};
                            PluginsKt.warn(stringArray);
                            return;
                        }
                        PackUUID previousUUID = PackUUID.Companion.getPrevious();
                        if (previousUUID == null || ConfigManagerImpl.INSTANCE.getForceUpdate() || kr.toxicity.hud.pack.PackType$ZIP.access$getBeforeByte$p(zIP) != (long)finalByte.length || reloadInfo.has(ReloadFlagType.FORCE_GENERATE_RESOURCE_PACK)) {
                            kr.toxicity.hud.pack.PackType$ZIP.access$setBeforeByte$p(zIP, finalByte.length);
                            String[] stringArray2 = new DigestOutputStream(new FileOutputStream(file), messageDigest);
                            int n = 8192;
                            stringArray2 = stringArray2 instanceof BufferedOutputStream ? (BufferedOutputStream)stringArray2 : new BufferedOutputStream((OutputStream)stringArray2, n);
                            object = null;
                            try {
                                BufferedOutputStream it = (BufferedOutputStream)stringArray2;
                                boolean bl3 = false;
                                it.write(finalByte);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable bl3) {
                                object = bl3;
                                throw bl3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)stringArray2, (Throwable)object);
                            }
                            previousUUID = PackUUID.Companion.from(messageDigest);
                            stringArray2 = new String[]{"File zipped: " + kr.toxicity.hud.pack.PackType$Companion.access$mbFormat(PackType.Companion, file.length())};
                            PluginsKt.info(stringArray2);
                        }
                        if (bl) {
                            byte[] byArray;
                            object = new FileInputStream(file);
                            int n = 8192;
                            object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                            PackUUID packUUID = previousUUID;
                            PackUploader packUploader = PackUploader.INSTANCE;
                            Throwable throwable = null;
                            try {
                                BufferedInputStream it = (BufferedInputStream)object;
                                boolean bl4 = false;
                                byArray = it.readAllBytes();
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, throwable);
                            }
                            byte[] byArray2 = byArray;
                            Intrinsics.checkNotNullExpressionValue(byArray2, "use(...)");
                            packUploader.upload(packUUID, byArray2);
                        } else {
                            previousUUID.save();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }

                public void invoke(PackFile p1) {
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ZipEntry entry = new ZipEntry(p1.getPath());
                    byte[] byArray = p1.invoke();
                    kr.toxicity.hud.pack.PackType$ZIP.access$createGenerator$addEntry(this.$zip, this.this$0, this.$info, this.$protection, entry, byArray);
                }
            };
        }

        private static final Unit createGenerator$addEntry$lambda$3$lambda$2(ZipBuilder $zip, ZipEntry $entry, byte[] $byte, boolean $protection, ZIP $this$runWithExceptionHandling) {
            Intrinsics.checkNotNullParameter((Object)$this$runWithExceptionHandling, "$this$runWithExceptionHandling");
            ((Map)$zip.getByteArrayMap()).put($entry.getName(), $byte);
            $zip.getZip().putNextEntry($entry);
            $zip.getZip().write($byte);
            $zip.getZip().closeEntry();
            if ($protection) {
                $entry.setCrc($byte.length);
                $entry.setSize(new BigInteger($byte).mod(BigInteger.valueOf(Long.MAX_VALUE)).longValue());
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void createGenerator$addEntry(ZipBuilder zip, ZIP this$0, ReloadInfo $info, boolean protection, ZipEntry entry, byte[] byArray) {
            ZipBuilder zipBuilder = zip;
            synchronized (zipBuilder) {
                boolean bl = false;
                BetterCommandSource betterCommandSource = $info.sender();
                Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
                Object object = FunctionsKt.runWithExceptionHandling(this$0, betterCommandSource, "Unable to write this file: " + entry.getName(), arg_0 -> ZIP.createGenerator$addEntry$lambda$3$lambda$2(zip, entry, byArray, protection, arg_0));
            }
        }

        public static final /* synthetic */ void access$createGenerator$addEntry(ZipBuilder zip, ZIP this$0, ReloadInfo $info, boolean protection, ZipEntry entry, byte[] byArray) {
            kr.toxicity.hud.pack.PackType$ZIP.createGenerator$addEntry(zip, this$0, $info, protection, entry, byArray);
        }

        public static final /* synthetic */ long access$getBeforeByte$p(ZIP $this) {
            return $this.beforeByte;
        }

        public static final /* synthetic */ void access$setBeforeByte$p(ZIP $this, long l) {
            $this.beforeByte = l;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0000\b\u008a\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"kr/toxicity/hud/pack/PackType.ZIP.ZipBuilder", "Lkr/toxicity/hud/pack/PackType$Builder;", "zip", "Ljava/util/zip/ZipOutputStream;", "<init>", "(Lkr/toxicity/hud/pack/PackType$ZIP;Ljava/util/zip/ZipOutputStream;)V", "getZip", "()Ljava/util/zip/ZipOutputStream;", "dist"})
        public final class ZipBuilder
        extends Builder {
            private final ZipOutputStream zip;

            public ZipBuilder(ZipOutputStream zip) {
                Intrinsics.checkNotNullParameter(zip, "zip");
                this.zip = zip;
            }

            public final ZipOutputStream getZip() {
                return this.zip;
            }
        }
    }
}

