/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.player.head;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kr.toxicity.hud.api.player.HudPlayerHead;
import kr.toxicity.hud.manager.PlayerHeadManager;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.IntIterator;
import kr.toxicity.hud.shaded.kotlin.collections.MapsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.ranges.IntRange;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.shaded.kotlin.text.Charsets;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.PluginsKt;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fB\u0019\b\u0012\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u000fB\u0011\b\u0012\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\b\u0010\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkr/toxicity/hud/player/head/HudPlayerHeadImpl;", "Lkr/toxicity/hud/api/player/HudPlayerHead;", "colorList", "", "Lnet/kyori/adventure/text/format/TextColor;", "hairMap", "", "", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "main", "hair", "(Ljava/awt/image/BufferedImage;Ljava/awt/image/BufferedImage;)V", "playerName", "", "(Ljava/lang/String;)V", "flatHead", "mainHead", "hairHead", "Companion", "dist"})
@SourceDebugExtension(value={"SMAP\nHudPlayerHeadImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HudPlayerHeadImpl.kt\nkr/toxicity/hud/player/head/HudPlayerHeadImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1557#2:77\n1628#2,3:78\n1557#2:81\n1628#2,3:82\n1279#2,2:85\n1293#2,4:87\n1557#2:91\n1628#2,3:92\n*S KotlinDebug\n*F\n+ 1 HudPlayerHeadImpl.kt\nkr/toxicity/hud/player/head/HudPlayerHeadImpl\n*L\n54#1:77\n54#1:78,3\n25#1:81\n25#1:82,3\n28#1:85,2\n28#1:87,4\n59#1:91\n59#1:92,3\n*E\n"})
public final class HudPlayerHeadImpl
implements HudPlayerHead {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<TextColor> colorList;
    @NotNull
    private final Map<Integer, TextColor> hairMap;
    @NotNull
    private final List<TextColor> flatHead;
    @NotNull
    private static final HudPlayerHeadImpl allBlack;

    /*
     * WARNING - void declaration
     */
    public HudPlayerHeadImpl(@NotNull List<? extends TextColor> colorList, @NotNull Map<Integer, ? extends TextColor> hairMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(colorList, "colorList");
        Intrinsics.checkNotNullParameter(hairMap, "hairMap");
        this.colorList = colorList;
        this.hairMap = hairMap;
        Iterable iterable = new IntRange(0, 63);
        HudPlayerHeadImpl hudPlayerHeadImpl = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TextColor textColor = this.hairMap.get((int)it);
            if (textColor == null) {
                textColor = this.colorList.get((int)it);
            }
            collection.add(textColor);
        }
        hudPlayerHeadImpl.flatHead = (List)destination$iv$iv;
    }

    private HudPlayerHeadImpl(BufferedImage image) {
        BufferedImage bufferedImage = image.getSubimage(8, 8, 8, 8);
        Intrinsics.checkNotNullExpressionValue(bufferedImage, "getSubimage(...)");
        BufferedImage bufferedImage2 = image.getSubimage(40, 8, 8, 8);
        Intrinsics.checkNotNullExpressionValue(bufferedImage2, "getSubimage(...)");
        this(bufferedImage, bufferedImage2);
    }

    /*
     * WARNING - void declaration
     */
    private HudPlayerHeadImpl(BufferedImage main, BufferedImage hair) {
        Map map;
        void $this$associateWith$iv;
        int i;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = new IntRange(0, 63);
        HudPlayerHeadImpl hudPlayerHeadImpl = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            TextColor textColor = TextColor.color((int)main.getRGB((int)(i % 8), (int)(i / 8)));
            Intrinsics.checkNotNullExpressionValue(textColor, "color(...)");
            collection.add(textColor);
        }
        $this$map$iv = new IntRange(0, 63);
        collection = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            i = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            int rgb = hair.getRGB(i % 8, i / 8);
            TextColor textColor = rgb >>> 24 > 0 ? TextColor.color((int)rgb) : null;
            map.put(t, textColor);
        }
        map = result$iv;
        hudPlayerHeadImpl((List<? extends TextColor>)collection, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HudPlayerHeadImpl(String playerName) {
        BufferedImage bufferedImage;
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        byte[] byArray = Base64.getDecoder().decode(PlayerHeadManager.INSTANCE.provideSkin(playerName));
        Intrinsics.checkNotNullExpressionValue(byArray, "decode(...)");
        byte[] byArray2 = byArray;
        Closeable closeable = httpClient.send(builder.uri(URI.create(GsonsKt.parseJson(new String(byArray2, Charsets.UTF_8)).getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").getAsJsonPrimitive("url").getAsString())).GET().build(), HttpResponse.BodyHandlers.ofInputStream()).body();
        Intrinsics.checkNotNullExpressionValue(closeable, "body(...)");
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        HudPlayerHeadImpl hudPlayerHeadImpl = this;
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            bufferedImage = ImagesKt.toImage(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        hudPlayerHeadImpl(bufferedImage);
    }

    @Override
    @NotNull
    public List<TextColor> flatHead() {
        return this.flatHead;
    }

    @Override
    @NotNull
    public List<TextColor> mainHead() {
        return this.colorList;
    }

    @Override
    @NotNull
    public Map<Integer, TextColor> hairHead() {
        return this.hairMap;
    }

    public /* synthetic */ HudPlayerHeadImpl(String playerName, DefaultConstructorMarker $constructor_marker) {
        this(playerName);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = new IntRange(0, 63);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NamedTextColor.BLACK);
        }
        Map map = MapsKt.emptyMap();
        List list = (List)var3_3;
        allBlack = new HudPlayerHeadImpl(list, map);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lkr/toxicity/hud/player/head/HudPlayerHeadImpl$Companion;", "", "<init>", "()V", "allBlack", "Lkr/toxicity/hud/player/head/HudPlayerHeadImpl;", "getAllBlack", "()Lkr/toxicity/hud/player/head/HudPlayerHeadImpl;", "of", "playerName", "", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HudPlayerHeadImpl getAllBlack() {
            return allBlack;
        }

        @NotNull
        public final HudPlayerHeadImpl of(@NotNull String playerName) {
            Object object;
            Object $this$of_u24lambda_u240;
            Intrinsics.checkNotNullParameter(playerName, "playerName");
            Object object2 = this;
            try {
                $this$of_u24lambda_u240 = object2;
                boolean bl = false;
                $this$of_u24lambda_u240 = Result.constructor-impl(new HudPlayerHeadImpl(playerName, null));
            }
            catch (Throwable bl) {
                $this$of_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = $this$of_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) {
                object = object2;
            } else {
                Throwable e = throwable;
                boolean bl = false;
                String[] stringArray = new String[]{"Unable to get " + playerName + "'s head.", "Reason: " + e.getMessage()};
                PluginsKt.warn(stringArray);
                object = Companion.getAllBlack();
            }
            return (HudPlayerHeadImpl)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

