/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.animation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kr.toxicity.hud.animation.AnimationType;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.equation.EquationTriple;
import kr.toxicity.hud.location.PixelLocation;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.collections.IntIterator;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0007\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lkr/toxicity/hud/animation/AnimationLocation;", "", "type", "Lkr/toxicity/hud/animation/AnimationType;", "location", "", "Lkr/toxicity/hud/location/PixelLocation;", "<init>", "(Lkr/toxicity/hud/animation/AnimationType;Ljava/util/List;)V", "duration", "", "imageEquation", "Lkr/toxicity/hud/equation/EquationTriple;", "(Lkr/toxicity/hud/animation/AnimationType;ILkr/toxicity/hud/equation/EquationTriple;)V", "section", "Lkr/toxicity/hud/api/yaml/YamlObject;", "(Lkr/toxicity/hud/api/yaml/YamlObject;)V", "getType", "()Lkr/toxicity/hud/animation/AnimationType;", "getLocation", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "dist"})
@SourceDebugExtension(value={"SMAP\nAnimationLocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationLocation.kt\nkr/toxicity/hud/animation/AnimationLocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1563#2:37\n1634#2,3:38\n*S KotlinDebug\n*F\n+ 1 AnimationLocation.kt\nkr/toxicity/hud/animation/AnimationLocation\n*L\n21#1:37\n21#1:38,3\n*E\n"})
public final class AnimationLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimationType type;
    @NotNull
    private final List<PixelLocation> location;
    @NotNull
    private static final AnimationLocation zero = new AnimationLocation(AnimationType.LOOP, CollectionsKt.listOf(PixelLocation.Companion.getZero()));

    public AnimationLocation(@NotNull AnimationType type, @NotNull List<PixelLocation> location) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(location, "location");
        this.type = type;
        this.location = location;
    }

    @NotNull
    public final AnimationType getType() {
        return this.type;
    }

    @NotNull
    public final List<PixelLocation> getLocation() {
        return this.location;
    }

    /*
     * WARNING - void declaration
     */
    public AnimationLocation(@NotNull AnimationType type, int duration, @NotNull EquationTriple imageEquation) {
        Collection<PixelLocation> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(imageEquation, "imageEquation");
        Iterable iterable = RangesKt.until(0, duration);
        AnimationType animationType = type;
        AnimationLocation animationLocation = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            double d = (double)it;
            collection.add(new PixelLocation(imageEquation.getX().evaluateToInt(d), imageEquation.getY().evaluateToInt(d), imageEquation.getOpacity().evaluate(d)));
        }
        collection = (List)destination$iv$iv;
        animationLocation(animationType, (List<PixelLocation>)collection);
    }

    public AnimationLocation(@NotNull YamlObject section) {
        Intrinsics.checkNotNullParameter(section, "section");
        this(YamlsKt.getAsAnimationType$default(section, "type", null, 2, null), RangesKt.coerceAtLeast(section.getAsInt("duration", 20), 1), new EquationTriple(section));
    }

    @NotNull
    public final AnimationType component1() {
        return this.type;
    }

    @NotNull
    public final List<PixelLocation> component2() {
        return this.location;
    }

    @NotNull
    public final AnimationLocation copy(@NotNull AnimationType type, @NotNull List<PixelLocation> location) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(location, "location");
        return new AnimationLocation(type, location);
    }

    public static /* synthetic */ AnimationLocation copy$default(AnimationLocation animationLocation, AnimationType animationType, List list, int n, Object object) {
        if ((n & 1) != 0) {
            animationType = animationLocation.type;
        }
        if ((n & 2) != 0) {
            list = animationLocation.location;
        }
        return animationLocation.copy(animationType, list);
    }

    @NotNull
    public String toString() {
        return "AnimationLocation(type=" + this.type + ", location=" + this.location + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + ((Object)this.location).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnimationLocation)) {
            return false;
        }
        AnimationLocation animationLocation = (AnimationLocation)other;
        if (this.type != animationLocation.type) {
            return false;
        }
        return Intrinsics.areEqual(this.location, animationLocation.location);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkr/toxicity/hud/animation/AnimationLocation$Companion;", "", "<init>", "()V", "zero", "Lkr/toxicity/hud/animation/AnimationLocation;", "getZero", "()Lkr/toxicity/hud/animation/AnimationLocation;", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnimationLocation getZero() {
            return zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

