/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import kr.toxicity.hud.shaded.kotlin.Lazy;
import kr.toxicity.hud.shaded.kotlin.LazyKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.shaded.kotlin.text.Charsets;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lkr/toxicity/hud/pack/PackMeta;", "", "pack", "Lkr/toxicity/hud/pack/PackMeta$Pack;", "overlays", "Lkr/toxicity/hud/pack/PackMeta$Overlay;", "<init>", "(Lkr/toxicity/hud/pack/PackMeta$Pack;Lkr/toxicity/hud/pack/PackMeta$Overlay;)V", "getPack", "()Lkr/toxicity/hud/pack/PackMeta$Pack;", "getOverlays", "()Lkr/toxicity/hud/pack/PackMeta$Overlay;", "plus", "other", "toByteArray", "", "component1", "component2", "copy", "equals", "", "hashCode", "", "toString", "", "Companion", "Pack", "Overlay", "OverlayEntry", "VersionRange", "dist"})
public final class PackMeta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pack pack;
    @NotNull
    private final Overlay overlays;
    @NotNull
    private static final Lazy<PackMeta> default$delegate = LazyKt.lazy(PackMeta::default_delegate$lambda$0);
    @NotNull
    private static final ZipEntry zipEntry = new ZipEntry("pack.mcmeta");

    public PackMeta(@NotNull Pack pack, @NotNull Overlay overlays) {
        Intrinsics.checkNotNullParameter(pack, "pack");
        Intrinsics.checkNotNullParameter(overlays, "overlays");
        this.pack = pack;
        this.overlays = overlays;
    }

    public /* synthetic */ PackMeta(Pack pack, Overlay overlay, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            overlay = new Overlay(null, 1, null);
        }
        this(pack, overlay);
    }

    @NotNull
    public final Pack getPack() {
        return this.pack;
    }

    @NotNull
    public final Overlay getOverlays() {
        return this.overlays;
    }

    @NotNull
    public final PackMeta plus(@NotNull PackMeta other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return new PackMeta(this.pack.plus(other.pack), this.overlays.plus(other.overlays));
    }

    @NotNull
    public final byte[] toByteArray() {
        String string = GsonsKt.getGSON().toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return byArray;
    }

    @NotNull
    public final Pack component1() {
        return this.pack;
    }

    @NotNull
    public final Overlay component2() {
        return this.overlays;
    }

    @NotNull
    public final PackMeta copy(@NotNull Pack pack, @NotNull Overlay overlays) {
        Intrinsics.checkNotNullParameter(pack, "pack");
        Intrinsics.checkNotNullParameter(overlays, "overlays");
        return new PackMeta(pack, overlays);
    }

    public static /* synthetic */ PackMeta copy$default(PackMeta packMeta, Pack pack, Overlay overlay, int n, Object object) {
        if ((n & 1) != 0) {
            pack = packMeta.pack;
        }
        if ((n & 2) != 0) {
            overlay = packMeta.overlays;
        }
        return packMeta.copy(pack, overlay);
    }

    @NotNull
    public String toString() {
        return "PackMeta(pack=" + this.pack + ", overlays=" + this.overlays + ")";
    }

    public int hashCode() {
        int result = this.pack.hashCode();
        result = result * 31 + this.overlays.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackMeta)) {
            return false;
        }
        PackMeta packMeta = (PackMeta)other;
        if (!Intrinsics.areEqual(this.pack, packMeta.pack)) {
            return false;
        }
        return Intrinsics.areEqual(this.overlays, packMeta.overlays);
    }

    private static final PackMeta default_delegate$lambda$0() {
        return new PackMeta(new Pack(PluginsKt.getBOOTSTRAP().mcmetaVersion(), "BetterHud's default resource pack.", new VersionRange(9, 55)), null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Companion;", "", "<init>", "()V", "default", "Lkr/toxicity/hud/pack/PackMeta;", "getDefault", "()Lkr/toxicity/hud/pack/PackMeta;", "default$delegate", "Lkr/toxicity/hud/shaded/kotlin/Lazy;", "zipEntry", "Ljava/util/zip/ZipEntry;", "getZipEntry", "()Ljava/util/zip/ZipEntry;", "fromFile", "file", "Ljava/io/File;", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PackMeta getDefault() {
            Lazy lazy = default$delegate;
            return (PackMeta)lazy.getValue();
        }

        @NotNull
        public final ZipEntry getZipEntry() {
            return zipEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PackMeta fromFile(@NotNull File file) {
            PackMeta packMeta;
            Intrinsics.checkNotNullParameter(file, "file");
            Object object = file;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                PackMeta packMeta2 = (PackMeta)GsonsKt.getGSON().fromJson((Reader)it, PackMeta.class);
                packMeta = packMeta2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Intrinsics.checkNotNullExpressionValue(packMeta, "use(...)");
            return packMeta;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Overlay;", "", "entries", "", "Lkr/toxicity/hud/pack/PackMeta$OverlayEntry;", "<init>", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "plus", "other", "component1", "copy", "equals", "", "hashCode", "", "toString", "", "dist"})
    @SourceDebugExtension(value={"SMAP\nPackMeta.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackMeta.kt\nkr/toxicity/hud/pack/PackMeta$Overlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1669#2,8:79\n*S KotlinDebug\n*F\n+ 1 PackMeta.kt\nkr/toxicity/hud/pack/PackMeta$Overlay\n*L\n58#1:79,8\n*E\n"})
    public static final class Overlay {
        @NotNull
        private final List<OverlayEntry> entries;

        public Overlay(@NotNull List<OverlayEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, "entries");
            this.entries = entries;
        }

        public /* synthetic */ Overlay(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<OverlayEntry> getEntries() {
            return this.entries;
        }

        @NotNull
        public final Overlay plus(@NotNull Overlay other) {
            Intrinsics.checkNotNullParameter(other, "other");
            Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)this.entries, (Iterable)other.entries);
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                OverlayEntry it = (OverlayEntry)e$iv;
                boolean bl = false;
                String key$iv = it.getDirectory();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List list = list$iv;
            return new Overlay(list);
        }

        @NotNull
        public final List<OverlayEntry> component1() {
            return this.entries;
        }

        @NotNull
        public final Overlay copy(@NotNull List<OverlayEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, "entries");
            return new Overlay(entries);
        }

        public static /* synthetic */ Overlay copy$default(Overlay overlay, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = overlay.entries;
            }
            return overlay.copy(list);
        }

        @NotNull
        public String toString() {
            return "Overlay(entries=" + this.entries + ")";
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Overlay)) {
                return false;
            }
            Overlay overlay = (Overlay)other;
            return Intrinsics.areEqual(this.entries, overlay.entries);
        }

        public Overlay() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/hud/pack/PackMeta$OverlayEntry;", "", "formats", "Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "directory", "", "<init>", "(Lkr/toxicity/hud/pack/PackMeta$VersionRange;Ljava/lang/String;)V", "getFormats", "()Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "getDirectory", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "dist"})
    public static final class OverlayEntry {
        @NotNull
        private final VersionRange formats;
        @NotNull
        private final String directory;

        public OverlayEntry(@NotNull VersionRange formats, @NotNull String directory) {
            Intrinsics.checkNotNullParameter(formats, "formats");
            Intrinsics.checkNotNullParameter(directory, "directory");
            this.formats = formats;
            this.directory = directory;
        }

        @NotNull
        public final VersionRange getFormats() {
            return this.formats;
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        @NotNull
        public final VersionRange component1() {
            return this.formats;
        }

        @NotNull
        public final String component2() {
            return this.directory;
        }

        @NotNull
        public final OverlayEntry copy(@NotNull VersionRange formats, @NotNull String directory) {
            Intrinsics.checkNotNullParameter(formats, "formats");
            Intrinsics.checkNotNullParameter(directory, "directory");
            return new OverlayEntry(formats, directory);
        }

        public static /* synthetic */ OverlayEntry copy$default(OverlayEntry overlayEntry, VersionRange versionRange, String string, int n, Object object) {
            if ((n & 1) != 0) {
                versionRange = overlayEntry.formats;
            }
            if ((n & 2) != 0) {
                string = overlayEntry.directory;
            }
            return overlayEntry.copy(versionRange, string);
        }

        @NotNull
        public String toString() {
            return "OverlayEntry(formats=" + this.formats + ", directory=" + this.directory + ")";
        }

        public int hashCode() {
            int result = this.formats.hashCode();
            result = result * 31 + this.directory.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverlayEntry)) {
                return false;
            }
            OverlayEntry overlayEntry = (OverlayEntry)other;
            if (!Intrinsics.areEqual(this.formats, overlayEntry.formats)) {
                return false;
            }
            return Intrinsics.areEqual(this.directory, overlayEntry.directory);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Pack;", "", "packFormat", "", "description", "", "supportedFormats", "Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "<init>", "(ILjava/lang/String;Lkr/toxicity/hud/pack/PackMeta$VersionRange;)V", "getPackFormat", "()I", "getDescription", "()Ljava/lang/String;", "getSupportedFormats", "()Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "plus", "other", "component1", "component2", "component3", "copy", "equals", "", "hashCode", "toString", "dist"})
    public static final class Pack {
        @SerializedName(value="pack_format")
        private final int packFormat;
        @NotNull
        private final String description;
        @SerializedName(value="supported_formats")
        @Nullable
        private final VersionRange supportedFormats;

        public Pack(int packFormat, @NotNull String description, @Nullable VersionRange supportedFormats) {
            Intrinsics.checkNotNullParameter(description, "description");
            this.packFormat = packFormat;
            this.description = description;
            this.supportedFormats = supportedFormats;
        }

        public final int getPackFormat() {
            return this.packFormat;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @Nullable
        public final VersionRange getSupportedFormats() {
            return this.supportedFormats;
        }

        @NotNull
        public final Pack plus(@NotNull Pack other) {
            Intrinsics.checkNotNullParameter(other, "other");
            VersionRange versionRange = this.supportedFormats;
            return new Pack(Math.max(this.packFormat, other.packFormat), other.description, versionRange != null ? versionRange.min(other.supportedFormats) : null);
        }

        public final int component1() {
            return this.packFormat;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        @Nullable
        public final VersionRange component3() {
            return this.supportedFormats;
        }

        @NotNull
        public final Pack copy(int packFormat, @NotNull String description, @Nullable VersionRange supportedFormats) {
            Intrinsics.checkNotNullParameter(description, "description");
            return new Pack(packFormat, description, supportedFormats);
        }

        public static /* synthetic */ Pack copy$default(Pack pack, int n, String string, VersionRange versionRange, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pack.packFormat;
            }
            if ((n2 & 2) != 0) {
                string = pack.description;
            }
            if ((n2 & 4) != 0) {
                versionRange = pack.supportedFormats;
            }
            return pack.copy(n, string, versionRange);
        }

        @NotNull
        public String toString() {
            return "Pack(packFormat=" + this.packFormat + ", description=" + this.description + ", supportedFormats=" + this.supportedFormats + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.packFormat);
            result = result * 31 + this.description.hashCode();
            result = result * 31 + (this.supportedFormats == null ? 0 : this.supportedFormats.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pack)) {
                return false;
            }
            Pack pack = (Pack)other;
            if (this.packFormat != pack.packFormat) {
                return false;
            }
            if (!Intrinsics.areEqual(this.description, pack.description)) {
                return false;
            }
            return Intrinsics.areEqual(this.supportedFormats, pack.supportedFormats);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0002\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0000H\u0086\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "", "min", "", "max", "<init>", "(II)V", "getMin", "()I", "getMax", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "dist"})
    public static final class VersionRange {
        @SerializedName(value="min_inclusive")
        private final int min;
        @SerializedName(value="max_inclusive")
        private final int max;

        public VersionRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        @NotNull
        public final VersionRange min(@Nullable VersionRange other) {
            return other != null ? new VersionRange(RangesKt.coerceAtMost(this.min, other.min), RangesKt.coerceAtMost(this.max, other.max)) : this;
        }

        public final int component1() {
            return this.min;
        }

        public final int component2() {
            return this.max;
        }

        @NotNull
        public final VersionRange copy(int min, int max) {
            return new VersionRange(min, max);
        }

        public static /* synthetic */ VersionRange copy$default(VersionRange versionRange, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = versionRange.min;
            }
            if ((n3 & 2) != 0) {
                n2 = versionRange.max;
            }
            return versionRange.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "VersionRange(min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.min);
            result = result * 31 + Integer.hashCode(this.max);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionRange)) {
                return false;
            }
            VersionRange versionRange = (VersionRange)other;
            if (this.min != versionRange.min) {
                return false;
            }
            return this.max == versionRange.max;
        }
    }
}

