/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.BetterHudAPI;
import kr.toxicity.hud.api.BetterHudBootstrap;
import kr.toxicity.hud.api.manager.CompassManager;
import kr.toxicity.hud.api.manager.ConfigManager;
import kr.toxicity.hud.api.manager.DatabaseManager;
import kr.toxicity.hud.api.manager.HudManager;
import kr.toxicity.hud.api.manager.ListenerManager;
import kr.toxicity.hud.api.manager.PlaceholderManager;
import kr.toxicity.hud.api.manager.PlayerManager;
import kr.toxicity.hud.api.manager.PopupManager;
import kr.toxicity.hud.api.manager.ShaderManager;
import kr.toxicity.hud.api.manager.TextManager;
import kr.toxicity.hud.api.manager.TriggerManager;
import kr.toxicity.hud.api.plugin.ReloadFlagType;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.plugin.ReloadState;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterHud {
    public static final String DEFAULT_NAMESPACE = "betterhud";
    public static final String ADVENTURE_VERSION = "4.24.0";
    public static final String PLATFORM_VERSION = "4.4.1";
    public static final String EXAMINATION_VERSION = "1.3.0";
    public static final int BSTATS_ID_BUKKIT = 21287;
    public static final int BSTATS_ID_VELOCITY = 23460;

    @NotNull
    public static BetterHud getInstance() {
        return BetterHudAPI.inst();
    }

    @NotNull
    default public ReloadState reload(ReloadFlagType ... args) {
        return this.reload(this.bootstrap().consoleSource(), args);
    }

    @NotNull
    default public ReloadState reload(@NotNull BetterCommandSource sender, ReloadFlagType ... args) {
        return this.reload(new ReloadInfo(sender, new HashSet<ReloadFlagType>(List.of(args))));
    }

    public boolean isDevVersion();

    @NotNull
    public BetterHudBootstrap bootstrap();

    @NotNull
    public ReloadState reload(@NotNull ReloadInfo var1);

    public boolean isMergeBossBar();

    public void loadAssets(@NotNull String var1, @NotNull File var2);

    public void loadAssets(@NotNull String var1, @NotNull BiConsumer<String, InputStream> var2);

    public int getWidth(int var1);

    @NotNull
    public PlaceholderManager getPlaceholderManager();

    @NotNull
    public ListenerManager getListenerManager();

    @NotNull
    public PopupManager getPopupManager();

    @NotNull
    public ConfigManager getConfigManager();

    @NotNull
    public CompassManager getCompassManager();

    @NotNull
    public TriggerManager getTriggerManager();

    @NotNull
    public HudManager getHudManager();

    @NotNull
    public DatabaseManager getDatabaseManager();

    @NotNull
    public ShaderManager getShaderManager();

    @NotNull
    public PlayerManager getPlayerManager();

    @NotNull
    public TextManager getTextManager();

    public boolean isOnReload();

    @NotNull
    public String getEncodedNamespace();

    @NotNull
    public Key getDefaultKey();

    @Nullable
    public String translate(@NotNull String var1, @NotNull String var2);

    public void addReloadStartTask(@NotNull Runnable var1);

    public void addReloadEndTask(@NotNull Consumer<ReloadState> var1);
}

