/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api.version;

import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public record MinecraftVersion(int first, int second, int third) implements Comparable<MinecraftVersion>
{
    private static final Comparator<MinecraftVersion> COMPARATOR = Comparator.comparing(MinecraftVersion::first).thenComparing(MinecraftVersion::second).thenComparing(MinecraftVersion::third);
    public static final MinecraftVersion V1_21_8 = new MinecraftVersion(1, 21, 8);
    public static final MinecraftVersion V1_21_7 = new MinecraftVersion(1, 21, 7);
    public static final MinecraftVersion V1_21_6 = new MinecraftVersion(1, 21, 6);
    public static final MinecraftVersion V1_21_5 = new MinecraftVersion(1, 21, 5);
    public static final MinecraftVersion V1_21_4 = new MinecraftVersion(1, 21, 4);
    public static final MinecraftVersion V1_21_3 = new MinecraftVersion(1, 21, 3);
    public static final MinecraftVersion V1_21_2 = new MinecraftVersion(1, 21, 2);
    public static final MinecraftVersion V1_21_1 = new MinecraftVersion(1, 21, 1);
    public static final MinecraftVersion V1_21 = new MinecraftVersion(1, 21, 0);
    public static final MinecraftVersion V1_20_6 = new MinecraftVersion(1, 20, 6);
    public static final MinecraftVersion V1_20_5 = new MinecraftVersion(1, 20, 5);
    public static final MinecraftVersion V1_20_4 = new MinecraftVersion(1, 20, 4);
    public static final MinecraftVersion V1_20_3 = new MinecraftVersion(1, 20, 3);
    public static final MinecraftVersion V1_20_2 = new MinecraftVersion(1, 20, 2);
    public static final MinecraftVersion V1_20_1 = new MinecraftVersion(1, 20, 1);
    public static final MinecraftVersion V1_20 = new MinecraftVersion(1, 20, 0);
    public static final MinecraftVersion V1_19_4 = new MinecraftVersion(1, 19, 4);
    public static final MinecraftVersion V1_19_3 = new MinecraftVersion(1, 19, 3);
    public static final MinecraftVersion V1_19_2 = new MinecraftVersion(1, 19, 2);
    public static final MinecraftVersion V1_19_1 = new MinecraftVersion(1, 19, 1);
    public static final MinecraftVersion V1_19 = new MinecraftVersion(1, 19, 0);
    public static final MinecraftVersion LATEST = V1_21_6;

    public MinecraftVersion(@NotNull String version) {
        this(version.split("\\."));
    }

    public MinecraftVersion(@NotNull String[] version) {
        this(version.length > 0 ? Integer.parseInt(version[0]) : 0, version.length > 1 ? Integer.parseInt(version[1]) : 0, version.length > 2 ? Integer.parseInt(version[2]) : 0);
    }

    @Override
    public int compareTo(@NotNull MinecraftVersion o) {
        return COMPARATOR.compare(this, o);
    }

    @Override
    @NotNull
    public String toString() {
        return this.first + "." + this.second + "." + this.third;
    }
}

