/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kr.toxicity.hud.pack.PackOverlay;
import kr.toxicity.hud.shaded.kotlin.Lazy;
import kr.toxicity.hud.shaded.kotlin.LazyKt;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.io.CloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.hud.shaded.kotlin.sequences.SequencesKt;
import kr.toxicity.hud.shaded.kotlin.text.Charsets;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lkr/toxicity/hud/pack/PackMeta;", "", "pack", "Lkr/toxicity/hud/pack/PackMeta$Pack;", "overlays", "Lkr/toxicity/hud/pack/PackMeta$Overlay;", "<init>", "(Lkr/toxicity/hud/pack/PackMeta$Pack;Lkr/toxicity/hud/pack/PackMeta$Overlay;)V", "getPack", "()Lkr/toxicity/hud/pack/PackMeta$Pack;", "getOverlays", "()Lkr/toxicity/hud/pack/PackMeta$Overlay;", "plus", "other", "toByteArray", "", "component1", "component2", "copy", "equals", "", "hashCode", "", "toString", "", "Companion", "Pack", "Overlay", "OverlayEntry", "VersionRange", "dist"})
@SourceDebugExtension(value={"SMAP\nPackMeta.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackMeta.kt\nkr/toxicity/hud/pack/PackMeta\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n774#2:139\n865#2,2:140\n1563#2:142\n1634#2,3:143\n*S KotlinDebug\n*F\n+ 1 PackMeta.kt\nkr/toxicity/hud/pack/PackMeta\n*L\n55#1:139\n55#1:140,2\n57#1:142\n57#1:143,3\n*E\n"})
public final class PackMeta {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Pack pack;
    @Nullable
    private final Overlay overlays;
    private static final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)VersionRange.class), (Object)new JsonDeserializer<VersionRange>(){

        public VersionRange deserialize(JsonElement p0, Type p1, JsonDeserializationContext p2) {
            VersionRange versionRange;
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            JsonElement jsonElement = p0;
            if (jsonElement instanceof JsonObject) {
                versionRange = new VersionRange(((JsonObject)p0).getAsJsonPrimitive("min_inclusive").getAsInt(), ((JsonObject)p0).getAsJsonPrimitive("max_inclusive").getAsInt());
            } else if (jsonElement instanceof JsonPrimitive) {
                int it = ((JsonPrimitive)p0).getAsInt();
                boolean bl = false;
                versionRange = new VersionRange(it, it);
            } else if (jsonElement instanceof JsonArray) {
                versionRange = new VersionRange(((JsonArray)p0).get(0).getAsInt(), ((JsonArray)p0).get(1).getAsInt());
            } else {
                throw new RuntimeException("VersionRage must be json array, integer or json object.");
            }
            return versionRange;
        }
    }).registerTypeAdapter((Type)((Object)VersionRange.class), (Object)new JsonSerializer<VersionRange>(){

        public JsonElement serialize(VersionRange p0, Type p1, JsonSerializationContext p2) {
            JsonElement jsonElement;
            Intrinsics.checkNotNullParameter(p0, "p0");
            Intrinsics.checkNotNullParameter(p1, "p1");
            Intrinsics.checkNotNullParameter(p2, "p2");
            if (p0.getMin() == p0.getMax()) {
                jsonElement = (JsonElement)new JsonPrimitive((Number)p0.getMin());
            } else {
                Object[] objectArray = new Object[]{p0.getMin(), p0.getMax()};
                jsonElement = (JsonElement)GsonsKt.jsonArrayOf(objectArray);
            }
            return jsonElement;
        }
    }).create();
    @NotNull
    private static final Lazy<PackMeta> default$delegate = LazyKt.lazy(PackMeta::default_delegate$lambda$0);

    public PackMeta(@NotNull Pack pack, @Nullable Overlay overlays) {
        Intrinsics.checkNotNullParameter(pack, "pack");
        this.pack = pack;
        this.overlays = overlays;
    }

    public /* synthetic */ PackMeta(Pack pack, Overlay overlay, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            overlay = new Overlay(null, 1, null);
        }
        this(pack, overlay);
    }

    @NotNull
    public final Pack getPack() {
        return this.pack;
    }

    @Nullable
    public final Overlay getOverlays() {
        return this.overlays;
    }

    @NotNull
    public final PackMeta plus(@NotNull PackMeta other) {
        Overlay overlay;
        Intrinsics.checkNotNullParameter(other, "other");
        Overlay o1 = this.overlays;
        Overlay o2 = other.overlays;
        Pack pack = this.pack.plus(other.pack);
        if (o1 != null && o2 != null) {
            overlay = o1.plus(o2);
        } else {
            overlay = o1;
            if (overlay == null && (overlay = o2) == null) {
                overlay = null;
            }
        }
        return new PackMeta(pack, overlay);
    }

    @NotNull
    public final byte[] toByteArray() {
        String string = gson.toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        return byArray;
    }

    @NotNull
    public final Pack component1() {
        return this.pack;
    }

    @Nullable
    public final Overlay component2() {
        return this.overlays;
    }

    @NotNull
    public final PackMeta copy(@NotNull Pack pack, @Nullable Overlay overlays) {
        Intrinsics.checkNotNullParameter(pack, "pack");
        return new PackMeta(pack, overlays);
    }

    public static /* synthetic */ PackMeta copy$default(PackMeta packMeta, Pack pack, Overlay overlay, int n, Object object) {
        if ((n & 1) != 0) {
            pack = packMeta.pack;
        }
        if ((n & 2) != 0) {
            overlay = packMeta.overlays;
        }
        return packMeta.copy(pack, overlay);
    }

    @NotNull
    public String toString() {
        return "PackMeta(pack=" + this.pack + ", overlays=" + this.overlays + ")";
    }

    public int hashCode() {
        int result = this.pack.hashCode();
        result = result * 31 + (this.overlays == null ? 0 : this.overlays.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackMeta)) {
            return false;
        }
        PackMeta packMeta = (PackMeta)other;
        if (!Intrinsics.areEqual(this.pack, packMeta.pack)) {
            return false;
        }
        return Intrinsics.areEqual(this.overlays, packMeta.overlays);
    }

    /*
     * WARNING - void declaration
     */
    private static final PackMeta default_delegate$lambda$0() {
        void var3_4;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PackOverlay it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = PackOverlay.getEntries();
        Pack pack = new Pack(PluginsKt.getBOOTSTRAP().mcmetaVersion(), "BetterHud's default resource pack.");
        boolean $i$f$filter = false;
        void var2_3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PackOverlay)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it.ordinal() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PackOverlay)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OverlayEntry(new VersionRange(it.getMinVersion(), it.getMaxVersion()), it.getOverlayName()));
        }
        List list = (List)var3_4;
        Overlay overlay = new Overlay(list);
        Pack pack2 = pack;
        return new PackMeta(pack2, overlay);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Companion;", "", "<init>", "()V", "gson", "Lcom/google/gson/Gson;", "kr.toxicity.hud.shaded.kotlin.jvm.PlatformType", "default", "Lkr/toxicity/hud/pack/PackMeta;", "getDefault", "()Lkr/toxicity/hud/pack/PackMeta;", "default$delegate", "Lkr/toxicity/hud/shaded/kotlin/Lazy;", "from", "array", "", "file", "Ljava/io/File;", "dist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PackMeta getDefault() {
            Lazy lazy = default$delegate;
            return (PackMeta)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PackMeta from(@NotNull byte[] array) {
            PackMeta packMeta;
            Intrinsics.checkNotNullParameter(array, "array");
            Closeable closeable = new InputStreamReader(new ByteArrayInputStream(array));
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                PackMeta packMeta2 = (PackMeta)gson.fromJson((Reader)it, PackMeta.class);
                packMeta = packMeta2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            Intrinsics.checkNotNullExpressionValue(packMeta, "use(...)");
            return packMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PackMeta from(@NotNull File file) {
            PackMeta packMeta;
            Intrinsics.checkNotNullParameter(file, "file");
            Object object = file;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                PackMeta packMeta2 = (PackMeta)gson.fromJson((Reader)it, PackMeta.class);
                packMeta = packMeta2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            Intrinsics.checkNotNullExpressionValue(packMeta, "use(...)");
            return packMeta;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000H\u0086\u0002J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Overlay;", "", "entries", "", "Lkr/toxicity/hud/pack/PackMeta$OverlayEntry;", "<init>", "(Ljava/util/List;)V", "getEntries", "()Ljava/util/List;", "plus", "other", "component1", "copy", "equals", "", "hashCode", "", "toString", "", "dist"})
    public static final class Overlay {
        @NotNull
        private final List<OverlayEntry> entries;

        public Overlay(@NotNull List<OverlayEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, "entries");
            this.entries = entries;
        }

        public /* synthetic */ Overlay(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @NotNull
        public final List<OverlayEntry> getEntries() {
            return this.entries;
        }

        @NotNull
        public final Overlay plus(@NotNull Overlay other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return new Overlay(SequencesKt.toList(SequencesKt.distinctBy(SequencesKt.sorted(CollectionsKt.asSequence(CollectionsKt.plus((Collection)this.entries, (Iterable)other.entries))), Overlay::plus$lambda$0)));
        }

        @NotNull
        public final List<OverlayEntry> component1() {
            return this.entries;
        }

        @NotNull
        public final Overlay copy(@NotNull List<OverlayEntry> entries) {
            Intrinsics.checkNotNullParameter(entries, "entries");
            return new Overlay(entries);
        }

        public static /* synthetic */ Overlay copy$default(Overlay overlay, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = overlay.entries;
            }
            return overlay.copy(list);
        }

        @NotNull
        public String toString() {
            return "Overlay(entries=" + this.entries + ")";
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Overlay)) {
                return false;
            }
            Overlay overlay = (Overlay)other;
            return Intrinsics.areEqual(this.entries, overlay.entries);
        }

        private static final String plus$lambda$0(OverlayEntry it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return it.getDirectory();
        }

        public Overlay() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lkr/toxicity/hud/pack/PackMeta$OverlayEntry;", "", "formats", "Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "directory", "", "<init>", "(Lkr/toxicity/hud/pack/PackMeta$VersionRange;Ljava/lang/String;)V", "getFormats", "()Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "getDirectory", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "dist"})
    public static final class OverlayEntry
    implements Comparable<OverlayEntry> {
        @NotNull
        private final VersionRange formats;
        @NotNull
        private final String directory;

        public OverlayEntry(@NotNull VersionRange formats, @NotNull String directory) {
            Intrinsics.checkNotNullParameter(formats, "formats");
            Intrinsics.checkNotNullParameter(directory, "directory");
            this.formats = formats;
            this.directory = directory;
        }

        @NotNull
        public final VersionRange getFormats() {
            return this.formats;
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        @Override
        public int compareTo(@NotNull OverlayEntry other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.formats.compareTo(other.formats);
        }

        @NotNull
        public final VersionRange component1() {
            return this.formats;
        }

        @NotNull
        public final String component2() {
            return this.directory;
        }

        @NotNull
        public final OverlayEntry copy(@NotNull VersionRange formats, @NotNull String directory) {
            Intrinsics.checkNotNullParameter(formats, "formats");
            Intrinsics.checkNotNullParameter(directory, "directory");
            return new OverlayEntry(formats, directory);
        }

        public static /* synthetic */ OverlayEntry copy$default(OverlayEntry overlayEntry, VersionRange versionRange, String string, int n, Object object) {
            if ((n & 1) != 0) {
                versionRange = overlayEntry.formats;
            }
            if ((n & 2) != 0) {
                string = overlayEntry.directory;
            }
            return overlayEntry.copy(versionRange, string);
        }

        @NotNull
        public String toString() {
            return "OverlayEntry(formats=" + this.formats + ", directory=" + this.directory + ")";
        }

        public int hashCode() {
            int result = this.formats.hashCode();
            result = result * 31 + this.directory.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OverlayEntry)) {
                return false;
            }
            OverlayEntry overlayEntry = (OverlayEntry)other;
            if (!Intrinsics.areEqual(this.formats, overlayEntry.formats)) {
                return false;
            }
            return Intrinsics.areEqual(this.directory, overlayEntry.directory);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/hud/pack/PackMeta$Pack;", "", "packFormat", "", "description", "", "<init>", "(ILjava/lang/String;)V", "getPackFormat", "()I", "getDescription", "()Ljava/lang/String;", "plus", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "dist"})
    public static final class Pack {
        @SerializedName(value="pack_format")
        private final int packFormat;
        @NotNull
        private final String description;

        public Pack(int packFormat, @NotNull String description) {
            Intrinsics.checkNotNullParameter(description, "description");
            this.packFormat = packFormat;
            this.description = description;
        }

        public final int getPackFormat() {
            return this.packFormat;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Pack plus(@NotNull Pack other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return new Pack(Math.max(this.packFormat, other.packFormat), other.description);
        }

        public final int component1() {
            return this.packFormat;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final Pack copy(int packFormat, @NotNull String description) {
            Intrinsics.checkNotNullParameter(description, "description");
            return new Pack(packFormat, description);
        }

        public static /* synthetic */ Pack copy$default(Pack pack, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = pack.packFormat;
            }
            if ((n2 & 2) != 0) {
                string = pack.description;
            }
            return pack.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "Pack(packFormat=" + this.packFormat + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.packFormat);
            result = result * 31 + this.description.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Pack)) {
                return false;
            }
            Pack pack = (Pack)other;
            if (this.packFormat != pack.packFormat) {
                return false;
            }
            return Intrinsics.areEqual(this.description, pack.description);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0002\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0000H\u0086\u0004J\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/hud/pack/PackMeta$VersionRange;", "", "min", "", "max", "<init>", "(II)V", "getMin", "()I", "getMax", "other", "compareTo", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "dist"})
    public static final class VersionRange
    implements Comparable<VersionRange> {
        private final int min;
        private final int max;

        public VersionRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        @NotNull
        public final VersionRange min(@Nullable VersionRange other) {
            return other != null ? new VersionRange(RangesKt.coerceAtMost(this.min, other.min), RangesKt.coerceAtMost(this.max, other.max)) : this;
        }

        @Override
        public int compareTo(@NotNull VersionRange other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return Intrinsics.compare(this.max, other.max);
        }

        public final int component1() {
            return this.min;
        }

        public final int component2() {
            return this.max;
        }

        @NotNull
        public final VersionRange copy(int min, int max) {
            return new VersionRange(min, max);
        }

        public static /* synthetic */ VersionRange copy$default(VersionRange versionRange, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = versionRange.min;
            }
            if ((n3 & 2) != 0) {
                n2 = versionRange.max;
            }
            return versionRange.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "VersionRange(min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.min);
            result = result * 31 + Integer.hashCode(this.max);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionRange)) {
                return false;
            }
            VersionRange versionRange = (VersionRange)other;
            if (this.min != versionRange.min) {
                return false;
            }
            return this.max == versionRange.max;
        }
    }
}

