/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.api;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import kr.toxicity.hud.api.BetterHudBootstrap;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public enum BetterHudPlatform {
    BUKKIT(b -> !b.isPaper() && !b.isFabric() && !b.isVelocity()),
    PAPER(BetterHudBootstrap::isPaper),
    VELOCITY(BetterHudBootstrap::isVelocity),
    FABRIC(BetterHudBootstrap::isFabric);

    @NotNull
    public static final @Unmodifiable Set<BetterHudPlatform> ALL;
    @NotNull
    private final Predicate<BetterHudBootstrap> predicate;

    @ApiStatus.Internal
    public boolean match(@NotNull BetterHudBootstrap bootstrap) {
        return this.predicate.test(bootstrap);
    }

    @Generated
    private BetterHudPlatform(Predicate<BetterHudBootstrap> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        this.predicate = predicate;
    }

    static {
        ALL = Collections.unmodifiableSet(EnumSet.allOf(BetterHudPlatform.class));
    }
}

