/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.api.component.WidthComponent;
import kr.toxicity.hud.api.plugin.ReloadInfo;
import kr.toxicity.hud.api.yaml.YamlElement;
import kr.toxicity.hud.api.yaml.YamlObject;
import kr.toxicity.hud.element.ImageElement;
import kr.toxicity.hud.image.NamedLoadedImage;
import kr.toxicity.hud.image.enums.ImageType;
import kr.toxicity.hud.layout.HudLayout;
import kr.toxicity.hud.manager.BetterHudManager;
import kr.toxicity.hud.pack.PackGenerator;
import kr.toxicity.hud.resource.GlobalResource;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.hud.util.FilesKt;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.ImagesKt;
import kr.toxicity.hud.util.MapsKt;
import kr.toxicity.hud.util.YamlsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u0012J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0013J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u001cH\u0016J \u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u00160\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lkr/toxicity/hud/manager/ImageManager;", "Lkr/toxicity/hud/manager/BetterHudManager;", "<init>", "()V", "managerName", "", "getManagerName", "()Ljava/lang/String;", "supportExternalPacks", "", "getSupportExternalPacks", "()Z", "imageMap", "Ljava/util/HashMap;", "Lkr/toxicity/hud/element/ImageElement;", "Lkr/toxicity/hud/shaded/kotlin/collections/HashMap;", "imageNameComponent", "Ljava/util/concurrent/ConcurrentHashMap;", "Lkr/toxicity/hud/layout/HudLayout$Identifier;", "Lkr/toxicity/hud/api/component/WidthComponent;", "allImage", "", "Lkr/toxicity/hud/shaded/kotlin/jvm/internal/EnhancedNullability;", "getAllImage", "()Ljava/util/Collection;", "getImage", "group", "setImage", "", "component", "start", "name", "preReload", "reload", "workingDirectory", "Ljava/io/File;", "info", "Lkr/toxicity/hud/api/plugin/ReloadInfo;", "resource", "Lkr/toxicity/hud/resource/GlobalResource;", "postReload", "end", "dist"})
@SourceDebugExtension(value={"SMAP\nImageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageManager.kt\nkr/toxicity/hud/manager/ImageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1869#2:79\n1669#2,8:80\n1869#2,2:88\n1870#2:90\n*S KotlinDebug\n*F\n+ 1 ImageManager.kt\nkr/toxicity/hud/manager/ImageManager\n*L\n57#1:79\n60#1:80,8\n62#1:88,2\n57#1:90\n*E\n"})
public final class ImageManager
implements BetterHudManager {
    @NotNull
    public static final ImageManager INSTANCE = new ImageManager();
    @NotNull
    private static final String managerName = "Image";
    private static final boolean supportExternalPacks = true;
    @NotNull
    private static final HashMap<String, ImageElement> imageMap = new HashMap();
    @NotNull
    private static final ConcurrentHashMap<HudLayout.Identifier, WidthComponent> imageNameComponent = new ConcurrentHashMap();

    private ImageManager() {
    }

    @Override
    @NotNull
    public String getManagerName() {
        return managerName;
    }

    @Override
    public boolean getSupportExternalPacks() {
        return supportExternalPacks;
    }

    @NotNull
    public final Collection<ImageElement> getAllImage() {
        Collection<ImageElement> collection = imageMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    @Nullable
    public final synchronized WidthComponent getImage(@NotNull HudLayout.Identifier group) {
        Intrinsics.checkNotNullParameter(group, "group");
        return imageNameComponent.get(group);
    }

    public final synchronized void setImage(@NotNull HudLayout.Identifier group, @NotNull WidthComponent component) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(component, "component");
        ((Map)imageNameComponent).put(group, component);
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ImageElement getImage(@NotNull String name) {
        ImageElement imageElement;
        Intrinsics.checkNotNullParameter(name, "name");
        HashMap<String, ImageElement> hashMap = imageMap;
        synchronized (hashMap) {
            boolean bl = false;
            imageElement = imageMap.get(name);
        }
        return imageElement;
    }

    @Override
    public void preReload() {
        imageMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull File workingDirectory, @NotNull ReloadInfo info, @NotNull GlobalResource resource) {
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(resource, "resource");
        File assets = FilesKt.subFolder(workingDirectory, "assets");
        HashMap map = new HashMap();
        File file = FilesKt.subFolder(workingDirectory, "images");
        BetterCommandSource betterCommandSource = info.sender();
        Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
        YamlsKt.forEachAllYaml(file, betterCommandSource, (arg_0, arg_1, arg_2) -> ImageManager.reload$lambda$0(info, assets, map, arg_0, arg_1, arg_2));
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            ImageElement value = (ImageElement)element$iv;
            boolean bl = false;
            List<NamedLoadedImage> list = value.getImage();
            if (!(!((Collection)list).isEmpty())) continue;
            Iterable $this$distinctBy$iv = list;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                NamedLoadedImage it = (NamedLoadedImage)e$iv;
                boolean bl2 = false;
                String key$iv = it.getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            $this$distinctBy$iv = list$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                NamedLoadedImage it = (NamedLoadedImage)element$iv2;
                boolean bl3 = false;
                PackGenerator.INSTANCE.addTask((Iterable<String>)CollectionsKt.plus((Collection)resource.getTextures(), it.getName()), () -> ImageManager.reload$lambda$1$1$0(it));
            }
        }
        ((Map)imageMap).putAll(map);
    }

    @Override
    public void postReload() {
        imageNameComponent.clear();
    }

    @Override
    public void end() {
    }

    private static final Unit reload$lambda$0(ReloadInfo $info, File $assets, HashMap $map, File file, String s, YamlObject yamlObject) {
        Object object;
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(yamlObject, "yamlObject");
        ImageManager imageManager = INSTANCE;
        try {
            ImageManager $this$reload_u24lambda_u240_u240 = imageManager;
            boolean bl = false;
            YamlElement yamlElement = yamlObject.get("type");
            String string = FunctionsKt.ifNull(yamlElement != null ? yamlElement.asString() : null, ImageManager::reload$lambda$0$0$0).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            ImageType imageType = ImageType.valueOf(string);
            BetterCommandSource betterCommandSource = $info.sender();
            Intrinsics.checkNotNullExpressionValue(betterCommandSource, "sender(...)");
            ImageElement image = imageType.createElement($assets, betterCommandSource, file, s, yamlObject);
            MapsKt.putSync($map, "image", () -> ImageManager.reload$lambda$0$0$1(image));
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        FunctionsKt.handleFailure(object, $info, () -> ImageManager.reload$lambda$0$1(s, file));
        return Unit.INSTANCE;
    }

    private static final String reload$lambda$0$0$0() {
        return "type value not set.";
    }

    private static final ImageElement reload$lambda$0$0$1(ImageElement $image) {
        return $image;
    }

    private static final String reload$lambda$0$1(String $s, File $file) {
        return "Unable to load this image: " + $s + " in " + $file.getName();
    }

    private static final byte[] reload$lambda$1$1$0(NamedLoadedImage $it) {
        return ImagesKt.toByteArray($it.getImage().getImage());
    }
}

