/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.kr.toxicity.command.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.command.CommandLogger;
import kr.toxicity.command.MessageSender;
import kr.toxicity.command.ReloadState;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.ClassSerializer;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.ClassSerializers;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandMessage;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandModule;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandPrefix;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.MessageRegistry;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.NotDirectoryException;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.NotJsonObjectException;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BetterCommand {
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\[(?<value>[a-zA-Z]+)]");
    private final File dataFolder;
    private final Map<Class<?>, ClassSerializer<?>> serializerMap = new LinkedHashMap();
    private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    private Consumer<Throwable> exceptionHandler = e -> {};
    private final CommandLogger logger;
    private CommandPrefix prefix = CommandPrefix.DEFAULT;
    final ComponentSerializer<Component, Component, String> serializer;
    final MessageRegistry registry;
    private Supplier<Boolean> silentLog = () -> false;
    private volatile boolean onReload;

    public BetterCommand(@NotNull File dataFolder, @NotNull ComponentSerializer<Component, Component, String> serializer) {
        this(dataFolder, serializer, CommandLogger.DEFAULT);
    }

    public BetterCommand(@NotNull File dataFolder, @NotNull ComponentSerializer<Component, Component, String> serializer, final @NotNull CommandLogger logger2) {
        Objects.requireNonNull(dataFolder, "dataFolder");
        Objects.requireNonNull(serializer, "serializer");
        Objects.requireNonNull(logger2, "logger");
        if (dataFolder.isFile()) {
            throw new NotDirectoryException(dataFolder.getPath() + " is not a directory.");
        }
        this.dataFolder = dataFolder;
        this.serializer = serializer;
        this.logger = new CommandLogger(){

            @Override
            public void info(String ... messages) {
                if (!BetterCommand.this.silentLog.get().booleanValue()) {
                    logger2.info(messages);
                }
            }

            @Override
            public void warn(String ... messages) {
                if (!BetterCommand.this.silentLog.get().booleanValue()) {
                    logger2.warn(messages);
                }
            }
        };
        this.registry = new MessageRegistry(serializer);
        this.addSerializer(String.class, ClassSerializers.STRING);
        this.addSerializer(Integer.class, ClassSerializers.INTEGER);
        this.addSerializer(Double.class, ClassSerializers.DOUBLE);
        this.addSerializer(Float.class, ClassSerializers.FLOAT);
        this.addSerializer(Long.class, ClassSerializers.LONG);
        this.addSerializer(Short.class, ClassSerializers.SHORT);
        this.addSerializer(Byte.class, ClassSerializers.BYTE);
        this.addSerializer(Character.class, ClassSerializers.CHARACTER);
        this.addSerializer(Boolean.class, ClassSerializers.BOOLEAN);
    }

    @NotNull
    public <T> BetterCommand addSerializer(@NotNull Class<T> clazz, ClassSerializer<? extends T> serializer) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(serializer, "serializer");
        this.serializerMap.put(clazz, serializer);
        return this;
    }

    @NotNull
    public BetterCommand silentLog(Supplier<Boolean> silentLog) {
        this.silentLog = silentLog;
        return this;
    }

    @NotNull
    public BetterCommand prefix(@NotNull CommandPrefix prefix) {
        Objects.requireNonNull(prefix, "prefix");
        this.prefix = prefix;
        return this;
    }

    @NotNull
    public BetterCommand exceptionHandler(@NotNull Consumer<Throwable> handler) {
        Objects.requireNonNull(handler, "handler");
        Consumer<Throwable> old = this.exceptionHandler;
        this.exceptionHandler = old.andThen(handler);
        return this;
    }

    void handleException(@NotNull Throwable throwable) {
        this.exceptionHandler.accept(throwable);
    }

    @NotNull
    public CommandPrefix prefix() {
        return this.prefix;
    }

    @NotNull
    public CommandLogger logger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized ReloadState reload() {
        if (this.onReload) {
            return ReloadState.ON_RELOAD;
        }
        this.onReload = true;
        try {
            long time = System.currentTimeMillis();
            if (!this.dataFolder.exists() && this.dataFolder.mkdirs()) {
                this.logger.warn("Unable to make a directory in " + this.dataFolder.getPath());
            }
            File[] listFiles = this.dataFolder.listFiles();
            this.registry.clear();
            if (listFiles != null) {
                for (File file : listFiles) {
                    this.addLang(file);
                }
            }
            BetterCommand betterCommand = this;
            synchronized (betterCommand) {
                this.onReload = false;
            }
            return new ReloadState.Success(System.currentTimeMillis() - time);
        }
        catch (Exception any) {
            BetterCommand betterCommand = this;
            synchronized (betterCommand) {
                this.onReload = false;
            }
            return new ReloadState.Failure(any);
        }
    }

    public boolean generateDefaultLang(@NotNull Locale locale) {
        if (this.registry.contains(locale)) {
            return false;
        }
        File file = new File(this.dataFolder, locale.getLanguage().toLowerCase() + "_" + locale.getCountry().toUpperCase() + ".json");
        JsonObject object = file.exists() ? this.parseFile(file) : new JsonObject();
        for (CommandMessage allMessage : CommandMessage.allMessages()) {
            object.addProperty(allMessage.key(), (String)this.serializer.serialize(allMessage.defaultMessage()));
        }
        try (FileWriter stream = new FileWriter(file);
             BufferedWriter buffer = new BufferedWriter(stream);
             JsonWriter json = new JsonWriter((Writer)buffer);){
            json.setIndent(" ");
            this.gson.toJson((JsonElement)object, json);
            this.registry.register(locale, object);
        }
        catch (IOException e) {
            this.handleException(e, "Unable to create lang file to " + file.getPath());
        }
        return true;
    }

    private void addLang(@NotNull File file) {
        FileName fileName = FileName.parse(file);
        if (fileName.extension == null || !fileName.extension.equals("json")) {
            this.logger.warn("This file is not a json. skipped: " + file.getPath());
            return;
        }
        try {
            String[] localeSplit = fileName.name.split("_");
            Locale locale = localeSplit.length == 1 ? new Locale(localeSplit[0]) : new Locale(localeSplit[0].toLowerCase(), localeSplit[1].toUpperCase());
            this.registry.register(locale, this.parseFile(file));
            this.logger.info("New lang file loaded: " + locale);
        }
        catch (Exception e) {
            this.handleException(e, "Unable to read this file: " + file.getPath());
        }
    }

    private void handleException(@NotNull Exception exception, @NotNull String message) {
        try (StringWriter stringWriter = new StringWriter();
             PrintWriter printWriter = new PrintWriter(stringWriter);){
            exception.printStackTrace(printWriter);
            this.logger.warn(message, "Reason: " + exception.getClass().getSimpleName(), "Stack trace: " + stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private Component component(@NotNull BetterCommandSource source, @NotNull CommandMessage message) {
        return this.registry.find(source, message);
    }

    @NotNull
    public MessageSender registerKey(@NotNull CommandMessage message) {
        return (l, s, m) -> {
            Component msg = this.component(s, message);
            if (((String)this.serializer.serialize(msg)).isEmpty()) {
                return;
            }
            Audience audience = s.audience();
            TextComponent.Builder builder = Component.text();
            audience.sendMessage((ComponentLike)((TextComponent.Builder)builder.append(this.component(s, switch (l) {
                default -> throw new IncompatibleClassChangeError();
                case MessageSender.SendLevel.INFO -> this.prefix.info();
                case MessageSender.SendLevel.WARN -> this.prefix.warn();
                case MessageSender.SendLevel.ERROR -> this.prefix.error();
            }))).append(msg.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(VALUE_PATTERN).replacement((r, b) -> {
                String group = r.group(1);
                Component get2 = (Component)m.get(group);
                return get2 != null ? get2 : Component.text((String)group);
            }).build())));
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject parseFile(@NotNull File file) {
        try (FileReader reader = new FileReader(file);
             BufferedReader buffered = new BufferedReader(reader);
             JsonReader json = new JsonReader((Reader)buffered);){
            JsonElement result = JsonParser.parseReader((JsonReader)json);
            if (!result.isJsonObject()) throw new NotJsonObjectException("This file is not a json object: " + file.getPath());
            JsonObject jsonObject = result.getAsJsonObject();
            return jsonObject;
        }
        catch (IOException exception) {
            this.handleException(exception);
            throw new RuntimeException(exception);
        }
    }

    @Nullable
    ClassSerializer<?> find(@NotNull Class<?> clazz) {
        return this.serializerMap.get(clazz);
    }

    @NotNull
    public <W extends BetterCommandSource> CommandModule<W> module(@NotNull String name) {
        return new CommandModule(this, name);
    }

    @NotNull
    public Component prefix(@NotNull BetterCommandSource source, @NotNull PrefixType type) {
        CommandMessage get2 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PrefixType.INFO -> this.prefix.info();
            case PrefixType.WARN -> this.prefix.warn();
            case PrefixType.ERROR -> this.prefix.error();
        };
        return this.registry.find(source, get2);
    }

    @Generated
    public Supplier<Boolean> getSilentLog() {
        return this.silentLog;
    }

    @Generated
    public boolean isOnReload() {
        return this.onReload;
    }

    private record FileName(@NotNull String name, @Nullable String extension) {
        @NotNull
        private static FileName parse(@NotNull File file) {
            String[] name = file.getName().split("\\.");
            return new FileName(name[0], name.length > 1 ? name[1] : null);
        }
    }

    public static enum PrefixType {
        INFO,
        WARN,
        ERROR;

    }
}

