/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kr.toxicity.hud.manager.ConfigManagerImpl;
import kr.toxicity.hud.pack.PackUUID;
import kr.toxicity.hud.shaded.kotlin.Metadata;
import kr.toxicity.hud.shaded.kotlin.Result;
import kr.toxicity.hud.shaded.kotlin.ResultKt;
import kr.toxicity.hud.shaded.kotlin.Unit;
import kr.toxicity.hud.shaded.kotlin.jdk7.AutoCloseableKt;
import kr.toxicity.hud.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.hud.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.hud.util.FunctionsKt;
import kr.toxicity.hud.util.GsonsKt;
import kr.toxicity.hud.util.PluginsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/hud/pack/PackUploader;", "", "<init>", "()V", "value", "Lkr/toxicity/hud/pack/PackUploader$PackServer;", "server", "getServer", "()Lkr/toxicity/hud/pack/PackUploader$PackServer;", "stop", "", "upload", "", "packUUID", "Lkr/toxicity/hud/pack/PackUUID;", "byteArray", "", "PackServer", "dist"})
public final class PackUploader {
    @NotNull
    public static final PackUploader INSTANCE = new PackUploader();
    @Nullable
    private static volatile PackServer server;

    private PackUploader() {
    }

    @Nullable
    public final PackServer getServer() {
        return server;
    }

    public final boolean stop() {
        Unit unit;
        PackServer packServer = server;
        if (packServer != null) {
            packServer.stop();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        boolean result = unit != null;
        server = null;
        return result;
    }

    public final void upload(@NotNull PackUUID packUUID, @NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter(packUUID, "packUUID");
        Intrinsics.checkNotNullParameter(byteArray, "byteArray");
        String host = ConfigManagerImpl.INSTANCE.getSelfHostIp();
        if (Intrinsics.areEqual(host, "*")) {
            Object object = FunctionsKt.httpClient(arg_0 -> PackUploader.upload$lambda$7(packUUID, byteArray, arg_0));
            Throwable throwable = Result.exceptionOrNull-impl(object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                FunctionsKt.handle(it, "Unable to open server.");
            }
            Result.box-impl(object);
        } else {
            PackUploader.upload$openServer(packUUID, byteArray, host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void upload$openServer$lambda$3$lambda$2$lambda$1(PackUUID $packUUID, byte[] $byteArray, HttpExchange exec) {
        AutoCloseable autoCloseable = exec;
        Throwable throwable = null;
        try {
            HttpExchange exchange = (HttpExchange)autoCloseable;
            boolean bl = false;
            if (!Intrinsics.areEqual(exchange.getRequestURI().getPath(), "/" + $packUUID.getHash() + ".zip")) {
                exchange.getResponseHeaders().set("Content-Type", "application/json");
                byte[] byArray = GsonsKt.toByteArray((JsonElement)new JsonPrimitive("Invalid file name."));
                exchange.sendResponseHeaders(200, byArray.length);
                exchange.getResponseBody().write(byArray);
            } else {
                exchange.getResponseHeaders().set("Content-Type", "application/zip");
                exchange.sendResponseHeaders(200, $byteArray.length);
                exchange.getResponseBody().write($byteArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private static final void upload$openServer(PackUUID $packUUID, byte[] $byteArray, String body) {
        block3: {
            Object object;
            int host = ConfigManagerImpl.INSTANCE.getSelfHostPort();
            String url = "http://" + body + ":" + host + "/" + $packUUID.getHash() + ".zip";
            Object object2 = INSTANCE;
            try {
                String[] stringArray;
                PackUploader $this$upload_u24openServer_u24lambda_u243 = object2;
                boolean bl = false;
                PackServer packServer = server;
                if (packServer != null) {
                    packServer.stop();
                }
                $packUUID.save();
                String[] $this$upload_u24openServer_u24lambda_u243_u24lambda_u242 = stringArray = HttpServer.create(new InetSocketAddress(InetAddress.getLocalHost(), host), 0);
                boolean bl2 = false;
                $this$upload_u24openServer_u24lambda_u243_u24lambda_u242.createContext("/", arg_0 -> PackUploader.upload$openServer$lambda$3$lambda$2$lambda$1($packUUID, $byteArray, arg_0));
                $this$upload_u24openServer_u24lambda_u243_u24lambda_u242.start();
                String[] http = stringArray;
                server = new PackServer($packUUID, url, (HttpServer)http){
                    private final UUID uuid;
                    private final byte[] digest;
                    private final String digestString;
                    private final String url;
                    final /* synthetic */ HttpServer $http;
                    {
                        this.$http = $http;
                        this.uuid = $packUUID.getUuid();
                        this.digest = $packUUID.getDigest();
                        this.digestString = $packUUID.getHash();
                        this.url = $url;
                    }

                    public void stop() {
                        this.$http.stop(0);
                    }

                    public UUID getUuid() {
                        return this.uuid;
                    }

                    public byte[] getDigest() {
                        return this.digest;
                    }

                    public String getDigestString() {
                        return this.digestString;
                    }

                    public String getUrl() {
                        return this.url;
                    }
                };
                PluginsKt.getBOOTSTRAP().sendResourcePack();
                stringArray = new String[]{"Resource pack server opened at " + url};
                PluginsKt.info(stringArray);
                object = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            FunctionsKt.handle((Throwable)it, "Unable to open server.");
        }
    }

    private static final Unit upload$lambda$7$lambda$5(PackUUID $packUUID, byte[] $byteArray, HttpResponse it) {
        String body = (String)it.body();
        Intrinsics.checkNotNull(body);
        String string = body.substring(0, body.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        PackUploader.upload$openServer($packUUID, $byteArray, string);
        return Unit.INSTANCE;
    }

    private static final void upload$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CompletableFuture upload$lambda$7(PackUUID $packUUID, byte[] $byteArray, HttpClient $this$httpClient) {
        Intrinsics.checkNotNullParameter($this$httpClient, "$this$httpClient");
        return $this$httpClient.sendAsync(HttpRequest.newBuilder().uri(URI.create("http://checkip.amazonaws.com/")).GET().build(), HttpResponse.BodyHandlers.ofString()).thenAccept(arg_0 -> PackUploader.upload$lambda$7$lambda$6(arg_0 -> PackUploader.upload$lambda$7$lambda$5($packUUID, $byteArray, arg_0), arg_0));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/hud/pack/PackUploader$PackServer;", "", "stop", "", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "url", "", "getUrl", "()Ljava/lang/String;", "digest", "", "getDigest", "()[B", "digestString", "getDigestString", "dist"})
    public static interface PackServer {
        public void stop();

        @NotNull
        public UUID getUuid();

        @NotNull
        public String getUrl();

        @NotNull
        public byte[] getDigest();

        @NotNull
        public String getDigestString();
    }
}

