/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.hud.shaded.kr.toxicity.command.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kr.toxicity.command.BetterCommandSource;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.CommandMessage;
import kr.toxicity.hud.shaded.kr.toxicity.command.impl.exception.NotJsonPrimitiveException;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;

final class MessageRegistry {
    private final Map<Locale, Map<String, Component>> localeMap = new HashMap<Locale, Map<String, Component>>();
    private final ComponentSerializer<Component, Component, String> serializer;

    void register(@NotNull Locale locale, @NotNull JsonObject object) {
        Objects.requireNonNull(locale, "locale");
        Objects.requireNonNull(object, "object");
        this.localeMap.computeIfAbsent(locale, l -> {
            HashMap<String, Component> map = new HashMap<String, Component>();
            for (Map.Entry entry : object.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonPrimitive()) {
                    throw new NotJsonPrimitiveException("The key " + (String)entry.getKey() + " in " + locale + " is not a json primitive.");
                }
                map.put((String)entry.getKey(), this.serializer.deserialize((Object)value.getAsString()));
            }
            return map;
        });
    }

    void clear() {
        this.localeMap.clear();
    }

    boolean contains(@NotNull Locale locale) {
        return this.localeMap.containsKey(locale);
    }

    @NotNull
    Component find(@NotNull BetterCommandSource source, @NotNull CommandMessage message) {
        Map<String, Component> map = this.localeMap.get(source.locale());
        if (map == null) {
            return message.defaultMessage();
        }
        Component component = map.get(message.key());
        if (component == null) {
            return message.defaultMessage();
        }
        return component;
    }

    @Generated
    public MessageRegistry(ComponentSerializer<Component, Component, String> serializer) {
        this.serializer = serializer;
    }
}

