/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension;

import com.github.L_Ender.cataclysm.init.ModItems;
import com.mojang.logging.LogUtils;
import com.p1nero.cataclysm_dimension.CataclysmDimensionModConfig;
import com.p1nero.cataclysm_dimension.worldgen.CataclysmDimensions;
import com.p1nero.cataclysm_dimension.worldgen.placements.CDPlacementTypes;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="cataclysm_dimension")
public class CataclysmDimensionMod {
    public static final String MOD_ID = "cataclysm_dimension";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int COOLDOWN_TICKS = 600;
    private static final int DEFAULT_SLOW_FALLING_DURATION = 200;
    private static final int LONG_SLOW_FALLING_DURATION = 400;
    private static final Map<Item, TeleportConfig> TELEPORT_CONFIGS = new HashMap<Item, TeleportConfig>();
    public static final Map<ResourceLocation, Boolean> RESOURCE_KEY_BOOLEAN_MAP = new HashMap<ResourceLocation, Boolean>();

    public CataclysmDimensionMod(ModContainer modContainer, IEventBus bus) {
        NeoForge.EVENT_BUS.addListener(this::onItemUse);
        NeoForge.EVENT_BUS.addListener(this::onToolTip);
        NeoForge.EVENT_BUS.addListener(this::onServerLevelTick);
        CataclysmDimensionModConfig.loadConfig();
        bus.addListener(this::onDatapackLoad);
        CDPlacementTypes.STRUCTURE_PLACEMENT_TYPES.register(bus);
    }

    private void initTeleportConfigs() {
        TELEPORT_CONFIGS.put((Item)ModItems.ABYSS_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_ABYSSAL_DEPTHS_LEVEL_KEY, 150, 200));
        TELEPORT_CONFIGS.put((Item)ModItems.MECH_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_FORGE_OF_AEONS_LEVEL_KEY, 150, 200));
        TELEPORT_CONFIGS.put((Item)ModItems.FLAME_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_INFERNOS_MAW_LEVEL_KEY, 64, 200));
        TELEPORT_CONFIGS.put((Item)ModItems.VOID_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_BASTION_LOST_LEVEL_KEY, 150, 200));
        TELEPORT_CONFIGS.put((Item)ModItems.MONSTROUS_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_SOULS_ANVIL_LEVEL_KEY, 64, 200));
        TELEPORT_CONFIGS.put((Item)ModItems.DESERT_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_PHARAOHS_BANE_LEVEL_KEY, 200, 400));
        TELEPORT_CONFIGS.put((Item)ModItems.CURSED_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_ETERNAL_FROSTHOLD_LEVEL_KEY, 200, 400));
        TELEPORT_CONFIGS.put((Item)ModItems.STORM_EYE.get(), new TeleportConfig(CataclysmDimensions.CATACLYSM_SANCTUM_FALLEN_LEVEL_KEY, 200, 0));
    }

    private void onItemUse(LivingEntityUseItemEvent event) {
        TeleportConfig config;
        Player player;
        if (!CataclysmDimensionModConfig.ENABLE_TELEPORT_EYE) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide || !entity.isShiftKeyDown()) {
            return;
        }
        ItemStack itemStack = event.getItem();
        MinecraftServer server = entity.level().getServer();
        if (server == null) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(itemStack.getItem())) {
            return;
        }
        if (TELEPORT_CONFIGS.isEmpty()) {
            this.initTeleportConfigs();
        }
        if ((config = TELEPORT_CONFIGS.get(itemStack.getItem())) == null) {
            return;
        }
        ServerLevel targetLevel = server.getLevel(config.dimensionKey());
        if (targetLevel == null) {
            return;
        }
        if (CataclysmDimensionModConfig.SLOW_FALL_WHEN_ENTER_DIMENSIONS && config.effectDuration() > 0) {
            entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, config.effectDuration(), 1, false, true));
        }
        Vec3 targetPosition = new Vec3(0.0, (double)config.targetY(), 0.0);
        entity.changeDimension(new DimensionTransition(targetLevel, targetPosition, Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND));
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            player2.getCooldowns().addCooldown(itemStack.getItem(), 600);
        }
    }

    private void onServerLevelTick(LevelTickEvent.Pre event) {
        ServerLevel serverLevel;
        Level level = event.getLevel();
        if (level instanceof ServerLevel && CataclysmDimensions.LEVELS.contains((serverLevel = (ServerLevel)level).dimension())) {
            final ResourceLocation resourceLocation = serverLevel.dimension().location();
            if (!serverLevel.players().isEmpty()) {
                RESOURCE_KEY_BOOLEAN_MAP.put(resourceLocation, false);
            }
            if (serverLevel.players().isEmpty() && CataclysmDimensionModConfig.RESET_DIMENSION_IF_NO_PLAYER && !RESOURCE_KEY_BOOLEAN_MAP.getOrDefault(resourceLocation, false).booleanValue()) {
                try {
                    LOGGER.info("[Cataclysm Dimension]: No player inside. trying to reset dimension {}.", (Object)resourceLocation);
                    IOWorker ioWorker = (IOWorker)serverLevel.getChunkSource().chunkScanner();
                    if (Files.exists(ioWorker.storage.folder, new LinkOption[0])) {
                        serverLevel.noSave = false;
                        serverLevel.save(null, true, true);
                        ioWorker.storage.regionCache.clear();
                        Files.walkFileTree(ioWorker.storage.folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                            @Override
                            @NotNull
                            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                                if (Files.deleteIfExists(file)) {
                                    LOGGER.info("[Cataclysm Dimension]: {} region cache Deleted.", (Object)resourceLocation);
                                }
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    } else {
                        LOGGER.info("[Cataclysm Dimension]: No region files in {}. Skipped.", (Object)resourceLocation);
                    }
                    RESOURCE_KEY_BOOLEAN_MAP.put(resourceLocation, true);
                }
                catch (Exception e) {
                    LOGGER.error("[Cataclysm Dimension]: Failed to reset dimension {}.", (Object)resourceLocation, (Object)e);
                }
            }
        }
    }

    private void onToolTip(ItemTooltipEvent event) {
        if (!CataclysmDimensionModConfig.ENABLE_TELEPORT_EYE) {
            return;
        }
        if (TELEPORT_CONFIGS.isEmpty()) {
            this.initTeleportConfigs();
        }
        if (TELEPORT_CONFIGS.containsKey(event.getItemStack().getItem())) {
            event.getToolTip().add(Component.translatable((String)"tip.cataclysm_dimension.enter").withStyle(ChatFormatting.GRAY));
        }
    }

    private void onDatapackLoad(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            String name = CataclysmDimensionModConfig.KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS ? "packs/keep_original" : "packs/not_keep_original";
            event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name), PackType.SERVER_DATA, (Component)Component.literal((String)name), PackSource.WORLD, true, Pack.Position.TOP);
            if (CataclysmDimensionModConfig.RANDOM_SPREAD_IN_DIMENSION) {
                name = CataclysmDimensionModConfig.KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS ? "packs/random_spread_dim" : "packs/random_spread";
                event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name), PackType.SERVER_DATA, (Component)Component.literal((String)name), PackSource.WORLD, true, Pack.Position.TOP);
            }
        }
    }

    private record TeleportConfig(ResourceKey<Level> dimensionKey, int targetY, int effectDuration) {
    }
}

