/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension.worldgen;

import com.p1nero.cataclysm_dimension.worldgen.CDSurfaceRuleData;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class CDNoiseSettings {
    public static final ResourceKey<NoiseGeneratorSettings> PLAIN = CDNoiseSettings.createNoiseGeneratorKey("plain_noise_gen");
    public static final ResourceKey<NoiseGeneratorSettings> SEA = CDNoiseSettings.createNoiseGeneratorKey("sea");
    public static final ResourceKey<NoiseGeneratorSettings> DEEP_SEA = CDNoiseSettings.createNoiseGeneratorKey("deep_sea");
    public static final ResourceKey<NoiseGeneratorSettings> DESERT = CDNoiseSettings.createNoiseGeneratorKey("no_sea");
    public static final ResourceKey<NoiseGeneratorSettings> ARENA = CDNoiseSettings.createNoiseGeneratorKey("arena");
    public static final ResourceKey<NoiseGeneratorSettings> SOUL = CDNoiseSettings.createNoiseGeneratorKey("soul");
    public static final ResourceKey<NoiseGeneratorSettings> AIR = CDNoiseSettings.createNoiseGeneratorKey("air");
    private static final ResourceKey<DensityFunction> SHIFT_X = CDNoiseSettings.createKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = CDNoiseSettings.createKey("shift_z");
    public static final ResourceKey<DensityFunction> CONTINENTS = CDNoiseSettings.createKey("overworld/continents");
    public static final ResourceKey<DensityFunction> EROSION = CDNoiseSettings.createKey("overworld/erosion");
    public static final ResourceKey<DensityFunction> RIDGES = CDNoiseSettings.createKey("overworld/ridges");
    public static final ResourceKey<DensityFunction> FACTOR = CDNoiseSettings.createKey("overworld/factor");
    public static final ResourceKey<DensityFunction> DEPTH = CDNoiseSettings.createKey("overworld/depth");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = CDNoiseSettings.createKey("overworld/sloped_cheese");
    private static final ResourceKey<DensityFunction> MY_BASE_3D_NOISE_NETHER = ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm_dimension", (String)"nether/base_3d_noise"));

    private static ResourceKey<NoiseGeneratorSettings> createNoiseGeneratorKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm_dimension", (String)name));
    }

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> context) {
        HolderGetter densityFunctions = context.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noise = context.lookup(Registries.NOISE);
        context.register(PLAIN, (Object)CDNoiseSettings.plainNoise((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.register(SEA, (Object)CDNoiseSettings.overworldWithSeaLevel(context, false, false, 128));
        context.register(ARENA, (Object)CDNoiseSettings.arena((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.register(SOUL, (Object)CDNoiseSettings.arena((HolderGetter<DensityFunction>)densityFunctions, (HolderGetter<NormalNoise.NoiseParameters>)noise));
        context.register(AIR, (Object)new NoiseGeneratorSettings(new NoiseSettings(0, 128, 2, 1), Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero()), CDSurfaceRuleData.air(), List.of(), 0, true, false, false, true));
    }

    public static NoiseGeneratorSettings plainNoise(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(32, 256, 1, 2), Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), CDNoiseSettings.overworldZIP(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().spawnTarget(), 63, false, true, true, false);
    }

    public static NoiseGeneratorSettings plainDesert(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(32, 256, 1, 2), Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), CDNoiseSettings.overworldZIP(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().spawnTarget(), -128, false, true, true, false);
    }

    public static NoiseGeneratorSettings arena(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(0, 128, 1, 1), Blocks.NETHERRACK.defaultBlockState(), Blocks.LAVA.defaultBlockState(), CDNoiseSettings.nether(densityFunctions, noiseParameters), CDSurfaceRuleData.nether(), List.of(), 32, false, false, false, true);
    }

    public static NoiseGeneratorSettings soul(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(-128, 384, 1, 1), Blocks.NETHERRACK.defaultBlockState(), Blocks.LAVA.defaultBlockState(), CDNoiseSettings.soulNoiseRouter(densityFunctions, noiseParameters), CDSurfaceRuleData.nether(), List.of(), 64, false, false, false, true);
    }

    public static NoiseGeneratorSettings sunkenCity(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return new NoiseGeneratorSettings(new NoiseSettings(-128, 384, 1, 1), Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), CDNoiseSettings.overworldZIP2(densityFunctions, noiseParameters), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().spawnTarget(), 63, false, true, true, false);
    }

    public static NoiseGeneratorSettings overworldWithSeaLevel(BootstrapContext<?> context, boolean large, boolean amplified, int seaLevel) {
        return new NoiseGeneratorSettings(new NoiseSettings(-64, 384, 1, 2), Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), NoiseRouterData.overworld((HolderGetter)context.lookup(Registries.DENSITY_FUNCTION), (HolderGetter)context.lookup(Registries.NOISE), (boolean)amplified, (boolean)large), CDSurfaceRuleData.overworld(), new OverworldBiomeBuilder().spawnTarget(), seaLevel, false, true, true, false);
    }

    protected static NoiseRouter overworldZIP(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.5);
        DensityFunction $$5 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), (double)0.67);
        DensityFunction $$6 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.TEMPERATURE));
        DensityFunction $$11 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.VEGETATION));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction function0 = DensityFunctions.interpolated((DensityFunction)$$15);
        DensityFunction function = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-32, (int)256, (double)100.0, (double)-100.0), (DensityFunction)function0);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.add((DensityFunction)$$14, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-64.0, 64.0)), function, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    protected static NoiseRouter overworldZIP2(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.2);
        DensityFunction $$5 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), (double)0.37);
        DensityFunction $$6 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.TEMPERATURE));
        DensityFunction $$11 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.VEGETATION));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, CONTINENTS);
        DensityFunction function = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)-64, (int)0, (double)1.3, (double)-1.5), (DensityFunction)$$15);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.add((DensityFunction)$$14, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-32.0, 32.0)), function, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    protected static NoiseRouter soulNoiseRouter(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        DensityFunction $$4 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_BARRIER), (double)0.5);
        DensityFunction $$5 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS), (double)0.67);
        DensityFunction $$6 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD), (double)0.7142857142857143);
        DensityFunction $$7 = DensityFunctions.noise((Holder)noiseParameters.getOrThrow(Noises.AQUIFER_LAVA));
        DensityFunction $$8 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction $$9 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction $$10 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.TEMPERATURE));
        DensityFunction $$11 = DensityFunctions.shiftedNoise2d((DensityFunction)$$8, (DensityFunction)$$9, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.VEGETATION));
        DensityFunction $$12 = CDNoiseSettings.getFunction(densityFunctions, FACTOR);
        DensityFunction $$13 = CDNoiseSettings.getFunction(densityFunctions, DEPTH);
        DensityFunction $$14 = CDNoiseSettings.noiseGradientDensity(DensityFunctions.cache2d((DensityFunction)$$12), $$13);
        DensityFunction $$15 = CDNoiseSettings.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction function0 = DensityFunctions.interpolated((DensityFunction)$$15);
        return new NoiseRouter($$4, $$5, $$6, $$7, $$10, $$11, CDNoiseSettings.getFunction(densityFunctions, CONTINENTS), CDNoiseSettings.getFunction(densityFunctions, EROSION), $$13, CDNoiseSettings.getFunction(densityFunctions, RIDGES), CDNoiseSettings.slideOverworld(false, DensityFunctions.add((DensityFunction)$$14, (DensityFunction)DensityFunctions.constant((double)-0.703125)).clamp(-32.0, 32.0)), function0, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    protected static NoiseRouter nether(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters) {
        return CDNoiseSettings.noNewCaves(densityFunctions, noiseParameters, CDNoiseSettings.slideNetherLike(densityFunctions, 0, 128));
    }

    private static DensityFunction slideNetherLike(HolderGetter<DensityFunction> densityFunctions, int minY, int maxY) {
        return CDNoiseSettings.slide(CDNoiseSettings.getFunction(densityFunctions, MY_BASE_3D_NOISE_NETHER), minY, maxY, 24, 0, 0.9375, -8, 24, 2.5);
    }

    private static NoiseRouter noNewCaves(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noiseParameters, DensityFunction p_256378_) {
        DensityFunction densityfunction = CDNoiseSettings.getFunction(densityFunctions, SHIFT_X);
        DensityFunction densityfunction1 = CDNoiseSettings.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction densityfunction2 = DensityFunctions.shiftedNoise2d((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.TEMPERATURE));
        DensityFunction densityfunction3 = DensityFunctions.shiftedNoise2d((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noiseParameters.getOrThrow(Noises.VEGETATION));
        DensityFunction densityfunction4 = CDNoiseSettings.postProcess(p_256378_);
        return new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), densityfunction2, densityfunction3, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), densityfunction4, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static ResourceKey<DensityFunction> createKey(String location) {
        return ResourceKey.create((ResourceKey)Registries.DENSITY_FUNCTION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)location));
    }

    private static DensityFunction slideOverworld(boolean amplified, DensityFunction densityFunction) {
        return CDNoiseSettings.slide(densityFunction, -64, 384, amplified ? 16 : 80, amplified ? 0 : 64, -0.078125, 0, 24, amplified ? 0.4 : 0.1171875);
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction $$2 = DensityFunctions.mul((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)4.0), (DensityFunction)$$2.quarterNegative());
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction $$1 = DensityFunctions.blendDensity((DensityFunction)p_224493_);
        return DensityFunctions.mul((DensityFunction)DensityFunctions.interpolated((DensityFunction)$$1), (DensityFunction)DensityFunctions.constant((double)0.64)).squeeze();
    }

    private static DensityFunction slide(DensityFunction density, int minY, int maxY, int fromYTop, int toYTop, double offset1, int fromYBottom, int toYBottom, double offset2) {
        DensityFunction topSlide = DensityFunctions.yClampedGradient((int)(minY + maxY - fromYTop), (int)(minY + maxY - toYTop), (double)1.0, (double)0.0);
        density = DensityFunctions.lerp((DensityFunction)topSlide, (double)offset1, (DensityFunction)density);
        DensityFunction bottomSlide = DensityFunctions.yClampedGradient((int)(minY + fromYBottom), (int)(minY + toYBottom), (double)0.0, (double)1.0);
        return DensityFunctions.lerp((DensityFunction)bottomSlide, (double)offset2, (DensityFunction)density);
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> densityFunctions, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)densityFunctions.getOrThrow(key));
    }
}

