/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension.worldgen;

import com.google.common.collect.ImmutableList;
import com.p1nero.cataclysm_dimension.worldgen.CDBiomes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class CDSurfaceRuleData {
    private static final SurfaceRules.RuleSource AIR = CDSurfaceRuleData.makeStateRule(Blocks.AIR);
    private static final SurfaceRules.RuleSource BEDROCK = CDSurfaceRuleData.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource WHITE_TERRACOTTA = CDSurfaceRuleData.makeStateRule(Blocks.WHITE_TERRACOTTA);
    private static final SurfaceRules.RuleSource ORANGE_TERRACOTTA = CDSurfaceRuleData.makeStateRule(Blocks.ORANGE_TERRACOTTA);
    private static final SurfaceRules.RuleSource TERRACOTTA = CDSurfaceRuleData.makeStateRule(Blocks.TERRACOTTA);
    private static final SurfaceRules.RuleSource RED_SAND = CDSurfaceRuleData.makeStateRule(Blocks.RED_SAND);
    private static final SurfaceRules.RuleSource RED_SANDSTONE = CDSurfaceRuleData.makeStateRule(Blocks.RED_SANDSTONE);
    private static final SurfaceRules.RuleSource STONE = CDSurfaceRuleData.makeStateRule(Blocks.STONE);
    private static final SurfaceRules.RuleSource DEEPSLATE = CDSurfaceRuleData.makeStateRule(Blocks.DEEPSLATE);
    private static final SurfaceRules.RuleSource DIRT = CDSurfaceRuleData.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource PODZOL = CDSurfaceRuleData.makeStateRule(Blocks.PODZOL);
    private static final SurfaceRules.RuleSource COARSE_DIRT = CDSurfaceRuleData.makeStateRule(Blocks.COARSE_DIRT);
    private static final SurfaceRules.RuleSource MYCELIUM = CDSurfaceRuleData.makeStateRule(Blocks.MYCELIUM);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = CDSurfaceRuleData.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource CALCITE = CDSurfaceRuleData.makeStateRule(Blocks.CALCITE);
    private static final SurfaceRules.RuleSource GRAVEL = CDSurfaceRuleData.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SAND = CDSurfaceRuleData.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource SANDSTONE = CDSurfaceRuleData.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource PACKED_ICE = CDSurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource SNOW_BLOCK = CDSurfaceRuleData.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource MUD = CDSurfaceRuleData.makeStateRule(Blocks.MUD);
    private static final SurfaceRules.RuleSource POWDER_SNOW = CDSurfaceRuleData.makeStateRule(Blocks.POWDER_SNOW);
    private static final SurfaceRules.RuleSource ICE = CDSurfaceRuleData.makeStateRule(Blocks.ICE);
    private static final SurfaceRules.RuleSource WATER = CDSurfaceRuleData.makeStateRule(Blocks.WATER);
    private static final SurfaceRules.RuleSource LAVA = CDSurfaceRuleData.makeStateRule(Blocks.LAVA);
    private static final SurfaceRules.RuleSource NETHERRACK = CDSurfaceRuleData.makeStateRule(Blocks.NETHERRACK);
    private static final SurfaceRules.RuleSource SOUL_SAND = CDSurfaceRuleData.makeStateRule(Blocks.SOUL_SAND);
    private static final SurfaceRules.RuleSource SOUL_SOIL = CDSurfaceRuleData.makeStateRule(Blocks.SOUL_SOIL);
    private static final SurfaceRules.RuleSource BASALT = CDSurfaceRuleData.makeStateRule(Blocks.BASALT);
    private static final SurfaceRules.RuleSource BLACKSTONE = CDSurfaceRuleData.makeStateRule(Blocks.BLACKSTONE);
    private static final SurfaceRules.RuleSource WARPED_WART_BLOCK = CDSurfaceRuleData.makeStateRule(Blocks.WARPED_WART_BLOCK);
    private static final SurfaceRules.RuleSource WARPED_NYLIUM = CDSurfaceRuleData.makeStateRule(Blocks.WARPED_NYLIUM);
    private static final SurfaceRules.RuleSource NETHER_WART_BLOCK = CDSurfaceRuleData.makeStateRule(Blocks.NETHER_WART_BLOCK);
    private static final SurfaceRules.RuleSource CRIMSON_NYLIUM = CDSurfaceRuleData.makeStateRule(Blocks.CRIMSON_NYLIUM);
    private static final SurfaceRules.RuleSource ENDSTONE = CDSurfaceRuleData.makeStateRule(Blocks.END_STONE);

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    public static SurfaceRules.RuleSource overworld() {
        return CDSurfaceRuleData.overworldLike(true, false, true);
    }

    public static SurfaceRules.RuleSource overworldLike(boolean aboveGround, boolean bedrockRoof, boolean bedrockFloor) {
        SurfaceRules.ConditionSource surfacerules$conditionsource = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)97), (int)2);
        SurfaceRules.ConditionSource surfacerules$conditionsource1 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)256), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource2 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)-1);
        SurfaceRules.ConditionSource surfacerules$conditionsource3 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)74), (int)1);
        SurfaceRules.ConditionSource surfacerules$conditionsource4 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)60), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource5 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource6 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)63), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource7 = SurfaceRules.waterBlockCheck((int)-1, (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource8 = SurfaceRules.waterBlockCheck((int)0, (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource9 = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.ConditionSource surfacerules$conditionsource10 = SurfaceRules.hole();
        SurfaceRules.ConditionSource surfacerules$conditionsource11 = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN});
        SurfaceRules.ConditionSource surfacerules$conditionsource12 = SurfaceRules.steep();
        SurfaceRules.RuleSource surfacerules$rulesource = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});
        SurfaceRules.RuleSource surfacerules$rulesource1 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        SurfaceRules.RuleSource surfacerules$rulesource2 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)STONE), GRAVEL});
        SurfaceRules.ConditionSource surfacerules$conditionsource13 = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{CDBiomes.WARM_OCEAN, Biomes.WARM_OCEAN, Biomes.BEACH, Biomes.SNOWY_BEACH});
        SurfaceRules.ConditionSource surfacerules$conditionsource14 = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DESERT, CDBiomes.DESERT});
        SurfaceRules.RuleSource surfacerules$rulesource3 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.CALCITE, (double)-0.0125, (double)0.0125), (SurfaceRules.RuleSource)CALCITE), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.STONY_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL, (double)-0.05, (double)0.05), (SurfaceRules.RuleSource)surfacerules$rulesource2), STONE})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource13, (SurfaceRules.RuleSource)surfacerules$rulesource1), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource14, (SurfaceRules.RuleSource)surfacerules$rulesource1), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DRIPSTONE_CAVES}), (SurfaceRules.RuleSource)STONE)});
        SurfaceRules.RuleSource surfacerules$rulesource4 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.45, (double)0.58), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource surfacerules$rulesource5 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.POWDER_SNOW, (double)0.35, (double)0.6), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)POWDER_SNOW));
        SurfaceRules.RuleSource surfacerules$rulesource6 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.PACKED_ICE, (double)-0.5, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.ICE, (double)-0.0625, (double)0.025), (SurfaceRules.RuleSource)ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SNOWY_SLOPES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)STONE), surfacerules$rulesource4, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JAGGED_PEAKS}), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.GROVE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource4, DIRT})), surfacerules$rulesource3, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_GRAVELLY_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)surfacerules$rulesource2), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)DIRT), surfacerules$rulesource2})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP}), (SurfaceRules.RuleSource)MUD), DIRT});
        SurfaceRules.RuleSource surfacerules$rulesource7 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.PACKED_ICE, (double)0.0, (double)0.2), (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.ICE, (double)0.0, (double)0.025), (SurfaceRules.RuleSource)ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SNOWY_SLOPES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)STONE), surfacerules$rulesource5, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JAGGED_PEAKS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource12, (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.GROVE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource5, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)})), surfacerules$rulesource3, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_SAVANNA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(-0.5), (SurfaceRules.RuleSource)COARSE_DIRT)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WINDSWEPT_GRAVELLY_HILLS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(2.0), (SurfaceRules.RuleSource)surfacerules$rulesource2), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.0), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(-1.0), (SurfaceRules.RuleSource)surfacerules$rulesource), surfacerules$rulesource2})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(1.75), (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)CDSurfaceRuleData.surfaceNoiseAbove(-0.95), (SurfaceRules.RuleSource)PODZOL)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.ICE_SPIKES}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SNOW_BLOCK)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP}), (SurfaceRules.RuleSource)MUD), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MUSHROOM_FIELDS}), (SurfaceRules.RuleSource)MYCELIUM), surfacerules$rulesource});
        SurfaceRules.ConditionSource surfacerules$conditionsource15 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.909, (double)-0.5454);
        SurfaceRules.ConditionSource surfacerules$conditionsource16 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)-0.1818, (double)0.1818);
        SurfaceRules.ConditionSource surfacerules$conditionsource17 = SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)0.5454, (double)0.909);
        SurfaceRules.RuleSource surfacerules$rulesource8 = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WOODED_BADLANDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource15, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource16, (SurfaceRules.RuleSource)COARSE_DIRT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource17, (SurfaceRules.RuleSource)COARSE_DIRT), surfacerules$rulesource}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource5, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource6), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER)))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.MANGROVE_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource4, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource6), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.SWAMP, (double)0.0), (SurfaceRules.RuleSource)WATER))))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{CDBiomes.BADLANDS, Biomes.BADLANDS, Biomes.ERODED_BADLANDS, Biomes.WOODED_BADLANDS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource1, (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource15, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource16, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource17, (SurfaceRules.RuleSource)TERRACOTTA), SurfaceRules.bandlands()})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)RED_SANDSTONE), RED_SAND})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource10), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)WHITE_TERRACOTTA), surfacerules$rulesource2})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource6, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource3), (SurfaceRules.RuleSource)ORANGE_TERRACOTTA)), SurfaceRules.bandlands()})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)WHITE_TERRACOTTA))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)AIR), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.temperature(), (SurfaceRules.RuleSource)ICE), WATER}))), surfacerules$rulesource7}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource9, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)WATER))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)surfacerules$rulesource6), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource13, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SANDSTONE)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource14, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SANDSTONE))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.FROZEN_PEAKS, Biomes.JAGGED_PEAKS}), (SurfaceRules.RuleSource)STONE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{CDBiomes.WARM_OCEAN, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN}), (SurfaceRules.RuleSource)surfacerules$rulesource1), surfacerules$rulesource2}))});
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bedrockRoof) {
            builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)BEDROCK));
        }
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        SurfaceRules.RuleSource surfacerules$rulesource9 = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)surfacerules$rulesource8);
        builder.add((Object)(aboveGround ? surfacerules$rulesource9 : surfacerules$rulesource8));
        builder.add((Object)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8)), (SurfaceRules.RuleSource)DEEPSLATE));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource nether() {
        SurfaceRules.ConditionSource surfacerules$conditionsource = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)31), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource1 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)32), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource2 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)30), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource3 = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)35), (int)0));
        SurfaceRules.ConditionSource surfacerules$conditionsource4 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource5 = SurfaceRules.hole();
        SurfaceRules.ConditionSource surfacerules$conditionsource6 = SurfaceRules.noiseCondition((ResourceKey)Noises.SOUL_SAND_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource7 = SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource8 = SurfaceRules.noiseCondition((ResourceKey)Noises.PATCH, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource9 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHERRACK, (double)0.54);
        SurfaceRules.ConditionSource surfacerules$conditionsource10 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_WART, (double)1.17);
        SurfaceRules.ConditionSource surfacerules$conditionsource11 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_STATE_SELECTOR, (double)0.0);
        SurfaceRules.RuleSource surfacerules$rulesource = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)GRAVEL)));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)BEDROCK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource4, (SurfaceRules.RuleSource)NETHERRACK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.BASALT_DELTAS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)BASALT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)BASALT), BLACKSTONE}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{CDBiomes.SOUL_SAND_VALLEY, Biomes.SOUL_SAND_VALLEY}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SOUL_SAND), SOUL_SOIL})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SOUL_SAND), SOUL_SOIL}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource5, (SurfaceRules.RuleSource)LAVA)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WARPED_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource9), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)WARPED_WART_BLOCK), WARPED_NYLIUM})))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.CRIMSON_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource9), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)NETHER_WART_BLOCK), CRIMSON_NYLIUM}))))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{CDBiomes.NETHER_WASTES, Biomes.NETHER_WASTES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource6, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource5), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SOUL_SAND))), NETHERRACK}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource1, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource5), (SurfaceRules.RuleSource)GRAVEL)})))))})), NETHERRACK});
    }

    public static SurfaceRules.RuleSource end() {
        return ENDSTONE;
    }

    public static SurfaceRules.RuleSource air() {
        return AIR;
    }

    private static SurfaceRules.ConditionSource surfaceNoiseAbove(double value) {
        return SurfaceRules.noiseCondition((ResourceKey)Noises.SURFACE, (double)(value / 8.25), (double)Double.MAX_VALUE);
    }
}

