/*
 * Decompiled with CFR 0.152.
 */
package net.pastek.luckyblock.common.block.luckyblock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.fml.ModList;
import net.pastek.luckyblock.PastekLuckyBlock;
import net.pastek.luckyblock.prefab.configuration.LBConfigurationHandler;
import net.pastek.luckyblock.registers.LBBlocks;
import net.pastek.luckyblock.registers.LBSounds;
import org.jetbrains.annotations.NotNull;

public class LuckyBlock
extends Block {
    public static final EnumProperty<Variant> VARIANT = EnumProperty.create((String)"variant", Variant.class);
    private static final List<EntityType<? extends LivingEntity>> RANDOM_ENTITIES = List.of(EntityType.ALLAY, EntityType.ARMADILLO, EntityType.AXOLOTL, EntityType.BAT, EntityType.BEE, EntityType.BLAZE, EntityType.BOGGED, EntityType.BREEZE, EntityType.CAMEL, EntityType.CAT, EntityType.CAVE_SPIDER, EntityType.CHICKEN, EntityType.COD, EntityType.COPPER_GOLEM, EntityType.COW, EntityType.CREAKING, EntityType.CREEPER, EntityType.DOLPHIN, EntityType.DONKEY, EntityType.DROWNED, EntityType.ELDER_GUARDIAN, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.EVOKER, EntityType.FOX, EntityType.FROG, EntityType.GHAST, EntityType.GLOW_SQUID, EntityType.GOAT, EntityType.GUARDIAN, EntityType.HAPPY_GHAST, EntityType.HOGLIN, EntityType.HORSE, EntityType.ILLUSIONER, EntityType.IRON_GOLEM, EntityType.LLAMA, EntityType.MAGMA_CUBE, EntityType.MOOSHROOM, EntityType.MULE, EntityType.OCELOT, EntityType.PANDA, EntityType.PARROT, EntityType.PHANTOM, EntityType.PIG, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.PILLAGER, EntityType.POLAR_BEAR, EntityType.PUFFERFISH, EntityType.RABBIT, EntityType.RAVAGER, EntityType.SALMON, EntityType.SHEEP, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.SKELETON_HORSE, EntityType.SLIME, EntityType.SNIFFER, EntityType.SNOW_GOLEM, EntityType.SPIDER, EntityType.SQUID, EntityType.STRAY, EntityType.STRIDER, EntityType.TADPOLE, EntityType.TRADER_LLAMA, EntityType.TROPICAL_FISH, EntityType.TURTLE, EntityType.VEX, EntityType.VILLAGER, EntityType.VINDICATOR, EntityType.WANDERING_TRADER, EntityType.WITCH, EntityType.WITHER, EntityType.WITHER_SKELETON, EntityType.WOLF, EntityType.ZOGLIN, EntityType.ZOMBIE, EntityType.ZOMBIE_HORSE, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIFIED_PIGLIN);

    public LuckyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{VARIANT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean useCustom = (Boolean)LBConfigurationHandler.COMMON.luckyblockTexture.get();
        Variant variant = useCustom ? Variant.WATERMELON : Variant.DEFAULT;
        return (BlockState)this.defaultBlockState().setValue(VARIANT, (Comparable)((Object)variant));
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.spawnDestroyParticles(level, player, pos, state);
        level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
        this.generateRandomLoot(level, pos, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void generateRandomLoot(Level level, BlockPos pos, Player player) {
        int roll;
        int lucky;
        int good;
        int mid;
        if (level.isClientSide()) {
            return;
        }
        Random random = new Random();
        int bad = (Integer)LBConfigurationHandler.COMMON.badChance.get();
        int total = bad + (mid = ((Integer)LBConfigurationHandler.COMMON.midChance.get()).intValue()) + (good = ((Integer)LBConfigurationHandler.COMMON.goodChance.get()).intValue()) + (lucky = ((Integer)LBConfigurationHandler.COMMON.luckyChance.get()).intValue());
        if (total <= 0) {
            total = 1;
        }
        if ((roll = random.nextInt(total)) < bad) {
            this.generateBadLoot(level, pos, player, random);
        } else if (roll < bad + mid) {
            this.generateMidLoot(level, pos, player, random);
        } else if (roll < bad + mid + good) {
            this.generateGoodLoot(level, pos, player, random);
        } else {
            this.generateLuckyLoot(level, pos, player, random);
        }
    }

    private void generateBadLoot(Level level, BlockPos pos, Player player, Random random) {
        level.playSound(null, pos, (SoundEvent)LBSounds.SOUND_BADLOOT.get(), SoundSource.BLOCKS, 0.7f, 0.8f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.ANGRY_VILLAGER);
        LinkedHashMap<Runnable, Integer> badLootOptions = new LinkedHashMap<Runnable, Integer>();
        badLootOptions.put(() -> level.explode((Entity)player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5.0f, true, Level.ExplosionInteraction.TNT), 5);
        badLootOptions.put(() -> this.surroundWithFluid(level, player.blockPosition(), Blocks.LAVA), 2);
        badLootOptions.put(() -> this.surroundWithFluid(level, player.blockPosition(), Blocks.WATER), 2);
        badLootOptions.put(() -> this.spawnHostile((ServerLevel)level, pos, random, List.of(EntityType.WITHER, EntityType.WARDEN, EntityType.ELDER_GUARDIAN, EntityType.ILLUSIONER)), 1);
        badLootOptions.put(() -> this.rainAnvils(level, player.blockPosition().above(15)), 2);
        badLootOptions.put(() -> this.rideTntChicken((ServerLevel)level, player), 5);
        badLootOptions.put(() -> this.spawnMobColumn((ServerLevel)level, player.blockPosition(), EntityType.CREEPER, 10), 1);
        badLootOptions.put(() -> this.spawnMobColumn((ServerLevel)level, player.blockPosition(), EntityType.BLAZE, 10), 1);
        badLootOptions.put(() -> this.spawnMobColumn((ServerLevel)level, player.blockPosition(), EntityType.SILVERFISH, 10), 1);
        badLootOptions.put(() -> this.giveBadEffects(player), 1);
        badLootOptions.put(() -> player.push(0.0, 5.0, 0.0), 5);
        badLootOptions.put(() -> this.surroundFloor(level, player.blockPosition(), random), 1);
        badLootOptions.put(() -> this.trapInObsidianCage(level, player.blockPosition()), 5);
        badLootOptions.put(() -> this.scrambleBlocks(level, player.blockPosition(), random), 2);
        badLootOptions.put(() -> this.dripstoneTrap(level, player.blockPosition()), 1);
        badLootOptions.put(() -> LuckyBlock.giveRandomBadEffect(player, 300, 4), 3);
        badLootOptions.put(() -> this.spawnRaid((ServerLevel)level, player, pos), 5);
        badLootOptions.put(() -> this.spawnVindicator((ServerLevel)level, pos), 1);
        Runnable selected = (Runnable)this.getWeightedRandom(random, badLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateMidLoot(Level level, BlockPos pos, Player player, Random random) {
        level.playSound(null, pos, (SoundEvent)LBSounds.SOUND_MIDLOOT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.SMOKE);
        LinkedHashMap<Runnable, Integer> midLootOptions = new LinkedHashMap<Runnable, Integer>();
        midLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/mid_loot"), 10);
        midLootOptions.put(() -> this.spawnRandomEntity((ServerLevel)level, pos), 8);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENDER_PEARL, 3), new ItemStack((ItemLike)Items.ENDER_EYE)), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.LAVA_BUCKET), new ItemStack((ItemLike)Items.WATER_BUCKET)), 3);
        midLootOptions.put(() -> this.dropAllDyes(level, pos), 1);
        midLootOptions.put(() -> this.dropCopperArmor(level, pos), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.TNT, 4)), 3);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.BREAD, 5), new ItemStack((ItemLike)Items.APPLE, 3)), 3);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.REDSTONE, 15), new ItemStack((ItemLike)Items.REPEATER, 2)), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.FISHING_ROD), new ItemStack((ItemLike)Items.COD, 3)), 3);
        Runnable selected = (Runnable)this.getWeightedRandom(random, midLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateGoodLoot(Level level, BlockPos pos, Player player, Random random) {
        level.playSound(null, pos, SoundEvents.VILLAGER_CELEBRATE, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER);
        LinkedHashMap<Runnable, Integer> goodLootOptions = new LinkedHashMap<Runnable, Integer>();
        goodLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/good_loot"), 10);
        goodLootOptions.put(() -> {
            if (!level.isClientSide() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.placeRandomLootChest(serverLevel, pos, random);
            }
        }, 10);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND, 5), new ItemStack((ItemLike)Items.EMERALD, 3)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.GOLDEN_APPLE, 2)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.IRON_BLOCK, 4)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, 10)), 3);
        goodLootOptions.put(() -> this.dropDiamondGear(level, pos), 1);
        goodLootOptions.put(() -> this.dropGoldenPickaxe(level, pos), 1);
        goodLootOptions.put(() -> this.spawnDidier((ServerLevel)level, pos), 1);
        goodLootOptions.put(() -> LuckyBlock.giveRandomGoodEffect(player, 300, 4), 1);
        Runnable selected = (Runnable)this.getWeightedRandom(random, goodLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateLuckyLoot(Level level, BlockPos pos, Player player, Random random) {
        level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 1.0f, 1.2f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING);
        LinkedHashMap<Runnable, Integer> luckyLootOptions = new LinkedHashMap<Runnable, Integer>();
        luckyLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/lucky_loot"), 10);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.BEACON)), 2);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)LBBlocks.LUCKY_BLOCK.get(), 5), new ItemStack((ItemLike)Items.DIAMOND, 10)), 3);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.ENCHANTING_TABLE), new ItemStack((ItemLike)Items.BOOKSHELF, 18)), 3);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.NETHER_STAR)), 2);
        luckyLootOptions.put(() -> this.createExperienceShower(level, pos, random), 5);
        luckyLootOptions.put(() -> LuckyBlock.dropRandomEnchantedItem(level, pos), 6);
        Runnable selected = (Runnable)this.getWeightedRandom(random, luckyLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private <T> T getWeightedRandom(Random random, Map<T, Integer> items) {
        int totalWeight = items.values().stream().mapToInt(Integer::intValue).sum();
        int roll = random.nextInt(totalWeight);
        int cumulative = 0;
        for (Map.Entry<T, Integer> entry : items.entrySet()) {
            if (roll >= (cumulative += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void dropItems(Level level, BlockPos pos, ItemStack ... items) {
        for (ItemStack item : items) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)item);
        }
    }

    private void spawnLootChest(Level level, BlockPos pos, String lootTable) {
        if (level.isClientSide()) {
            return;
        }
        BlockPos chestPos = pos.above();
        level.setBlock(chestPos, Blocks.CHEST.defaultBlockState(), 3);
        BlockEntity blockEntity = level.getBlockEntity(chestPos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            ResourceLocation rl = PastekLuckyBlock.rl(lootTable);
            ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rl);
            chest.setLootTable(lootTableKey, level.getRandom().nextLong());
        }
    }

    private void spawnRandomEntity(ServerLevel level, BlockPos pos) {
        if (RANDOM_ENTITIES.isEmpty()) {
            return;
        }
        EntityType<? extends LivingEntity> type = RANDOM_ENTITIES.get(level.random.nextInt(RANDOM_ENTITIES.size()));
        LivingEntity entity = (LivingEntity)type.spawn(level, null, null, pos, EntitySpawnReason.TRIGGERED, true, true);
        if (entity != null) {
            entity.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            level.addFreshEntity((Entity)entity);
        }
    }

    private void trapInObsidianCage(Level level, BlockPos center) {
        int dz;
        int dy;
        int dx;
        for (dx = -2; dx <= 2; ++dx) {
            for (dy = 0; dy <= 3; ++dy) {
                for (dz = -2; dz <= 2; ++dz) {
                    if (dx >= -1 && dx <= 1 && dy >= 1 && dy <= 2 && dz >= -1 && dz <= 1) continue;
                    level.setBlock(center.offset(dx, dy, dz), Blocks.OBSIDIAN.defaultBlockState(), 3);
                }
            }
        }
        for (dx = -1; dx <= 1; ++dx) {
            for (dy = 1; dy <= 2; ++dy) {
                for (dz = -1; dz <= 1; ++dz) {
                    level.setBlock(center.offset(dx, dy, dz), Blocks.WATER.defaultBlockState(), 3);
                }
            }
        }
    }

    private void spawnParticles(Level level, BlockPos pos, ParticleOptions particle) {
        if (level.isClientSide()) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles(particle, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private void createExperienceShower(Level level, BlockPos pos, Random random) {
        int i;
        for (i = 0; i < 20; ++i) {
            level.addFreshEntity((Entity)new ExperienceOrb(level, (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 2.0, (double)(pos.getY() + 2) + random.nextDouble() * 3.0, (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 2.0, random.nextInt(10) + 5));
        }
        for (i = 0; i < 100; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pos.getX() + 0.5, (double)(pos.getY() + 2), (double)pos.getZ() + 0.5, 1.0, 2.0, 2.0);
        }
    }

    private void dropDiamondGear(Level level, BlockPos pos) {
        this.dropItems(level, pos, new ItemStack((ItemLike)Items.DIAMOND_SWORD), new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE));
    }

    private void dropCopperArmor(Level level, BlockPos pos) {
        ItemStack helmet = new ItemStack((ItemLike)Items.COPPER_HELMET);
        ItemStack chestplate = new ItemStack((ItemLike)Items.COPPER_CHESTPLATE);
        ItemStack leggings = new ItemStack((ItemLike)Items.COPPER_LEGGINGS);
        ItemStack boots = new ItemStack((ItemLike)Items.COPPER_BOOTS);
        for (ItemStack stack : List.of(helmet, chestplate, leggings, boots)) {
            stack.setDamageValue(stack.getMaxDamage() - 1);
        }
        this.dropItems(level, pos, helmet, chestplate, leggings, boots);
    }

    private void dropGoldenPickaxe(Level level, BlockPos pos) {
        ItemStack pickaxe = new ItemStack((ItemLike)Items.GOLDEN_PICKAXE);
        RegistryAccess registryAccess = level.registryAccess();
        Registry enchantmentRegistry = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference efficiency = enchantmentRegistry.getOrThrow(Enchantments.EFFICIENCY);
        pickaxe.enchant((Holder)efficiency, 7);
        this.dropItems(level, pos, pickaxe);
    }

    private void dropAllDyes(Level level, BlockPos pos) {
        for (DyeColor color : DyeColor.values()) {
            this.dropItems(level, pos, new ItemStack((ItemLike)DyeItem.byColor((DyeColor)color), 3));
        }
    }

    private void placeRandomLootChest(ServerLevel level, BlockPos pos, Random random) {
        List configTables = (List)LBConfigurationHandler.COMMON.lootTables.get();
        ArrayList<ResourceKey> available = new ArrayList<ResourceKey>();
        for (String tableId : configTables) {
            ResourceLocation rl = ResourceLocation.tryParse((String)tableId);
            if (rl == null) continue;
            String modid = rl.getNamespace();
            if (!ModList.get().isLoaded(modid)) {
                if (!((Boolean)LBConfigurationHandler.COMMON.debugLogging.get()).booleanValue()) continue;
                PastekLuckyBlock.LOGGER.debug("Skipping loot table '{}' because mod '{}' is not loaded", (Object)rl, (Object)modid);
                continue;
            }
            available.add(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rl));
        }
        if (available.isEmpty()) {
            ResourceKey fallback = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pastekluckyblock", (String)"chests/good_loot"));
            available.add(fallback);
            if (((Boolean)LBConfigurationHandler.COMMON.debugLogging.get()).booleanValue()) {
                PastekLuckyBlock.LOGGER.warn("No valid configured loot tables for chest at {}. Using fallback: {}", (Object)pos, (Object)fallback.location());
            }
        }
        ResourceKey chosen = (ResourceKey)available.get(random.nextInt(available.size()));
        if (((Boolean)LBConfigurationHandler.COMMON.debugLogging.get()).booleanValue()) {
            PastekLuckyBlock.LOGGER.info("Placing loot chest at {} with loot table: {}", (Object)pos, (Object)chosen.location());
        }
        BlockPos chestPos = pos.above();
        level.setBlock(chestPos, Blocks.CHEST.defaultBlockState(), 3);
        BlockEntity blockEntity = level.getBlockEntity(chestPos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.setLootTable(chosen, random.nextLong());
        }
    }

    private void dripstoneTrap(Level level, BlockPos center) {
        for (int i = 1; i <= 10; ++i) {
            BlockPos spike = center.above(i);
            level.setBlock(spike, Blocks.POINTED_DRIPSTONE.defaultBlockState(), 3);
        }
    }

    private void spawnRaid(ServerLevel level, Player player, BlockPos pos) {
        BlockPos playerPos = player.blockPosition();
        Villager nitwit = (Villager)EntityType.VILLAGER.spawn(level, null, null, pos, EntitySpawnReason.TRIGGERED, true, true);
        if (nitwit != null) {
            nitwit.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            nitwit.setVillagerData(new VillagerData(nitwit.getVillagerData().type(), nitwit.getVillagerData().profession(), nitwit.getVillagerData().level()));
            nitwit.setCustomName((Component)Component.literal((String)"Bob").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD));
            nitwit.setCustomNameVisible(true);
            level.addFreshEntity((Entity)nitwit);
        }
        List<EntityType> patrolEntities = List.of(EntityType.PILLAGER, EntityType.VINDICATOR, EntityType.EVOKER, EntityType.RAVAGER);
        RandomSource random = level.random;
        int patrolSize = 3 + random.nextInt(3);
        for (int i = 0; i < patrolSize; ++i) {
            EntityType type = patrolEntities.get(random.nextInt(patrolEntities.size()));
            Mob mob = (Mob)type.spawn(level, null, null, playerPos.offset(-5 + random.nextInt(11), 0, -5 + random.nextInt(11)), EntitySpawnReason.TRIGGERED, true, true);
            if (mob == null) continue;
            double offsetX = (random.nextDouble() - 0.5) * 6.0;
            double offsetZ = (random.nextDouble() - 0.5) * 6.0;
            BlockPos spawnPos = playerPos.offset((int)offsetX, 0, (int)offsetZ);
            mob.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            level.addFreshEntity((Entity)mob);
        }
    }

    private void scrambleBlocks(Level level, BlockPos center, Random random) {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -3; k <= 3; ++k) {
                    if (!(random.nextFloat() < 0.1f)) continue;
                    BlockPos target = center.offset(i, j, k);
                    level.setBlock(target, Blocks.COBWEB.defaultBlockState(), 3);
                }
            }
        }
    }

    private void surroundFloor(Level level, BlockPos center, Random random) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos target = center.offset(dx, -1, dz);
                if (random.nextBoolean()) {
                    level.setBlock(target, Blocks.MAGMA_BLOCK.defaultBlockState(), 3);
                    continue;
                }
                level.setBlock(target, Blocks.SOUL_SAND.defaultBlockState(), 3);
            }
        }
    }

    private static void giveRandomBadEffect(Player player, int duration, int amplifier) {
        List<Holder> BAD_EFFECTS = List.of(MobEffects.BLINDNESS, MobEffects.WEAKNESS, MobEffects.SLOWNESS, MobEffects.HUNGER, MobEffects.POISON, MobEffects.NAUSEA, MobEffects.LEVITATION);
        RandomSource random = player.level().getRandom();
        Holder effect = BAD_EFFECTS.get(random.nextInt(BAD_EFFECTS.size()));
        player.addEffect(new MobEffectInstance(effect, duration, amplifier));
    }

    private void giveBadEffects(Player player) {
        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
        player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200));
        player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 200, 1));
    }

    private static void giveRandomGoodEffect(Player player, int duration, int amplifier) {
        List<Holder> GOOD_EFFECTS = List.of(MobEffects.RESISTANCE, MobEffects.STRENGTH, MobEffects.SATURATION, MobEffects.LUCK, MobEffects.DOLPHINS_GRACE, MobEffects.FIRE_RESISTANCE, MobEffects.CONDUIT_POWER, MobEffects.NIGHT_VISION, MobEffects.HERO_OF_THE_VILLAGE, MobEffects.SPEED, MobEffects.HASTE);
        RandomSource random = player.level().getRandom();
        Holder effect = GOOD_EFFECTS.get(random.nextInt(GOOD_EFFECTS.size()));
        player.addEffect(new MobEffectInstance(effect, duration, amplifier));
    }

    private void spawnMobColumn(ServerLevel level, BlockPos base, EntityType<?> mobType, int height) {
        for (int i = 0; i < height; ++i) {
            BlockPos spawnPos = base.above(i);
            Entity entity = mobType.spawn(level, null, null, spawnPos, EntitySpawnReason.TRIGGERED, true, true);
            if (entity == null) continue;
            entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    private void spawnDidier(ServerLevel level, BlockPos pos) {
        Entity entity = EntityType.COPPER_GOLEM.spawn(level, null, null, pos, EntitySpawnReason.TRIGGERED, true, true);
        if (entity != null) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            entity.setCustomName((Component)Component.literal((String)"\u00a76Didier"));
            entity.setCustomNameVisible(true);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
            }
            level.addFreshEntity(entity);
        }
    }

    private void spawnVindicator(ServerLevel level, BlockPos pos) {
        Entity entity = EntityType.VINDICATOR.spawn(level, null, null, pos, EntitySpawnReason.TRIGGERED, true, true);
        if (entity != null) {
            entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
            }
            level.addFreshEntity(entity);
        }
    }

    private void rideTntChicken(ServerLevel level, Player player) {
        BlockPos pos = player.blockPosition().above();
        Chicken chicken = (Chicken)EntityType.CHICKEN.spawn(level, null, null, pos, EntitySpawnReason.TRIGGERED, true, true);
        PrimedTnt tnt = (PrimedTnt)EntityType.TNT.spawn(level, null, null, pos.above(), EntitySpawnReason.TRIGGERED, true, true);
        if (chicken != null && tnt != null) {
            chicken.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            tnt.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            level.addFreshEntity((Entity)chicken);
            level.addFreshEntity((Entity)tnt);
            tnt.startRiding((Entity)chicken);
        }
    }

    private void rainAnvils(Level level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            BlockPos drop = pos.offset(level.random.nextInt(5) - 2, i, level.random.nextInt(5) - 2);
            level.setBlock(drop, Blocks.ANVIL.defaultBlockState(), 3);
        }
    }

    private void spawnHostile(ServerLevel level, BlockPos pos, Random random, List<EntityType<?>> mobs) {
        if (mobs.isEmpty()) {
            return;
        }
        EntityType<?> type = mobs.get(random.nextInt(mobs.size()));
        Entity entity = type.spawn(level, null, null, pos.above(), EntitySpawnReason.TRIGGERED, true, true);
        if (entity != null) {
            entity.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            level.addFreshEntity(entity);
        }
    }

    private void surroundWithFluid(Level level, BlockPos center, Block fluid) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos target = center.offset(dx, 0, dz);
                if (!level.getBlockState(target).isAir()) continue;
                level.setBlock(target, fluid.defaultBlockState(), 3);
            }
        }
    }

    private static void dropRandomEnchantedItem(Level level, BlockPos pos) {
        HashMap<String, ItemStack> ITEMS = new HashMap<String, ItemStack>();
        ITEMS.put("helmet", new ItemStack((ItemLike)Items.NETHERITE_HELMET));
        ITEMS.put("chestplate", new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE));
        ITEMS.put("leggings", new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS));
        ITEMS.put("boots", new ItemStack((ItemLike)Items.NETHERITE_BOOTS));
        ITEMS.put("turtle_helmet", new ItemStack((ItemLike)Items.TURTLE_HELMET));
        ITEMS.put("sword", new ItemStack((ItemLike)Items.NETHERITE_SWORD));
        ITEMS.put("axe", new ItemStack((ItemLike)Items.NETHERITE_AXE));
        ITEMS.put("pickaxe", new ItemStack((ItemLike)Items.NETHERITE_PICKAXE));
        ITEMS.put("shovel", new ItemStack((ItemLike)Items.NETHERITE_SHOVEL));
        ITEMS.put("hoe", new ItemStack((ItemLike)Items.NETHERITE_HOE));
        ITEMS.put("bow", new ItemStack((ItemLike)Items.BOW));
        ITEMS.put("crossbow", new ItemStack((ItemLike)Items.CROSSBOW));
        ITEMS.put("trident", new ItemStack((ItemLike)Items.TRIDENT));
        ITEMS.put("shield", new ItemStack((ItemLike)Items.SHIELD));
        ITEMS.put("elytra", new ItemStack((ItemLike)Items.ELYTRA));
        ArrayList keys = new ArrayList(ITEMS.keySet());
        RandomSource random = level.getRandom();
        String type = (String)keys.get(random.nextInt(keys.size()));
        ItemStack item = ((ItemStack)ITEMS.get(type)).copy();
        HashMap<Holder.Reference, Integer> enchants = new HashMap<Holder.Reference, Integer>();
        RegistryAccess registryAccess = level.registryAccess();
        Registry enchantmentRegistry = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference protection = enchantmentRegistry.getOrThrow(Enchantments.PROTECTION);
        Holder.Reference unbreaking = enchantmentRegistry.getOrThrow(Enchantments.UNBREAKING);
        Holder.Reference mending = enchantmentRegistry.getOrThrow(Enchantments.MENDING);
        Holder.Reference efficiency = enchantmentRegistry.getOrThrow(Enchantments.EFFICIENCY);
        Holder.Reference sharpness = enchantmentRegistry.getOrThrow(Enchantments.SHARPNESS);
        Holder.Reference fireAspect = enchantmentRegistry.getOrThrow(Enchantments.FIRE_ASPECT);
        Holder.Reference looting = enchantmentRegistry.getOrThrow(Enchantments.LOOTING);
        Holder.Reference loyalty = enchantmentRegistry.getOrThrow(Enchantments.LOYALTY);
        Holder.Reference channeling = enchantmentRegistry.getOrThrow(Enchantments.CHANNELING);
        Holder.Reference riptide = enchantmentRegistry.getOrThrow(Enchantments.RIPTIDE);
        Holder.Reference thorns = enchantmentRegistry.getOrThrow(Enchantments.THORNS);
        switch (type.toLowerCase()) {
            case "helmet": 
            case "chestplate": 
            case "leggings": 
            case "boots": 
            case "turtle_helmet": {
                enchants.put(protection, 4);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                enchants.put(thorns, 3);
                if (type.equalsIgnoreCase("helmet") || type.equalsIgnoreCase("turtle_helmet")) {
                    Holder.Reference respiration = enchantmentRegistry.getOrThrow(Enchantments.RESPIRATION);
                    Holder.Reference aquaAffinity = enchantmentRegistry.getOrThrow(Enchantments.AQUA_AFFINITY);
                    enchants.put(respiration, 3);
                    enchants.put(aquaAffinity, 1);
                }
                if (!type.equalsIgnoreCase("boots")) break;
                Holder.Reference fallProt = enchantmentRegistry.getOrThrow(Enchantments.FEATHER_FALLING);
                Holder.Reference depthStrider = enchantmentRegistry.getOrThrow(Enchantments.DEPTH_STRIDER);
                Holder.Reference frostWalker = enchantmentRegistry.getOrThrow(Enchantments.FROST_WALKER);
                enchants.put(fallProt, 4);
                enchants.put(depthStrider, 3);
                enchants.put(frostWalker, 2);
                break;
            }
            case "sword": {
                enchants.put(sharpness, 5);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                enchants.put(fireAspect, 2);
                enchants.put(looting, 3);
                break;
            }
            case "axe": {
                enchants.put(efficiency, 5);
                enchants.put(sharpness, 5);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                break;
            }
            case "pickaxe": 
            case "shovel": 
            case "hoe": {
                Holder.Reference fortune = enchantmentRegistry.getOrThrow(Enchantments.FORTUNE);
                enchants.put(efficiency, 5);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                enchants.put(fortune, 3);
                break;
            }
            case "bow": {
                Holder.Reference power = enchantmentRegistry.getOrThrow(Enchantments.POWER);
                Holder.Reference punch = enchantmentRegistry.getOrThrow(Enchantments.PUNCH);
                Holder.Reference flamingArrows = enchantmentRegistry.getOrThrow(Enchantments.FLAME);
                enchants.put(power, 5);
                enchants.put(punch, 2);
                enchants.put(flamingArrows, 1);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                break;
            }
            case "crossbow": {
                Holder.Reference quickCharge = enchantmentRegistry.getOrThrow(Enchantments.QUICK_CHARGE);
                Holder.Reference multishot = enchantmentRegistry.getOrThrow(Enchantments.MULTISHOT);
                Holder.Reference piercing = enchantmentRegistry.getOrThrow(Enchantments.PIERCING);
                enchants.put(quickCharge, 3);
                enchants.put(multishot, 1);
                enchants.put(piercing, 4);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                break;
            }
            case "trident": {
                enchants.put(loyalty, 3);
                enchants.put(channeling, 1);
                enchants.put(riptide, 3);
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
                break;
            }
            case "shield": 
            case "elytra": {
                enchants.put(unbreaking, 3);
                enchants.put(mending, 1);
            }
        }
        ItemEnchantments.Mutable itemEnchants = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)item));
        for (Map.Entry entry : enchants.entrySet()) {
            itemEnchants.set((Holder)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        EnchantmentHelper.setEnchantments((ItemStack)item, (ItemEnchantments)itemEnchants.toImmutable());
        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)item);
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT("default"),
        WATERMELON("watermelon");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static Variant fromName(String name) {
            for (Variant v : Variant.values()) {
                if (!v.name.equalsIgnoreCase(name)) continue;
                return v;
            }
            return DEFAULT;
        }
    }
}

