/*
 * Decompiled with CFR 0.152.
 */
package net.pastek.luckyblock.common.block.luckyblock;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.pastek.luckyblock.PastekLuckyBlock;
import net.pastek.luckyblock.prefab.configuration.LBConfigurationHandler;
import net.pastek.luckyblock.registers.LBBlocks;
import net.pastek.luckyblock.registers.LBSounds;
import org.jetbrains.annotations.NotNull;

public class LuckyBlock
extends Block {
    public static final EnumProperty<Variant> VARIANT = EnumProperty.m_61587_((String)"variant", Variant.class);

    public LuckyBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VARIANT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean useCustom = (Boolean)LBConfigurationHandler.COMMON.luckyblockTexture.get();
        Variant variant = useCustom ? Variant.WATERMELON : Variant.DEFAULT;
        return (BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)variant));
    }

    public void m_5707_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        this.m_142387_(level, player, pos, state);
        level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        this.generateRandomLoot(level, pos, player);
    }

    private void generateRandomLoot(Level level, BlockPos pos, Player player) {
        int roll;
        int lucky;
        int good;
        int mid;
        if (level.f_46443_) {
            return;
        }
        Random random = new Random();
        int bad = (Integer)LBConfigurationHandler.COMMON.badChance.get();
        int total = bad + (mid = ((Integer)LBConfigurationHandler.COMMON.midChance.get()).intValue()) + (good = ((Integer)LBConfigurationHandler.COMMON.goodChance.get()).intValue()) + (lucky = ((Integer)LBConfigurationHandler.COMMON.luckyChance.get()).intValue());
        if (total <= 0) {
            total = 1;
        }
        if ((roll = random.nextInt(total)) < bad) {
            this.generateBadLoot(level, pos, player, random);
        } else if (roll < bad + mid) {
            this.generateMidLoot(level, pos, player, random);
        } else if (roll < bad + mid + good) {
            this.generateGoodLoot(level, pos, player, random);
        } else {
            this.generateLuckyLoot(level, pos, player, random);
        }
    }

    private void generateBadLoot(Level level, BlockPos pos, Player player, Random random) {
        level.m_5594_(null, pos, (SoundEvent)LBSounds.SOUND_BADLOOT.get(), SoundSource.BLOCKS, 0.7f, 0.8f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.f_123792_);
        LinkedHashMap<Runnable, Integer> badLootOptions = new LinkedHashMap<Runnable, Integer>();
        badLootOptions.put(() -> level.m_255391_((Entity)player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Level.ExplosionInteraction.TNT), 5);
        badLootOptions.put(() -> this.surroundWithFluid(level, player.m_20183_(), Blocks.f_49991_), 2);
        badLootOptions.put(() -> this.surroundWithFluid(level, player.m_20183_(), Blocks.f_49990_), 2);
        badLootOptions.put(() -> this.spawnHostile(level, pos, random, List.of(EntityType.f_20496_, EntityType.f_217015_, EntityType.f_20563_, EntityType.f_20459_)), 1);
        badLootOptions.put(() -> this.rainAnvils(level, player.m_20183_().m_6630_(15)), 2);
        badLootOptions.put(() -> this.rideTntChicken(level, player), 5);
        badLootOptions.put(() -> this.spawnMobColumn(level, player.m_20183_(), EntityType.f_20558_, 10), 1);
        badLootOptions.put(() -> this.spawnMobColumn(level, player.m_20183_(), EntityType.f_20551_, 10), 1);
        badLootOptions.put(() -> this.spawnMobColumn(level, player.m_20183_(), EntityType.f_20523_, 10), 1);
        badLootOptions.put(() -> this.giveBadEffects(player), 1);
        badLootOptions.put(() -> player.m_5997_(0.0, 5.0, 0.0), 5);
        badLootOptions.put(() -> this.surroundFloor(level, player.m_20183_(), random), 1);
        badLootOptions.put(() -> this.trapInObsidianCage(level, player.m_20183_()), 5);
        badLootOptions.put(() -> this.scrambleBlocks(level, player.m_20183_(), random), 2);
        badLootOptions.put(() -> this.dripstoneTrap(level, player.m_20183_()), 1);
        badLootOptions.put(() -> LuckyBlock.giveRandomBadEffect(player, 300, 4), 3);
        badLootOptions.put(() -> this.spawnRaid((ServerLevel)level, player, pos), 5);
        Runnable selected = (Runnable)this.getWeightedRandom(random, badLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateMidLoot(Level level, BlockPos pos, Player player, Random random) {
        level.m_5594_(null, pos, (SoundEvent)LBSounds.SOUND_MIDLOOT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.f_123762_);
        LinkedHashMap<Runnable, Integer> midLootOptions = new LinkedHashMap<Runnable, Integer>();
        midLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/mid_loot"), 10);
        midLootOptions.put(() -> this.spawnRandomEntity(level, pos), 8);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42584_, 3), new ItemStack((ItemLike)Items.f_42545_)), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42448_), new ItemStack((ItemLike)Items.f_42447_)), 3);
        midLootOptions.put(() -> this.dropAllDyes(level, pos), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_41996_, 4)), 3);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42406_, 5), new ItemStack((ItemLike)Items.f_42410_, 3)), 3);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42451_, 15), new ItemStack((ItemLike)Items.f_42350_, 2)), 1);
        midLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42523_), new ItemStack((ItemLike)Items.f_42526_, 3)), 3);
        Runnable selected = (Runnable)this.getWeightedRandom(random, midLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateGoodLoot(Level level, BlockPos pos, Player player, Random random) {
        level.m_5594_(null, pos, SoundEvents.f_12504_, SoundSource.BLOCKS, 0.8f, 1.0f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.f_123748_);
        LinkedHashMap<Runnable, Integer> goodLootOptions = new LinkedHashMap<Runnable, Integer>();
        goodLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/good_loot"), 10);
        goodLootOptions.put(() -> {
            if (!level.f_46443_ && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.placeRandomLootChest(serverLevel, pos, random);
            }
        }, 10);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42415_, 5), new ItemStack((ItemLike)Items.f_42616_, 3)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42436_, 2)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_41913_, 4)), 2);
        goodLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42612_, 10)), 3);
        goodLootOptions.put(() -> this.dropDiamondGear(level, pos), 1);
        goodLootOptions.put(() -> LuckyBlock.giveRandomGoodEffect(player, 300, 4), 1);
        Runnable selected = (Runnable)this.getWeightedRandom(random, goodLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private void generateLuckyLoot(Level level, BlockPos pos, Player player, Random random) {
        level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.2f);
        this.spawnParticles(level, pos, (ParticleOptions)ParticleTypes.f_123767_);
        LinkedHashMap<Runnable, Integer> luckyLootOptions = new LinkedHashMap<Runnable, Integer>();
        luckyLootOptions.put(() -> this.spawnLootChest(level, pos, "chests/lucky_loot"), 10);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42065_)), 2);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)LBBlocks.LUCKY_BLOCK.get(), 5), new ItemStack((ItemLike)Items.f_42415_, 10)), 3);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42100_), new ItemStack((ItemLike)Items.f_41997_, 18)), 3);
        luckyLootOptions.put(() -> this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42686_)), 2);
        luckyLootOptions.put(() -> this.createExperienceShower(level, pos, random), 5);
        luckyLootOptions.put(() -> LuckyBlock.dropRandomEnchantedItem(level, pos), 6);
        Runnable selected = (Runnable)this.getWeightedRandom(random, luckyLootOptions);
        if (selected != null) {
            selected.run();
        }
    }

    private <T> T getWeightedRandom(Random random, Map<T, Integer> items) {
        int totalWeight = items.values().stream().mapToInt(Integer::intValue).sum();
        int roll = random.nextInt(totalWeight);
        int cumulative = 0;
        for (Map.Entry<T, Integer> entry : items.entrySet()) {
            if (roll >= (cumulative += entry.getValue().intValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void dropItems(Level level, BlockPos pos, ItemStack ... items) {
        for (ItemStack item : items) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)item);
        }
    }

    private void spawnLootChest(Level level, BlockPos pos, String lootTable) {
        if (level.f_46443_) {
            return;
        }
        BlockPos chestPos = pos.m_7494_();
        level.m_7731_(chestPos, Blocks.f_50087_.m_49966_(), 3);
        BlockEntity blockEntity = level.m_7702_(chestPos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.m_59626_(PastekLuckyBlock.rl(lootTable), level.m_213780_().m_188505_());
        }
    }

    private void spawnRandomEntity(Level level, BlockPos pos) {
        List<EntityType> mobs = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(t -> t.m_20615_(level) instanceof LivingEntity).toList();
        EntityType type = mobs.get(level.f_46441_.m_188503_(mobs.size()));
        Entity e = type.m_20615_(level);
        if (e != null) {
            e.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_(e);
        }
    }

    private void trapInObsidianCage(Level level, BlockPos center) {
        int dz;
        int dy;
        int dx;
        for (dx = -2; dx <= 2; ++dx) {
            for (dy = 0; dy <= 3; ++dy) {
                for (dz = -2; dz <= 2; ++dz) {
                    if (dx >= -1 && dx <= 1 && dy >= 1 && dy <= 2 && dz >= -1 && dz <= 1) continue;
                    level.m_7731_(center.m_7918_(dx, dy, dz), Blocks.f_50080_.m_49966_(), 3);
                }
            }
        }
        for (dx = -1; dx <= 1; ++dx) {
            for (dy = 1; dy <= 2; ++dy) {
                for (dz = -1; dz <= 1; ++dz) {
                    level.m_7731_(center.m_7918_(dx, dy, dz), Blocks.f_49990_.m_49966_(), 3);
                }
            }
        }
    }

    private void spawnParticles(Level level, BlockPos pos, ParticleOptions particle) {
        if (level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(particle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 20, 0.5, 0.5, 0.5, 0.1);
        }
    }

    private void createExperienceShower(Level level, BlockPos pos, Random random) {
        int i;
        for (i = 0; i < 20; ++i) {
            level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_() + 0.5 + (random.nextDouble() - 0.5) * 2.0, (double)(pos.m_123342_() + 2) + random.nextDouble() * 3.0, (double)pos.m_123343_() + 0.5 + (random.nextDouble() - 0.5) * 2.0, random.nextInt(10) + 5));
        }
        for (i = 0; i < 100; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 2), (double)pos.m_123343_() + 0.5, 1.0, 2.0, 2.0);
        }
    }

    private void dropDiamondGear(Level level, BlockPos pos) {
        this.dropItems(level, pos, new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)Items.f_42473_));
    }

    private void dropAllDyes(Level level, BlockPos pos) {
        for (DyeColor color : DyeColor.values()) {
            this.dropItems(level, pos, new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)color), 3));
        }
    }

    private void placeRandomLootChest(ServerLevel level, BlockPos pos, Random random) {
        List configTables = (List)LBConfigurationHandler.COMMON.lootTables.get();
        ArrayList<ResourceLocation> available = new ArrayList<ResourceLocation>();
        for (String tableId : configTables) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)tableId);
            if (rl == null) continue;
            ResourceLocation path = ResourceLocation.fromNamespaceAndPath((String)rl.m_135827_(), (String)("loot_tables/" + rl.m_135815_() + ".json"));
            try {
                InputStream resource = level.m_7654_().m_177941_().m_215595_(path);
                try {
                    if (resource == null) continue;
                    available.add(rl);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (Exception exception) {}
        }
        if (available.isEmpty() && ((Boolean)LBConfigurationHandler.COMMON.debugLogging.get()).booleanValue()) {
            PastekLuckyBlock.LOGGER.warn("No valid loot tables found for chest at {}", (Object)pos);
            return;
        }
        ResourceLocation chosen = (ResourceLocation)available.get(random.nextInt(available.size()));
        if (((Boolean)LBConfigurationHandler.COMMON.debugLogging.get()).booleanValue()) {
            PastekLuckyBlock.LOGGER.info("Placing loot chest at {} with loot table: {}", (Object)pos, (Object)chosen);
        }
        BlockPos chestPos = pos.m_7494_();
        level.m_7731_(chestPos, Blocks.f_50087_.m_49966_(), 3);
        BlockEntity blockEntity = level.m_7702_(chestPos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            chest.m_59626_(chosen, random.nextLong());
        }
    }

    private void dripstoneTrap(Level level, BlockPos center) {
        for (int i = 1; i <= 10; ++i) {
            BlockPos spike = center.m_6630_(i);
            level.m_7731_(spike, Blocks.f_152588_.m_49966_(), 3);
        }
    }

    private void spawnRaid(ServerLevel level, Player player, BlockPos pos) {
        BlockPos playerPos = player.m_20183_();
        Villager nitwit = (Villager)EntityType.f_20492_.m_20615_((Level)level);
        if (nitwit != null) {
            nitwit.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            nitwit.m_34375_(nitwit.m_7141_().m_35565_(VillagerProfession.f_35596_));
            nitwit.m_6593_((Component)Component.m_237113_((String)"Bob").m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.BOLD));
            nitwit.m_20340_(true);
            level.m_7967_((Entity)nitwit);
        }
        List<EntityType> patrolEntities = List.of(EntityType.f_20513_, EntityType.f_20493_, EntityType.f_20568_, EntityType.f_20518_);
        RandomSource random = level.f_46441_;
        int patrolSize = 3 + random.m_188503_(3);
        for (int i = 0; i < patrolSize; ++i) {
            EntityType type = patrolEntities.get(random.m_188503_(patrolEntities.size()));
            Mob mob = (Mob)type.m_20615_((Level)level);
            if (mob == null) continue;
            double offsetX = (random.m_188500_() - 0.5) * 6.0;
            double offsetZ = (random.m_188500_() - 0.5) * 6.0;
            BlockPos spawnPos = playerPos.m_7918_((int)(-5.0 + offsetX), 0, (int)offsetZ);
            mob.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)mob);
        }
    }

    private void scrambleBlocks(Level level, BlockPos center, Random random) {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -3; k <= 3; ++k) {
                    if (!(random.nextFloat() < 0.1f)) continue;
                    BlockPos target = center.m_7918_(i, j, k);
                    level.m_7731_(target, Blocks.f_50033_.m_49966_(), 3);
                }
            }
        }
    }

    private void surroundFloor(Level level, BlockPos center, Random random) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                BlockPos target = center.m_7918_(dx, -1, dz);
                if (random.nextBoolean()) {
                    level.m_7731_(target, Blocks.f_50450_.m_49966_(), 3);
                    continue;
                }
                level.m_7731_(target, Blocks.f_50135_.m_49966_(), 3);
            }
        }
    }

    private static void giveRandomBadEffect(Player player, int duration, int amplifier) {
        List<MobEffect> BAD_EFFECTS = List.of(MobEffects.f_19610_, MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19612_, MobEffects.f_19614_, MobEffects.f_19604_, MobEffects.f_19620_);
        Random RANDOM = new Random();
        MobEffect effect = BAD_EFFECTS.get(RANDOM.nextInt(BAD_EFFECTS.size()));
        player.m_7292_(new MobEffectInstance(effect, duration, amplifier));
    }

    private void giveBadEffects(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1));
    }

    private static void giveRandomGoodEffect(Player player, int duration, int amplifier) {
        List<MobEffect> GOOD_EFFECTS = List.of(MobEffects.f_19606_, MobEffects.f_19600_, MobEffects.f_19618_, MobEffects.f_19621_, MobEffects.f_19593_, MobEffects.f_19607_, MobEffects.f_19592_, MobEffects.f_19611_, MobEffects.f_19595_, MobEffects.f_19596_, MobEffects.f_19598_);
        Random RANDOM = new Random();
        MobEffect effect = GOOD_EFFECTS.get(RANDOM.nextInt(GOOD_EFFECTS.size()));
        player.m_7292_(new MobEffectInstance(effect, duration, amplifier));
    }

    private void spawnMobColumn(Level level, BlockPos base, EntityType<?> mob, int height) {
        for (int i = 0; i < height; ++i) {
            Entity e = mob.m_20615_(level);
            if (e == null) continue;
            e.m_7678_((double)base.m_123341_() + 0.5, (double)(base.m_123342_() + i), (double)base.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_(e);
        }
    }

    private void rideTntChicken(Level level, Player player) {
        Chicken chicken = (Chicken)EntityType.f_20555_.m_20615_(level);
        PrimedTnt tnt = (PrimedTnt)EntityType.f_20515_.m_20615_(level);
        if (chicken != null && tnt != null) {
            BlockPos pos = player.m_20183_().m_7494_();
            chicken.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            tnt.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)chicken);
            level.m_7967_((Entity)tnt);
            tnt.m_7998_((Entity)chicken, true);
        }
    }

    private void rainAnvils(Level level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            BlockPos drop = pos.m_7918_(level.f_46441_.m_188503_(5) - 2, i, level.f_46441_.m_188503_(5) - 2);
            level.m_7731_(drop, Blocks.f_50322_.m_49966_(), 3);
        }
    }

    private void spawnHostile(Level level, BlockPos pos, Random random, List<EntityType<?>> mobs) {
        EntityType<?> type = mobs.get(random.nextInt(mobs.size()));
        Entity e = type.m_20615_(level);
        if (e != null) {
            e.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_(e);
        }
    }

    private void surroundWithFluid(Level level, BlockPos center, Block fluid) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos target = center.m_7918_(dx, 0, dz);
                if (!level.m_8055_(target).m_60795_()) continue;
                level.m_7731_(target, fluid.m_49966_(), 3);
            }
        }
    }

    private static void dropRandomEnchantedItem(Level level, BlockPos pos) {
        HashMap<String, ItemStack> ITEMS = new HashMap<String, ItemStack>();
        ITEMS.put("helmet", new ItemStack((ItemLike)Items.f_42480_));
        ITEMS.put("chestplate", new ItemStack((ItemLike)Items.f_42481_));
        ITEMS.put("leggings", new ItemStack((ItemLike)Items.f_42482_));
        ITEMS.put("boots", new ItemStack((ItemLike)Items.f_42483_));
        ITEMS.put("turtle_helmet", new ItemStack((ItemLike)Items.f_42354_));
        ITEMS.put("sword", new ItemStack((ItemLike)Items.f_42393_));
        ITEMS.put("axe", new ItemStack((ItemLike)Items.f_42396_));
        ITEMS.put("pickaxe", new ItemStack((ItemLike)Items.f_42395_));
        ITEMS.put("shovel", new ItemStack((ItemLike)Items.f_42394_));
        ITEMS.put("hoe", new ItemStack((ItemLike)Items.f_42397_));
        ITEMS.put("bow", new ItemStack((ItemLike)Items.f_42411_));
        ITEMS.put("crossbow", new ItemStack((ItemLike)Items.f_42717_));
        ITEMS.put("trident", new ItemStack((ItemLike)Items.f_42713_));
        ITEMS.put("shield", new ItemStack((ItemLike)Items.f_42740_));
        ITEMS.put("elytra", new ItemStack((ItemLike)Items.f_42741_));
        ArrayList keys = new ArrayList(ITEMS.keySet());
        Random random = new Random();
        String type = (String)keys.get(random.nextInt(keys.size()));
        ItemStack item = ((ItemStack)ITEMS.get(type)).m_41777_();
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        switch (type.toLowerCase()) {
            case "helmet": 
            case "chestplate": 
            case "leggings": 
            case "boots": 
            case "turtle_helmet": {
                enchants.put(Enchantments.f_44965_, 4);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                enchants.put(Enchantments.f_44972_, 3);
                if (type.equalsIgnoreCase("helmet") || type.equalsIgnoreCase("turtle_helmet")) {
                    enchants.put(Enchantments.f_44970_, 3);
                    enchants.put(Enchantments.f_44971_, 1);
                }
                if (!type.equalsIgnoreCase("boots")) break;
                enchants.put(Enchantments.f_44967_, 4);
                enchants.put(Enchantments.f_44973_, 3);
                enchants.put(Enchantments.f_44974_, 2);
                break;
            }
            case "sword": {
                enchants.put(Enchantments.f_44977_, 5);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                enchants.put(Enchantments.f_44981_, 2);
                enchants.put(Enchantments.f_44982_, 3);
                break;
            }
            case "axe": {
                enchants.put(Enchantments.f_44984_, 5);
                enchants.put(Enchantments.f_44977_, 5);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                break;
            }
            case "pickaxe": 
            case "shovel": 
            case "hoe": {
                enchants.put(Enchantments.f_44984_, 5);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                enchants.put(Enchantments.f_44987_, 3);
                break;
            }
            case "bow": {
                enchants.put(Enchantments.f_44988_, 5);
                enchants.put(Enchantments.f_44989_, 2);
                enchants.put(Enchantments.f_44990_, 1);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                break;
            }
            case "crossbow": {
                enchants.put(Enchantments.f_44960_, 3);
                enchants.put(Enchantments.f_44959_, 1);
                enchants.put(Enchantments.f_44961_, 4);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                break;
            }
            case "trident": {
                enchants.put(Enchantments.f_44955_, 3);
                enchants.put(Enchantments.f_44958_, 1);
                enchants.put(Enchantments.f_44957_, 3);
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
                break;
            }
            case "shield": 
            case "elytra": {
                enchants.put(Enchantments.f_44986_, 3);
                enchants.put(Enchantments.f_44962_, 1);
            }
        }
        EnchantmentHelper.m_44865_(enchants, (ItemStack)item);
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)item);
    }

    public static enum Variant implements StringRepresentable
    {
        DEFAULT("default"),
        WATERMELON("watermelon");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static Variant fromName(String name) {
            for (Variant v : Variant.values()) {
                if (!v.name.equalsIgnoreCase(name)) continue;
                return v;
            }
            return DEFAULT;
        }
    }
}

