/*
 * Decompiled with CFR 0.152.
 */
package net.pastek.luckyblock.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pastek.luckyblock.datagen.LBBlockLootTableProvider;
import net.pastek.luckyblock.datagen.LBBlockStateProvider;
import net.pastek.luckyblock.datagen.LBBlockTagProvider;
import net.pastek.luckyblock.datagen.LBDatapackProvider;
import net.pastek.luckyblock.datagen.LBItemModelProvider;
import net.pastek.luckyblock.datagen.LBItemTagProvider;

@Mod.EventBusSubscriber(modid="pastekluckyblock", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LBBlockLootTableProvider::new, LootContextParamSets.f_81421_))));
        LBBlockTagProvider blockTagsProvider = new LBBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new LBItemTagProvider(packOutput, lookupProvider, blockTagsProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LBItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LBBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LBDatapackProvider(packOutput, lookupProvider));
    }
}

