/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.kinetics.grindstone;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.advancements.AdvancementBehaviour;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindingRecipe;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.GrindstoneHelper;
import plus.dragons.createenchantmentindustry.common.kinetics.grindstone.MechanicalGrindstoneBlock;
import plus.dragons.createenchantmentindustry.common.registry.CEIAdvancements;
import plus.dragons.createenchantmentindustry.common.registry.CEIFluids;
import plus.dragons.createenchantmentindustry.common.registry.CEIRecipes;
import plus.dragons.createenchantmentindustry.common.registry.CEIStats;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@FieldsNullabilityUnknownByDefault
public class GrindstoneDrainBlockEntity
extends KineticBlockEntity {
    public static final int GRINDING_TIME = 20;
    public ProcessingInventory inventory;
    private ItemStack processedItem = ItemStack.EMPTY;
    protected SmartFluidTankBehaviour tank;
    private DirectBeltInputBehaviour beltInput;
    private AdvancementBehaviour advancement;

    public GrindstoneDrainBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                int space = GrindstoneDrainBlockEntity.this.tank.getPrimaryHandler().getSpace();
                int a = GrindstoneHelper.getExperienceFromItem(stack);
                int b = GrindstoneHelper.getExperienceFromGrindingRecipe(GrindstoneDrainBlockEntity.this.level, stack);
                if (a > space || b > space) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 3000) {
                    ItemStack result = this.getStackInSlot(0);
                    this.clear();
                    return result;
                }
                return ItemStack.EMPTY;
            }
        }.withSlotLimit(true);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((Integer)CEIConfig.fluids().mechanicalGrindstoneFluidCapacity.get()));
        this.beltInput = new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnels();
        this.advancement = new AdvancementBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.tank);
        behaviours.add((BlockEntityBehaviour)this.beltInput);
        behaviours.add((BlockEntityBehaviour)this.advancement);
    }

    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction side) {
        if (side != Direction.DOWN) {
            return this.inventory;
        }
        return null;
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (side == ((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite() || side == null) {
            return this.tank.getCapability();
        }
        return null;
    }

    private Direction getOutputSide() {
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        float speed = facing == Direction.WEST || facing == Direction.NORTH ? this.getSpeed() * -1.0f : this.getSpeed();
        return speed > 0.0f ? facing.getClockWise() : facing.getCounterClockWise();
    }

    public float getRelativeSpeed() {
        assert (this.level != null);
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return 0.0f;
        }
        BlockPos above = this.worldPosition.above();
        BlockState aboveState = this.level.getBlockState(above);
        Block block = aboveState.getBlock();
        if (!(block instanceof MechanicalGrindstoneBlock)) {
            return 0.0f;
        }
        MechanicalGrindstoneBlock grinderWheel = (MechanicalGrindstoneBlock)block;
        Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (grinderWheel.getRotationAxis(aboveState) != facing.getAxis()) {
            return 0.0f;
        }
        float aboveSpeed = grinderWheel.getBlockEntityOptional((BlockGetter)this.level, above).map(KineticBlockEntity::getSpeed).orElse(Float.valueOf(0.0f)).floatValue();
        if (speed > 0.0f) {
            return aboveSpeed < 0.0f ? Math.min(speed, -aboveSpeed) : 0.0f;
        }
        return aboveSpeed > 0.0f ? Math.min(-speed, aboveSpeed) : 0.0f;
    }

    private int getProcessDuration(ItemStack inputStack) {
        assert (this.level != null);
        RecipeManager recipeManager = this.level.getRecipeManager();
        SingleRecipeInput input = new SingleRecipeInput(inputStack);
        int sizeModifier = Math.max(1, inputStack.getCount() / 5);
        Optional grinding = recipeManager.getRecipeFor(CEIRecipes.GRINDING.getType(), (RecipeInput)input, this.level);
        if (grinding.isPresent()) {
            return ((GrindingRecipe)((RecipeHolder)grinding.get()).value()).getProcessingDuration() * sizeModifier;
        }
        if (recipeManager.getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (RecipeInput)input, this.level).isPresent()) {
            return 50 * sizeModifier;
        }
        if (GrindstoneHelper.canItemBeGrinded(inputStack, ItemStack.EMPTY)) {
            return 50 * sizeModifier;
        }
        return 10;
    }

    private boolean fill(FluidStack fluid) {
        if (this.tank.getPrimaryHandler().fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()) {
            this.tank.getPrimaryHandler().fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    private boolean drain(SizedFluidIngredient fluidIngredient) {
        FluidStack fluid = this.tank.getPrimaryHandler().getFluid();
        int required = fluidIngredient.amount();
        if (fluidIngredient.test(fluid) && fluid.getAmount() >= required) {
            fluid.shrink(required);
            this.tank.getPrimaryHandler().setFluid(fluid);
            return true;
        }
        return false;
    }

    private void start(ItemStack inputStack) {
        assert (this.level != null);
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        this.inventory.remainingTime = this.inventory.recipeDuration = (float)this.getProcessDuration(inputStack);
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    private void applyRecipe() {
        GrindstoneHelper.Result result;
        FluidStack fluid;
        Optional polishing;
        assert (this.level != null);
        RecipeManager recipeManager = this.level.getRecipeManager();
        ItemStack inputStack = this.inventory.getStackInSlot(0);
        SingleRecipeInput input = new SingleRecipeInput(inputStack);
        Optional grinding = SequencedAssemblyRecipe.getRecipe((Level)this.level, (RecipeInput)input, (RecipeType)CEIRecipes.GRINDING.getType(), GrindingRecipe.class);
        if (grinding.isEmpty()) {
            grinding = recipeManager.getRecipeFor(CEIRecipes.GRINDING.getType(), (RecipeInput)input, this.level);
        }
        if (grinding.isPresent()) {
            GrindingRecipe recipe = (GrindingRecipe)((RecipeHolder)grinding.get()).value();
            NonNullList fluidIngredients = recipe.getFluidIngredients();
            NonNullList fluidResults = recipe.getFluidResults();
            boolean applicable = true;
            if (!fluidIngredients.isEmpty()) {
                applicable = this.drain((SizedFluidIngredient)fluidIngredients.getFirst());
            } else if (!fluidResults.isEmpty()) {
                boolean bl = applicable = this.tank.getPrimaryHandler().fill((FluidStack)fluidResults.getFirst(), IFluidHandler.FluidAction.SIMULATE) == ((FluidStack)fluidResults.getFirst()).getAmount();
            }
            if (applicable) {
                if (((FluidStack)fluidResults.getFirst()).is(CEIFluids.EXPERIENCE)) {
                    this.advancement.awardStat((ResourceLocation)CEIStats.GRINDSTONE_EXPERIENCE.get(), ((FluidStack)fluidResults.getFirst()).getAmount());
                }
                this.inventory.clear();
                List grinded = recipe.rollResults(this.level.random);
                for (int i = 0; i < grinded.size(); ++i) {
                    this.inventory.setStackInSlot(i + 1, (ItemStack)grinded.get(i));
                }
                return;
            }
        }
        if ((polishing = recipeManager.getRecipeFor(AllRecipeTypes.SANDPAPER_POLISHING.getType(), (RecipeInput)input, this.level)).isPresent() && AllRecipeTypes.CAN_BE_AUTOMATED.test((RecipeHolder)polishing.get())) {
            ItemStack polished = ((SandPaperPolishingRecipe)((RecipeHolder)polishing.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
            this.advancement.trigger(CEIAdvancements.GRIND_TO_POLISH.builtinTrigger());
            this.inventory.clear();
            this.inventory.setStackInSlot(1, polished);
            return;
        }
        Optional<GrindstoneHelper.Result> grindstone = GrindstoneHelper.grindItem(this.level, inputStack, ItemStack.EMPTY);
        if (grindstone.isPresent() && this.fill(fluid = new FluidStack(CEIFluids.EXPERIENCE, (result = grindstone.get()).experience()))) {
            this.advancement.trigger(CEIAdvancements.GONE_WITH_THE_FOIL.builtinTrigger());
            this.advancement.awardStat((ResourceLocation)CEIStats.GRINDSTONE_EXPERIENCE.get(), fluid.getAmount());
            this.inventory.clear();
            this.inventory.setStackInSlot(0, result.top());
            this.inventory.setStackInSlot(1, result.bottom());
            this.inventory.setStackInSlot(2, result.output());
        }
    }

    private void spawnProcessedParticles(ItemStack stack) {
        ItemParticleOption particleData;
        assert (this.level != null);
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            particleData = new BlockParticleOption(ParticleTypes.BLOCK, blockItem.getBlock().defaultBlockState());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.ITEM, stack);
        }
        Vec3 pos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)this.level.random, (float)0.125f);
            this.level.addParticle((ParticleOptions)particleData, pos.x, pos.y, pos.z, motion.x, motion.y, motion.y);
        }
    }

    private void spawnProcessingParticles(ItemStack stack) {
        float speed;
        ItemParticleOption particleData;
        assert (this.level != null);
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            particleData = new BlockParticleOption(ParticleTypes.BLOCK, blockItem.getBlock().defaultBlockState());
            speed = 1.0f;
        } else {
            particleData = new ItemParticleOption(ParticleTypes.ITEM, stack);
            speed = 0.125f;
        }
        Vec3 pos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0);
        Direction inputSide = this.getOutputSide().getOpposite();
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.level.addParticle((ParticleOptions)particleData, pos.x + (double)((float)inputSide.getStepX() * offset), pos.y, pos.z + (double)((float)inputSide.getStepZ() * offset), (double)((float)inputSide.getStepX() * speed), (double)(this.level.random.nextFloat() * speed), (double)((float)inputSide.getStepZ() * speed));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        if (clientPacket && !this.processedItem.isEmpty()) {
            compound.put("ProcessedItem", this.processedItem.saveOptional(registries));
            this.processedItem = ItemStack.EMPTY;
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        if (compound.contains("ProcessedItem")) {
            this.processedItem = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("ProcessedItem"));
        }
    }

    public void destroy() {
        super.destroy();
        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.processedItem);
        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.inventory.extractItem(3000, 64, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        assert (this.level != null);
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.processedItem.isEmpty()) {
            this.spawnProcessedParticles(this.processedItem);
            this.processedItem = ItemStack.EMPTY;
            this.level.levelEvent(1042, this.worldPosition, 0);
        }
    }

    public void tick() {
        assert (this.level != null);
        super.tick();
        float processingSpeed = this.getRelativeSpeed();
        if (processingSpeed == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        processingSpeed = Mth.clamp((float)(processingSpeed / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnProcessingParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            this.processedItem = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Direction outputSide = this.getOutputSide();
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack toFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty() || (toFunnel = this.beltInput.tryExportingToBeltFunnel(stack, outputSide.getOpposite(), false)) == null) continue;
            if (toFunnel.getCount() != stack.getCount()) {
                this.inventory.setStackInSlot(slot, toFunnel);
                this.notifyUpdate();
                return;
            }
            if (toFunnel.isEmpty()) continue;
            return;
        }
        BlockPos outputPos = this.worldPosition.relative(outputSide);
        DirectBeltInputBehaviour outputTarget = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)outputPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (outputTarget != null) {
            boolean changed = false;
            if (!outputTarget.canInsertFromSide(outputSide)) {
                return;
            }
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.isEmpty() || ItemStack.matches((ItemStack)(remainder = outputTarget.handleInsertion(stack, outputSide, false)), (ItemStack)stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.setChanged();
                this.sendData();
            }
            return;
        }
        Vec3 itemMovement = Vec3.atLowerCornerOf((Vec3i)outputSide.getNormal());
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(itemMovement.scale(0.5).add(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.scale(0.0625).add(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            ItemEntity entityIn = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, stack);
            entityIn.setDeltaMovement(outMotion);
            this.level.addFreshEntity((Entity)entityIn);
        }
        this.inventory.clear();
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        this.inventory.remainingTime = -1.0f;
        this.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return added |= this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
    }
}

