/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.mixin;

import com.simibubi.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.createdragonsplus.common.fluids.tank.FluidTankBehaviour;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;

@Mixin(value={SmartBlockEntity.class})
public abstract class SmartBlockEntityMixin
extends CachedRenderBBBlockEntity {
    @Shadow
    @Nullable
    public abstract <T extends BlockEntityBehaviour> T getBehaviour(BehaviourType<T> var1);

    @Shadow
    public abstract Collection<BlockEntityBehaviour> getAllBehaviours();

    public SmartBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"destroy"}, at={@At(value="HEAD")})
    private void setRemoved$dropExperienceFluid(CallbackInfo ci) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = this.getBlockState();
        for (BlockEntityBehaviour behaviour : this.getAllBehaviours()) {
            IFluidHandler handler;
            if (behaviour instanceof SmartFluidTankBehaviour) {
                SmartFluidTankBehaviour tank = (SmartFluidTankBehaviour)behaviour;
                handler = tank.getCapability();
            } else {
                if (!(behaviour instanceof FluidTankBehaviour)) continue;
                FluidTankBehaviour tank = (FluidTankBehaviour)behaviour;
                handler = tank.getCapability();
            }
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluid = handler.getFluidInTank(tank);
                int experience = ExperienceHelper.getExperienceFromFluid(fluid);
                if (experience <= 0) continue;
                state.getBlock().popExperience(serverLevel, this.worldPosition, experience);
            }
        }
    }
}

