/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.common.fluids.experience;

import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import plus.dragons.createdragonsplus.common.fluids.SolidRenderFluidType;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

public class ExperienceFluidType
extends SolidRenderFluidType {
    protected ExperienceFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int tintColor, Vector3f fogColor, Supplier<Float> fogDistanceModifier) {
        super(properties, stillTexture, flowingTexture, tintColor, fogColor, fogDistanceModifier);
    }

    public static FluidBuilder.FluidTypeFactory create() {
        Vector3f fogColor = new Color(5420620).asVectorF();
        return (properties, stillTexture, flowingTexture) -> new ExperienceFluidType(properties, stillTexture, flowingTexture, -1, fogColor, ExperienceFluidType::getExperienceFluidVisibility);
    }

    private static float getExperienceFluidVisibility() {
        return CEIConfig.client().experienceVisionMultiplier.getF() / 32.0f;
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return (Boolean)CEIConfig.server().fluids.experienceVaporizeOnPlacement.get();
    }

    public void onVaporize(@Nullable Player player, Level level, BlockPos pos, FluidStack stack) {
        level.playSound(player, pos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.5f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)pos.getCenter(), (int)ExperienceHelper.getExperienceFromFluid(stack));
        }
    }
}

