/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.mixin;

import com.simibubi.create.AllBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.createenchantmentindustry.common.fluids.experience.BlazeExperienceBlockEntity;
import plus.dragons.createenchantmentindustry.common.registry.CEIBlocks;
import plus.dragons.createenchantmentindustry.config.CEIConfig;

@Mixin(value={LightningBolt.class})
public abstract class LightningBoltMixin
extends Entity {
    @Shadow
    protected abstract BlockPos getStrikePosition();

    private LightningBoltMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;clearCopperOnLightningStrike(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V")})
    private void tick$chargeExperienceOnLightingStrike(CallbackInfo ci) {
        BlockPos pos;
        if (!this.getPersistentData().getBoolean("ExperienceCharge") && (double)this.random.nextFloat() > (Double)CEIConfig.processing().regularLightningStrikeTransformXpBlockChance.get()) {
            return;
        }
        Level level = this.level();
        BlockState blockstate = level.getBlockState(pos = this.getStrikePosition());
        if (blockstate.is(BlazeExperienceBlockEntity.LIGHTNING_ROD_BLOCKS)) {
            pos = pos.relative(((Direction)blockstate.getValue((Property)LightningRodBlock.FACING)).getOpposite());
            blockstate = level.getBlockState(pos);
        }
        if (blockstate.is((Holder)AllBlocks.EXPERIENCE_BLOCK)) {
            level.setBlockAndUpdate(pos, CEIBlocks.SUPER_EXPERIENCE_BLOCK.getDefaultState());
            BlockPos.MutableBlockPos mutable = pos.mutable();
            int i = level.random.nextInt(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = level.random.nextInt(8) + 1;
                LightningBoltMixin.tick$randomWalkChargeExperience(level, pos, mutable, k);
            }
        }
    }

    @Unique
    private static void tick$randomWalkChargeExperience(Level level, BlockPos pos, BlockPos.MutableBlockPos mutable, int steps) {
        Optional<BlockPos> optional;
        mutable.set((Vec3i)pos);
        for (int i = 0; i < steps && !(optional = LightningBoltMixin.tick$randomWalkChargeExperience(level, (BlockPos)mutable)).isEmpty(); ++i) {
            mutable.set((Vec3i)optional.get());
        }
    }

    @Unique
    private static Optional<BlockPos> tick$randomWalkChargeExperience(Level level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.randomInCube((RandomSource)level.random, (int)10, (BlockPos)pos, (int)1)) {
            BlockState blockstate = level.getBlockState(blockpos);
            if (!blockstate.is((Holder)AllBlocks.EXPERIENCE_BLOCK)) continue;
            level.setBlockAndUpdate(blockpos, CEIBlocks.SUPER_EXPERIENCE_BLOCK.getDefaultState());
            level.levelEvent(3002, blockpos, -1);
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }
}

