/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.dragonLibLegacy.advancement.critereon;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.antlr.v4.runtime.misc.NotNull;

public class AccumulativeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public AccumulativeTrigger(ResourceLocation pId) {
        this.id = pId;
    }

    @NotNull
    protected TriggerInstance createInstance(JsonObject pJson, @NotNull ContextAwarePredicate player, @NotNull DeserializationContext pContext) {
        MinMaxBounds.Ints requirements = MinMaxBounds.Ints.m_55373_((JsonElement)pJson.get("requirement"));
        return new TriggerInstance(this.id, player, requirements);
    }

    public void trigger(Player pPlayer, int change) {
        this.m_66234_((ServerPlayer)pPlayer, triggerInstance -> triggerInstance.matches(this.id, pPlayer, change));
    }

    @NotNull
    public ResourceLocation m_7295_() {
        return this.id;
    }

    private static AccumulativeData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client world.");
        }
        ServerLevel serverWorld = level.m_7654_().m_129783_();
        DimensionDataStorage dimensionSavedDataManager = serverWorld.m_8895_();
        return (AccumulativeData)dimensionSavedDataManager.m_164861_(AccumulativeData::load, AccumulativeData::new, "accumulative_data");
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints requirement;

        public TriggerInstance(ResourceLocation pCriterion, ContextAwarePredicate player, MinMaxBounds.Ints requirement) {
            super(pCriterion, player);
            this.requirement = requirement;
        }

        public boolean matches(ResourceLocation resourceLocation, Player player, int change) {
            AccumulativeData data = AccumulativeTrigger.get(player.m_9236_());
            data.change(resourceLocation, player.m_20148_(), change);
            return this.requirement.m_55390_(data.get(resourceLocation, player.m_20148_()));
        }

        @NotNull
        public JsonObject m_7683_(@NotNull SerializationContext pConditions) {
            JsonObject jsonObject = super.m_7683_(pConditions);
            jsonObject.add("requirement", this.requirement.m_55328_());
            return jsonObject;
        }
    }

    private static class AccumulativeData
    extends SavedData {
        public Table<ResourceLocation, UUID, Integer> data = HashBasedTable.create();

        public void change(ResourceLocation resourceLocation, UUID playerId, int i) {
            Integer temp = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            temp = temp == null ? 0 : temp;
            temp = temp + i;
            this.data.put((Object)resourceLocation, (Object)playerId, (Object)temp);
            this.m_77762_();
        }

        public int get(ResourceLocation resourceLocation, UUID playerId) {
            Integer ret = (Integer)this.data.get((Object)resourceLocation, (Object)playerId);
            return ret == null ? 0 : ret;
        }

        public static AccumulativeData load(CompoundTag compoundNBT) {
            AccumulativeData ret = new AccumulativeData();
            if (!compoundNBT.m_128441_("AccumulativeData")) {
                return ret;
            }
            List list = NBTHelper.readCompoundList((ListTag)((ListTag)compoundNBT.m_128423_("AccumulativeData")), c -> new TriCell(NBTHelper.readResourceLocation((CompoundTag)c, (String)"TriggerId"), c.m_128342_("PlayerId"), c.m_128451_("Count")));
            list.forEach(triCell -> ret.data.put((Object)triCell.rl, (Object)triCell.id, (Object)triCell.i));
            return ret;
        }

        public CompoundTag m_7176_(CompoundTag pCompoundTag) {
            ListTag dataListTag = NBTHelper.writeCompoundList(this.data.cellSet().stream().toList(), cell -> {
                CompoundTag ret = new CompoundTag();
                NBTHelper.writeResourceLocation((CompoundTag)ret, (String)"TriggerId", (ResourceLocation)((ResourceLocation)cell.getRowKey()));
                ret.m_128362_("PlayerId", (UUID)cell.getColumnKey());
                ret.m_128405_("Count", ((Integer)cell.getValue()).intValue());
                return ret;
            });
            pCompoundTag.m_128365_("AccumulativeData", (Tag)dataListTag);
            return pCompoundTag;
        }

        private record TriCell(ResourceLocation rl, UUID id, int i) {
        }
    }
}

