/*
 * Decompiled with CFR 0.152.
 */
package com.aguga.horsespawn.config;

import com.aguga.horsespawn.HorseSpawn;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class ConfigLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    private static File getFile(String filename) {
        return FabricLoader.getInstance().getConfigDir().resolve(filename).toFile();
    }

    @NotNull
    public static <T> T load(Class<T> clazz, String filename) {
        Optional.ofNullable(HorseSpawn.LOGGER).ifPresent(l -> l.trace("loading config {}", (Object)filename));
        File file = ConfigLoader.getFile(filename);
        Object config = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                config = GSON.fromJson((Reader)reader, clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (config == null) {
            try {
                config = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        ConfigLoader.save(config, filename);
        return (T)config;
    }

    public static <T> void save(T config, String filename) {
        Optional.ofNullable(HorseSpawn.LOGGER).ifPresent(l -> l.trace("saving config {}", (Object)filename));
        File file = ConfigLoader.getFile(filename);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            System.err.println("Failed to create a directory for " + String.valueOf(file));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

