/*
 * Decompiled with CFR 0.152.
 */
package com.aguga.horsespawn.main;

import com.aguga.horsespawn.main.config.ConfigManager;
import com.aguga.horsespawn.main.config.HorseSpawnConfig;
import com.aguga.horsespawn.main.util.IPlayerDataSaver;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorseSpawn
implements ModInitializer {
    public static final String MOD_ID = "horse-spawn";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"horse-spawn");
    public static HorseSpawnConfig CONFIG = ConfigManager.register(HorseSpawnConfig.class, "horse-spawn.json", newConf -> {
        CONFIG = newConf;
    });

    public void onInitialize() {
        LOGGER.info("Successfully initialized Horse Spawn!");
        ServerPlayConnectionEvents.JOIN.register(this::spawnHorseForPlayer);
    }

    private void spawnHorseForPlayer(class_3244 serverPlayNetworkHandler, PacketSender packetSender, MinecraftServer minecraftServer) {
        class_3222 player = serverPlayNetworkHandler.method_32311();
        class_3218 serverWorld = (class_3218)player.method_5770();
        if (!this.shouldSpawn((class_1657)player, minecraftServer.method_3790())) {
            return;
        }
        class_1297 rawEntity = ((class_1299)class_7923.field_41177.method_10223(class_2960.method_60655((String)"minecraft", (String)HorseSpawn.CONFIG.spawnType.toLowerCase()))).method_5883((class_1937)serverWorld);
        if (!(rawEntity instanceof class_1309)) {
            return;
        }
        class_1309 entity = (class_1309)rawEntity;
        this.applyAttributes(entity);
        this.equipSaddle(entity);
        this.setTamed(entity);
        entity.method_33574(this.getEntityCoordinates(player.method_31477(), player.method_31479(), (class_1937)serverWorld));
        serverWorld.method_8649((class_1297)entity);
    }

    private boolean shouldSpawn(class_1657 player, class_1934 gameMode) {
        if (!HorseSpawn.CONFIG.spawnInCreative && gameMode == class_1934.field_9220) {
            return false;
        }
        IPlayerDataSaver playerDataSaver = (IPlayerDataSaver)player;
        if (HorseSpawn.CONFIG.spawnOnce && playerDataSaver.getHasSpawnedHorse()) {
            return false;
        }
        playerDataSaver.setHasSpawnedHorse(true);
        return true;
    }

    private void equipSaddle(class_1309 entity) {
        if (entity instanceof class_1496) {
            class_1496 horseEntity = (class_1496)entity;
            if (HorseSpawn.CONFIG.enableSaddle) {
                horseEntity.method_6576(new class_1799((class_1935)class_1802.field_8175), class_3419.field_15254);
            }
        }
        if (entity instanceof class_1492) {
            class_1492 donkeyEntity = (class_1492)entity;
            if (HorseSpawn.CONFIG.enableChest) {
                donkeyEntity.method_6704(true);
            }
        }
    }

    private void applyAttributes(class_1309 entity) {
        if (entity instanceof class_1496) {
            class_1496 horseEntity = (class_1496)entity;
            class_1937 world = entity.method_5770();
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                horseEntity.method_5943((class_5425)serverWorld, serverWorld.method_8404(horseEntity.method_24515()), class_3730.field_16471, null);
            }
        }
        if (!HorseSpawn.CONFIG.overwriteStats) {
            return;
        }
        if (entity.method_5996(class_5134.field_23719) != null) {
            entity.method_5996(class_5134.field_23719).method_6192(this.blocksPerSecToSpeed(HorseSpawn.CONFIG.speed));
        }
        if (entity.method_5996(class_5134.field_23728) != null) {
            entity.method_5996(class_5134.field_23728).method_6192(this.jumpHeightToJumpStrength(HorseSpawn.CONFIG.jump));
        }
        if (entity.method_5996(class_5134.field_23716) != null) {
            entity.method_5996(class_5134.field_23716).method_6192((double)HorseSpawn.CONFIG.health);
        }
    }

    private void setTamed(class_1309 entity) {
        if (entity instanceof class_1496) {
            class_1496 horseEntity = (class_1496)entity;
            horseEntity.method_6766(true);
        }
    }

    public double blocksPerSecToSpeed(double blocksPerSec) {
        return blocksPerSec / 42.157796;
    }

    public double jumpStrengthToJumpHeight(double strength) {
        double height = 0.0;
        while (strength > 0.0) {
            height += strength;
            strength = (strength - 0.08) * 0.98 * 0.98;
        }
        return height;
    }

    public double jumpHeightToJumpStrength(double height) {
        double tol = 1.0E-4;
        double low = 0.0;
        double high = 1.0;
        int expandLimit = 50;
        int expands = 0;
        while (this.jumpStrengthToJumpHeight(high) < height && expands++ < expandLimit) {
            high *= 2.0;
        }
        for (int i = 0; i < 20; ++i) {
            double mid = (low + high) / 2.0;
            double midHeight = this.jumpStrengthToJumpHeight(mid);
            if (Math.abs(midHeight - height) <= tol) {
                return mid;
            }
            if (midHeight < height) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return (low + high) / 2.0;
    }

    public class_243 getEntityCoordinates(int playerX, int playerZ, class_1937 world) {
        Random random = new Random();
        int[][] offsets = new int[][]{{8, 0}, {6, 6}, {0, 8}, {-6, 6}, {-8, 0}, {-6, -6}, {0, -8}, {6, -6}};
        int[] selectedOffset = offsets[random.nextInt(offsets.length)];
        int newX = playerX + selectedOffset[0];
        int newZ = playerZ + selectedOffset[1];
        int chunkX = newX >> 4;
        int chunkZ = newZ >> 4;
        world.method_8402(chunkX, chunkZ, class_2806.field_12803, true);
        int topY = world.method_8624(class_2902.class_2903.field_13203, newX, newZ);
        return new class_243((double)newX, (double)topY, (double)newZ);
    }
}

